/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.defaultresources.impl;

import com.google.common.collect.Sets;
import dev.lukebemish.defaultresources.impl.AutoMetadataPackResources;
import dev.lukebemish.defaultresources.impl.DefaultResources;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_7367;
import net.minecraft.class_9224;
import org.apache.commons.io.IOUtils;
import org.jspecify.annotations.Nullable;

public class AutoMetadataFilePackResources
extends AutoMetadataPackResources {
    private final ZipFileHolder zipFileHolder;
    private final Path path;

    public AutoMetadataFilePackResources(class_9224 info, String prefix, Path path, class_3264 packType) {
        super(info, packType, prefix);
        this.path = path;
        this.zipFileHolder = new ZipFileHolder();
    }

    private String getPathFromLocation(class_3264 packType, class_2960 location) {
        return String.format(Locale.ROOT, "%s/%s/%s", this.getPackFolderName(), location.method_12836(), location.method_12832());
    }

    public class_7367<InputStream> method_14405(class_3264 packType, class_2960 location) {
        return this.getResource(this.getPathFromLocation(packType, location));
    }

    private @Nullable class_7367<InputStream> getResource(String resourcePath) {
        ZipFile zipFile = this.zipFileHolder.getOrCreateZipFile();
        if (zipFile == null) {
            return null;
        }
        ZipEntry entry = zipFile.getEntry(resourcePath);
        return entry == null ? null : class_7367.create((ZipFile)zipFile, (ZipEntry)entry);
    }

    public Set<String> method_14406(class_3264 type) {
        ZipFile zipFile = this.zipFileHolder.getOrCreateZipFile();
        if (zipFile == null) {
            return Set.of();
        }
        HashSet set = Sets.newHashSet();
        String prefix = this.getPackFolderName() + "/";
        for (ZipEntry zipEntry : AutoMetadataFilePackResources.ofEnumeration(zipFile.entries())) {
            String[] parts;
            String entryPath = zipEntry.getName();
            String namespace = "";
            if (entryPath.startsWith(prefix) && (parts = entryPath.substring(prefix.length()).split("/")).length != 0) {
                namespace = parts[0];
            }
            if (namespace.isEmpty()) continue;
            if (class_2960.method_20209((String)namespace)) {
                set.add(namespace);
                continue;
            }
            DefaultResources.LOGGER.warn(AutoMetadataFilePackResources.class.getSimpleName() + ": Non [a-z0-9_.-] character in namespace {} in pack {}, ignoring", (Object)namespace, (Object)this.path);
        }
        return set;
    }

    private static <T> Iterable<T> ofEnumeration(Enumeration<T> enumeration) {
        return enumeration::asIterator;
    }

    public void method_14408(class_3264 packType, String namespace, String path, class_3262.class_7664 resourceOutput) {
        ZipFile zipFile = this.zipFileHolder.getOrCreateZipFile();
        if (zipFile != null) {
            String namespacePrefix = this.getPackFolderName() + "/" + namespace + "/";
            String pathPrefix = namespacePrefix + path + "/";
            for (ZipEntry zipEntry : AutoMetadataFilePackResources.ofEnumeration(zipFile.entries())) {
                String entryPath;
                if (zipEntry.isDirectory() || !(entryPath = zipEntry.getName()).startsWith(pathPrefix)) continue;
                class_2960 location = class_2960.method_43902((String)namespace, (String)entryPath.substring(namespacePrefix.length()));
                if (location != null) {
                    resourceOutput.accept((Object)location, (Object)class_7367.create((ZipFile)zipFile, (ZipEntry)zipEntry));
                    continue;
                }
                DefaultResources.LOGGER.warn(AutoMetadataFilePackResources.class.getSimpleName() + ": Invalid path in datapack: {}:{}, ignoring", (Object)namespace, (Object)entryPath);
            }
        }
    }

    public void close() {
        this.zipFileHolder.close();
    }

    private class ZipFileHolder
    implements AutoCloseable {
        private @Nullable ZipFile zipFile;
        private boolean loaded;

        private ZipFileHolder() {
        }

        @Nullable ZipFile getOrCreateZipFile() {
            if (this.zipFile == null && this.loaded) {
                return null;
            }
            if (this.zipFile == null) {
                this.loaded = true;
                try {
                    this.zipFile = new ZipFile(AutoMetadataFilePackResources.this.path.toFile());
                }
                catch (IOException var2) {
                    DefaultResources.LOGGER.error(AutoMetadataFilePackResources.class.getSimpleName() + ": Failed to open pack {}", (Object)AutoMetadataFilePackResources.this.path, (Object)var2);
                    return null;
                }
            }
            return this.zipFile;
        }

        @Override
        public void close() {
            if (this.zipFile != null) {
                IOUtils.closeQuietly((Closeable)this.zipFile);
                this.zipFile = null;
            }
        }
    }
}

