/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.defaultresources.impl;

import com.mojang.logging.LogUtils;
import dev.lukebemish.defaultresources.impl.AutoMetadataPackResources;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3259;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_4239;
import net.minecraft.class_7367;
import net.minecraft.class_9224;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class AutoMetadataPathPackResources
extends AutoMetadataPackResources {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected final List<Path> paths;

    public AutoMetadataPathPackResources(class_9224 info, String prefix, List<Path> paths, class_3264 packType) {
        super(info, packType, prefix);
        this.paths = paths;
    }

    public @Nullable class_7367<InputStream> method_14405(class_3264 packType, class_2960 location) {
        for (Path root : this.paths) {
            Path path = root.resolve(this.getPackFolderName()).resolve(location.method_12836());
            if (!Files.isDirectory(path, new LinkOption[0])) continue;
            return class_3259.method_45180((class_2960)location, (Path)path);
        }
        return null;
    }

    public void method_14408(class_3264 packType, String namespace, String path, class_3262.class_7664 resourceOutput) {
        class_4239.method_46346((String)path).ifSuccess(list -> {
            for (Path root : this.paths) {
                Path namespacePath = root.resolve(this.getPackFolderName()).resolve(namespace);
                if (!Files.isDirectory(namespacePath, new LinkOption[0])) continue;
                class_3259.method_45183((String)namespace, (Path)namespacePath, (List)list, (class_3262.class_7664)resourceOutput);
            }
        }).ifError(partialResult -> LOGGER.error("Invalid path {}: {}", (Object)path, (Object)partialResult.message()));
    }

    public Set<String> method_14406(class_3264 type) {
        HashSet<String> set = new HashSet<String>();
        for (Path root : this.paths) {
            Path path = root.resolve(this.getPackFolderName());
            if (!Files.isDirectory(path, new LinkOption[0])) continue;
            try {
                DirectoryStream<Path> paths = Files.newDirectoryStream(path);
                try {
                    for (Path namespacePath : paths) {
                        String namespace;
                        if (!Files.isDirectory(namespacePath, new LinkOption[0]) || !(namespace = namespacePath.getFileName().toString()).equals(namespace.toLowerCase(Locale.ROOT))) continue;
                        set.add(namespace);
                    }
                }
                finally {
                    if (paths == null) continue;
                    paths.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to list path {}", (Object)path, (Object)e);
            }
        }
        return set;
    }

    public void close() {
    }
}

