/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.defaultresources.impl;

import com.mojang.datafixers.util.Pair;
import dev.lukebemish.defaultresources.api.GlobalResourceManager;
import dev.lukebemish.defaultresources.impl.DefaultResources;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3288;
import net.minecraft.class_3298;
import net.minecraft.class_7367;
import net.minecraft.class_7368;

public class CombinedResourceManager
implements GlobalResourceManager {
    private final List<class_3262> resources;
    private final Map<String, List<class_3262>> namespaceMap;
    private final class_3264 type;

    public CombinedResourceManager(class_3264 type, List<Pair<String, class_3288.class_7680>> resources) {
        this.type = type;
        this.resources = resources.stream().sorted(Comparator.comparing(Pair::getFirst)).map(p -> ((class_3288.class_7680)p.getSecond()).method_52424(DefaultResources.infoFor((String)p.getFirst()))).toList();
        HashMap<String, List> namespaceBuilder = new HashMap<String, List>();
        for (class_3262 resource : this.resources) {
            for (String namespace : resource.method_14406(type)) {
                namespaceBuilder.computeIfAbsent(namespace, k -> new ArrayList()).add(resource);
            }
        }
        this.namespaceMap = namespaceBuilder.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> List.copyOf((Collection)e.getValue())));
    }

    public Set<String> method_14487() {
        return this.namespaceMap.keySet();
    }

    public List<class_3298> method_14489(class_2960 location) {
        ArrayList builder = new ArrayList();
        this.getResourceStream(location).forEach(builder::add);
        Collections.reverse(builder);
        return Collections.unmodifiableList(builder);
    }

    private Stream<class_3298> getResourceStream(class_2960 location) {
        return this.namespaceMap.getOrDefault(location.method_12836(), List.of()).stream().map(p -> {
            class_7367 ioSupplier = p.method_14405(this.type, location);
            if (ioSupplier != null) {
                class_2960 metadataLocation = CombinedResourceManager.getMetadataLocation(location);
                class_7367 metadataSupplier = () -> {
                    class_7368 class_73682;
                    block9: {
                        class_7367 metadataIoSupplier = p.method_14405(this.type, metadataLocation);
                        if (metadataIoSupplier == null) {
                            return class_7368.field_38688;
                        }
                        InputStream metadata = (InputStream)ioSupplier.get();
                        try {
                            class_73682 = class_7368.method_43042((InputStream)metadata);
                            if (metadata == null) break block9;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (metadata != null) {
                                    try {
                                        metadata.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Throwable t) {
                                throw new IOException(t);
                            }
                        }
                        metadata.close();
                    }
                    return class_73682;
                };
                return new class_3298(p, ioSupplier, metadataSupplier);
            }
            return null;
        }).filter(Objects::nonNull);
    }

    private static class_2960 getMetadataLocation(class_2960 location) {
        return location.method_45136(location.method_12832() + ".mcmeta");
    }

    public Map<class_2960, class_3298> method_14488(String path, Predicate<class_2960> filter) {
        HashMap builder = new HashMap();
        BiConsumer<class_2960, class_3298> consumer = builder::put;
        this.findResources(path, filter, consumer);
        return Collections.unmodifiableMap(builder);
    }

    public Map<class_2960, List<class_3298>> method_41265(String path, Predicate<class_2960> filter) {
        HashMap builder = new HashMap();
        BiConsumer<class_2960, class_3298> consumer = (rl, r) -> builder.computeIfAbsent(rl, k -> new ArrayList()).add(r);
        this.findResources(path, filter, consumer);
        return builder.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            List list = (List)e.getValue();
            Collections.reverse(list);
            return Collections.unmodifiableList(list);
        }));
    }

    private void findResources(String path, Predicate<class_2960> filter, BiConsumer<class_2960, class_3298> consumer) {
        for (Map.Entry<String, List<class_3262>> entry : this.namespaceMap.entrySet()) {
            String namespace = entry.getKey();
            for (class_3262 packResources : entry.getValue()) {
                packResources.method_14408(this.type, namespace, path, (rl, ioSupplier) -> {
                    if (rl.method_12832().endsWith(".mcmeta")) {
                        return;
                    }
                    if (filter.test((class_2960)rl)) {
                        class_2960 metadataLocation = CombinedResourceManager.getMetadataLocation(rl);
                        class_7367 metadataSupplier = () -> {
                            class_7368 class_73682;
                            block9: {
                                class_7367 metadataIoSupplier = packResources.method_14405(this.type, metadataLocation);
                                if (metadataIoSupplier == null) {
                                    return class_7368.field_38688;
                                }
                                InputStream metadata = (InputStream)ioSupplier.get();
                                try {
                                    class_73682 = class_7368.method_43042((InputStream)metadata);
                                    if (metadata == null) break block9;
                                }
                                catch (Throwable throwable) {
                                    try {
                                        if (metadata != null) {
                                            try {
                                                metadata.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                        }
                                        throw throwable;
                                    }
                                    catch (Throwable t) {
                                        throw new IOException(t);
                                    }
                                }
                                metadata.close();
                            }
                            return class_73682;
                        };
                        consumer.accept((class_2960)rl, new class_3298(packResources, ioSupplier, metadataSupplier));
                    }
                });
            }
        }
    }

    public Stream<class_3262> method_29213() {
        return this.resources.stream();
    }

    public Optional<class_3298> method_14486(class_2960 location) {
        AtomicReference resource = new AtomicReference();
        this.getResourceStream(location).forEach(resource::set);
        return Optional.ofNullable((class_3298)resource.get());
    }
}

