/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.defaultresources.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.lukebemish.defaultresources.api.GlobalResourceManager;
import dev.lukebemish.defaultresources.api.OutdatedResourcesListener;
import dev.lukebemish.defaultresources.impl.AutoMetadataFilePackResources;
import dev.lukebemish.defaultresources.impl.AutoMetadataPathPackResources;
import dev.lukebemish.defaultresources.impl.CombinedResourceManager;
import dev.lukebemish.defaultresources.impl.Config;
import dev.lukebemish.defaultresources.impl.ModMetaFile;
import dev.lukebemish.defaultresources.impl.Services;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.zip.Adler32;
import net.minecraft.class_2561;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3288;
import net.minecraft.class_5352;
import net.minecraft.class_9224;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.Nullable;

public class DefaultResources {
    public static final String MOD_ID = "defaultresources";
    public static final Logger LOGGER = LogManager.getLogger((String)"defaultresources");
    private static final int BUFFER_SIZE = 1024;
    public static final Map<String, Optional<String>> OUTDATED_TARGETS = new ConcurrentHashMap<String, Optional<String>>();
    public static final Map<String, Optional<String>> MOD_TARGETS = new ConcurrentHashMap<String, Optional<String>>();
    private static volatile boolean GLOBAL_SETUP = false;
    private static final Map<String, List<OutdatedResourcesListener>> OUTDATED_RESOURCES_LISTENERS = new ConcurrentHashMap<String, List<OutdatedResourcesListener>>();
    public static final String META_FILE_PATH = "defaultresources.meta.json";
    public static final String CHECK_FILE_PATH = ".defaultresources";
    public static final Gson GSON = new GsonBuilder().setLenient().setPrettyPrinting().create();
    private static final Map<String, BiFunction<class_9224, class_3264, @Nullable Supplier<class_3262>>> QUEUED_RESOURCES = new ConcurrentHashMap<String, BiFunction<class_9224, class_3264, Supplier<class_3262>>>();
    private static final Map<String, BiFunction<class_9224, class_3264, @Nullable Supplier<class_3262>>> QUEUED_STATIC_RESOURCES = new ConcurrentHashMap<String, BiFunction<class_9224, class_3264, Supplier<class_3262>>>();
    public static final String GLOBAL_PREFIX = "global";

    public static void addListener(String modId, OutdatedResourcesListener listener) {
        OUTDATED_RESOURCES_LISTENERS.computeIfAbsent(modId, s -> new ArrayList()).add(listener);
    }

    public static void forMod(Function<String, Path> inJarPathGetter, String modId) {
        DefaultResources.forMod(inJarPathGetter, modId, List.of(inJarPathGetter));
    }

    public static void forMod(Function<String, Path> inJarPathGetter, String modId, List<Function<String, Path>> rootPaths) {
        block32: {
            ModMetaFile meta;
            block31: {
                Path defaultResourcesMeta = inJarPathGetter.apply(META_FILE_PATH);
                if (Files.exists(defaultResourcesMeta, new LinkOption[0])) {
                    try (InputStream is = Files.newInputStream(defaultResourcesMeta, new OpenOption[0]);){
                        JsonObject obj = (JsonObject)GSON.fromJson((Reader)new BufferedReader(new InputStreamReader(is)), JsonObject.class);
                        meta = (ModMetaFile)ModMetaFile.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)obj).getOrThrow();
                        break block31;
                    }
                    catch (IOException | RuntimeException e) {
                        LOGGER.error("Could not read meta file for mod {}", (Object)modId, (Object)e);
                        return;
                    }
                }
                try {
                    meta = (ModMetaFile)ModMetaFile.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)new JsonObject()).getOrThrow();
                }
                catch (RuntimeException e) {
                    LOGGER.error("Could not parse default meta file", (Throwable)e);
                    return;
                }
            }
            List<Path> defaultResources = rootPaths.stream().map(it -> (Path)it.apply(meta.resourcesPath())).toList();
            try {
                String checksum;
                Path outPath;
                if (!defaultResources.stream().anyMatch(x$0 -> Files.exists(x$0, new LinkOption[0]))) break block32;
                MOD_TARGETS.put(modId, meta.dataVersion());
                Config.ExtractionState defaultExtraction = meta.extract() ? Config.ExtractionState.EXTRACT : Config.ExtractionState.UNEXTRACTED;
                Config.ExtractionState extractionState = Config.INSTANCE.get().extract().getOrDefault(modId, defaultExtraction);
                if (extractionState == Config.ExtractionState.OUTDATED) {
                    extractionState = defaultExtraction;
                }
                if (!Config.INSTANCE.get().extract().containsKey(modId)) {
                    Config.INSTANCE.get().extract().put(modId, defaultExtraction);
                }
                if (extractionState == Config.ExtractionState.UNEXTRACTED) {
                    QUEUED_RESOURCES.put("unextracted/" + modId, (s, type) -> {
                        if (defaultResources.stream().noneMatch(f -> Files.exists(f.resolve(type.method_14413()), new LinkOption[0]))) {
                            return null;
                        }
                        return () -> new AutoMetadataPathPackResources((class_9224)s, "", defaultResources, (class_3264)type);
                    });
                    QUEUED_STATIC_RESOURCES.put("unextracted/" + modId, (s, type) -> {
                        if (defaultResources.stream().noneMatch(f -> Files.exists(f.resolve(GLOBAL_PREFIX + type.method_14413()), new LinkOption[0]))) {
                            return null;
                        }
                        return () -> new AutoMetadataPathPackResources((class_9224)s, GLOBAL_PREFIX, defaultResources, (class_3264)type);
                    });
                    break block32;
                }
                if (extractionState != Config.ExtractionState.EXTRACT) break block32;
                Config.INSTANCE.get().extract().put(modId, meta.extract() ? Config.ExtractionState.EXTRACT : Config.ExtractionState.EXTRACTED);
                if (!meta.zip()) {
                    Path outPath2 = Services.PLATFORM.getGlobalFolder().resolve(modId);
                    String checksum2 = DefaultResources.shouldCopy(defaultResources, outPath2, Files.exists(outPath2, new LinkOption[0]), modId, meta);
                    if (checksum2 != null) {
                        DefaultResources.copyResources(defaultResources, outPath2, checksum2, meta.dataVersion().orElse(null));
                    }
                    break block32;
                }
                Path zipPath = Services.PLATFORM.getGlobalFolder().resolve(modId + ".zip");
                boolean zipExists = Files.exists(zipPath, new LinkOption[0]);
                try (FileSystem zipFs = FileSystems.newFileSystem(zipPath, Collections.singletonMap("create", "true"));){
                    outPath = zipFs.getPath("/", new String[0]);
                    checksum = DefaultResources.shouldCopy(defaultResources, outPath, zipExists, modId, meta);
                    if (checksum != null && !zipExists) {
                        DefaultResources.copyResources(defaultResources, outPath, checksum, meta.dataVersion().orElse(null));
                    }
                }
                if (checksum == null || !zipExists) break block32;
                Files.delete(zipPath);
                zipFs = FileSystems.newFileSystem(zipPath, Collections.singletonMap("create", "true"));
                try {
                    outPath = zipFs.getPath("/", new String[0]);
                    DefaultResources.copyResources(defaultResources, outPath, checksum, meta.dataVersion().orElse(null));
                }
                finally {
                    if (zipFs != null) {
                        zipFs.close();
                    }
                }
            }
            catch (IOException | RuntimeException e) {
                LOGGER.error("Could not handle default resources for mod {}", (Object)modId, (Object)e);
            }
        }
    }

    private static void couldNotUpdate(String modId, Path outPath, ModMetaFile meta) {
        String oldDataVersion;
        try {
            oldDataVersion = DefaultResources.dataVersion(outPath);
        }
        catch (IOException e) {
            LOGGER.error("Could not read old data version for mod {}", (Object)modId, (Object)e);
            oldDataVersion = null;
        }
        LOGGER.error("Could not extract default resources for mod {} (data version {} to version {}) because they are already extracted and have been changed on disk", (Object)modId, (Object)oldDataVersion, meta.dataVersion().orElse(null));
        OUTDATED_TARGETS.put(modId, Optional.ofNullable(oldDataVersion));
        Config.INSTANCE.get().extract().put(modId, Config.ExtractionState.OUTDATED);
    }

    private static @Nullable String shouldCopy(List<Path> defaultResources, Path outPath, boolean alreadyExists, String modId, ModMetaFile meta) {
        block7: {
            try {
                if (alreadyExists) {
                    String oldVersion;
                    String oldChecksum;
                    Path checksumPath = outPath.resolve(CHECK_FILE_PATH);
                    if (Files.exists(checksumPath, new LinkOption[0])) {
                        String[] parts = Files.readString(checksumPath).split(":", 2);
                        oldChecksum = parts[0];
                        oldVersion = parts.length == 2 ? parts[1] : null;
                    } else {
                        DefaultResources.couldNotUpdate(modId, outPath, meta);
                        return null;
                    }
                    String newChecksum = DefaultResources.checkPath(defaultResources);
                    String newVersion = meta.dataVersion().orElse(null);
                    if (newChecksum.equals(oldChecksum) && Objects.equals(newVersion, oldVersion)) {
                        return null;
                    }
                    String newExtractedChecksum = DefaultResources.checkPath(List.of(outPath));
                    if (newExtractedChecksum.equals(oldChecksum)) {
                        return newChecksum;
                    }
                    break block7;
                }
                return DefaultResources.checkPath(defaultResources);
            }
            catch (IOException e) {
                LOGGER.error("Error checking compatibility of resources from {} targeted at {}", defaultResources, (Object)outPath, (Object)e);
            }
        }
        DefaultResources.couldNotUpdate(modId, outPath, meta);
        return null;
    }

    private static @Nullable String dataVersion(Path path) throws IOException {
        String[] parts;
        Path checksumPath = path.resolve(CHECK_FILE_PATH);
        if (Files.exists(checksumPath, new LinkOption[0]) && (parts = Files.readString(checksumPath).split(":", 2)).length == 2) {
            return parts[1];
        }
        return null;
    }

    private static String checkPath(List<Path> paths) throws IOException {
        StringBuilder newChecksum = new StringBuilder();
        ArrayList<Stream<Path>> toClose = new ArrayList<Stream<Path>>();
        try (ManyCloser ignored = new ManyCloser(toClose);){
            ArrayList<Stream<Pair>> partPairs = new ArrayList<Stream<Pair>>();
            for (Path path : paths) {
                if (!Files.exists(path, new LinkOption[0])) continue;
                Stream<Path> part = Files.walk(path, new FileVisitOption[0]);
                toClose.add(part);
                partPairs.add(part.map(p -> new Pair((Object)path, p)));
            }
            partPairs.stream().flatMap(Function.identity()).sorted(Comparator.comparing(pair -> ((Path)pair.getFirst()).relativize((Path)pair.getSecond()))).forEach(pair -> {
                block9: {
                    Path p = (Path)pair.getSecond();
                    Path path = (Path)pair.getFirst();
                    try {
                        if (Files.isDirectory(p, new LinkOption[0]) || path.relativize(p).getNameCount() == 1 && p.endsWith(CHECK_FILE_PATH)) break block9;
                        Adler32 check = new Adler32();
                        try (InputStream is = Files.newInputStream(p, new OpenOption[0]);){
                            int length;
                            byte[] buffer = new byte[1024];
                            while ((length = is.read(buffer)) > 0) {
                                check.update(buffer, 0, length);
                            }
                        }
                        newChecksum.append(DefaultResources.encode((int)check.getValue()));
                    }
                    catch (IOException e) {
                        LOGGER.error("Error calculating checksum at {}", (Object)p, (Object)e);
                    }
                }
            });
        }
        return newChecksum.toString();
    }

    private static CharSequence encode(int i) {
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < 4; ++j) {
            sb.append((char)((i >> j * 4 & 0xF) + 97));
        }
        return sb;
    }

    private static void copyResources(List<Path> defaultResourcesPaths, Path outPath, String checksum, @Nullable String dataVersion) {
        try {
            for (Path defaultResources : defaultResourcesPaths) {
                if (!Files.exists(defaultResources, new LinkOption[0])) continue;
                Stream<Path> walk = Files.walk(defaultResources, new FileVisitOption[0]);
                try {
                    walk.sorted(Comparator.comparing(p -> p.relativize(defaultResources).toString())).forEach(p -> {
                        try {
                            if (!Files.isDirectory(p, new LinkOption[0])) {
                                String rel = defaultResources.relativize((Path)p).toString();
                                Path newPath = outPath.resolve(rel);
                                if (!Files.exists(newPath.getParent(), new LinkOption[0])) {
                                    Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                                }
                                Files.copy(p, newPath, new CopyOption[0]);
                            }
                        }
                        catch (IOException e) {
                            LOGGER.error("Error checking compatibility of resources from {} targeted at {}, for path {}", (Object)defaultResources, (Object)outPath, p, (Object)e);
                        }
                    });
                }
                finally {
                    if (walk == null) continue;
                    walk.close();
                }
            }
            Path checksumPath = outPath.resolve(CHECK_FILE_PATH);
            Files.writeString(checksumPath, (CharSequence)(checksum + (String)(dataVersion == null ? "" : ":" + dataVersion)), new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.error("Error checking compatibility of resources from {} targeted at {}", defaultResourcesPaths, (Object)outPath, (Object)e);
        }
    }

    public static void cleanupExtraction() {
        Config.INSTANCE.get().save();
    }

    public static class_3288.class_7680 wrap(final Function<class_9224, class_3262> function) {
        return new class_3288.class_7680(){

            public class_3262 method_52424(class_9224 location) {
                return (class_3262)function.apply(location);
            }

            public class_3262 method_52425(class_9224 location, class_3288.class_7679 metadata) {
                return (class_3262)function.apply(location);
            }
        };
    }

    public static List<Pair<String, class_3288.class_7680>> getPackResources(class_3264 type) {
        ArrayList<Pair<String, class_3288.class_7680>> packs = new ArrayList<Pair<String, class_3288.class_7680>>();
        try (Stream<Path> files = Files.list(Services.PLATFORM.getGlobalFolder());){
            for (Path file : files.toList()) {
                class_3288.class_7680 packResources;
                if (Files.isDirectory(file, new LinkOption[0])) {
                    packResources = DefaultResources.wrap(s -> new AutoMetadataPathPackResources((class_9224)s, "", List.of(file), type));
                    packs.add((Pair<String, class_3288.class_7680>)new Pair((Object)("directory/" + file.getFileName().toString()), (Object)packResources));
                    continue;
                }
                if (!file.getFileName().toString().endsWith(".zip")) continue;
                packResources = DefaultResources.wrap(s -> new AutoMetadataFilePackResources((class_9224)s, "", file, type));
                packs.add((Pair<String, class_3288.class_7680>)new Pair((Object)("file/" + String.valueOf(file.getFileName())), (Object)packResources));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        QUEUED_RESOURCES.forEach((s, biFunction) -> {
            class_9224 info = DefaultResources.infoFor(s);
            Supplier resources = (Supplier)biFunction.apply(info, type);
            if (resources == null) {
                return;
            }
            packs.add(new Pair(s, (Object)DefaultResources.wrap(arg_0 -> DefaultResources.lambda$getPackResources$16((Supplier)resources, arg_0))));
        });
        return packs;
    }

    private static List<Pair<String, class_3288.class_7680>> getStaticPackResources(class_3264 type) {
        ArrayList<Pair<String, class_3288.class_7680>> packs = new ArrayList<Pair<String, class_3288.class_7680>>();
        try (Stream<Path> files = Files.list(Services.PLATFORM.getGlobalFolder());){
            for (Path file : files.toList()) {
                class_3288.class_7680 packResources;
                if (Files.isDirectory(file, new LinkOption[0])) {
                    packResources = DefaultResources.wrap(s -> new AutoMetadataPathPackResources((class_9224)s, GLOBAL_PREFIX, List.of(file), type));
                    packs.add((Pair<String, class_3288.class_7680>)new Pair((Object)("directory/" + String.valueOf(file.getFileName())), (Object)packResources));
                    continue;
                }
                if (!file.getFileName().toString().endsWith(".zip")) continue;
                packResources = DefaultResources.wrap(s -> new AutoMetadataFilePackResources((class_9224)s, GLOBAL_PREFIX, file, type));
                packs.add((Pair<String, class_3288.class_7680>)new Pair((Object)("file/" + String.valueOf(file.getFileName())), (Object)packResources));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        packs.addAll(DefaultResources.getDetectedPacks(type));
        QUEUED_STATIC_RESOURCES.forEach((s, biFunction) -> {
            class_9224 info = DefaultResources.infoFor(s);
            Supplier resources = (Supplier)biFunction.apply(info, type);
            if (resources == null) {
                return;
            }
            packs.add(new Pair(s, (Object)DefaultResources.wrap(arg_0 -> DefaultResources.lambda$getStaticPackResources$20((Supplier)resources, arg_0))));
        });
        return packs;
    }

    private static List<Pair<String, class_3288.class_7680>> getDetectedPacks(class_3264 type) {
        ArrayList<Pair<String, class_3288.class_7680>> packs = new ArrayList<Pair<String, class_3288.class_7680>>();
        Config.INSTANCE.get().fromResourcePacks().forEach((name, enabled) -> {
            if (enabled.booleanValue()) {
                Path path = Services.PLATFORM.getResourcePackDir().resolve((String)name);
                if (Files.isDirectory(path, new LinkOption[0])) {
                    packs.add(Pair.of((Object)("resourcepacks/" + name), (Object)DefaultResources.wrap(n -> new AutoMetadataPathPackResources((class_9224)n, GLOBAL_PREFIX, List.of(path), type))));
                } else if (Files.isRegularFile(path, new LinkOption[0])) {
                    packs.add(Pair.of((Object)("resourcepacks/" + name), (Object)DefaultResources.wrap(n -> new AutoMetadataFilePackResources((class_9224)n, GLOBAL_PREFIX, path, type))));
                } else {
                    return;
                }
                LOGGER.info("Added resource pack \"{}\" to global {} resource providers", name, (Object)type.method_14413());
            }
        });
        return packs;
    }

    public static synchronized void delegate(Runnable ifInitialized, Runnable ifUninitialized) {
        if (GLOBAL_SETUP) {
            ifInitialized.run();
        } else {
            ifUninitialized.run();
        }
    }

    public static synchronized void initialize() {
        if (!GLOBAL_SETUP) {
            Services.PLATFORM.extractResources();
            DefaultResources.cleanupExtraction();
            for (Map.Entry<String, Optional<String>> entry : OUTDATED_TARGETS.entrySet()) {
                String oldVersion = MOD_TARGETS.getOrDefault(entry.getKey(), Optional.empty()).orElse(null);
                String newVersion = entry.getValue().orElse(null);
                String modId = entry.getKey();
                OUTDATED_RESOURCES_LISTENERS.getOrDefault(modId, List.of()).forEach(listener -> listener.resourcesOutdated(oldVersion, newVersion));
            }
            GLOBAL_SETUP = true;
        }
    }

    public static synchronized GlobalResourceManager createStaticResourceManager(class_3264 type) {
        DefaultResources.initialize();
        ArrayList<Pair<String, class_3288.class_7680>> sources = new ArrayList<Pair<String, class_3288.class_7680>>(DefaultResources.getStaticPackResources(type));
        sources.addAll(Services.PLATFORM.getJarProviders(type));
        return new CombinedResourceManager(type, sources);
    }

    public static class_9224 infoFor(String id) {
        return new class_9224("defaultresources/" + id, (class_2561)class_2561.method_43470((String)("Global Resources - " + id)), class_5352.field_25347, Optional.empty());
    }

    private static /* synthetic */ class_3262 lambda$getStaticPackResources$20(Supplier resources, class_9224 str) {
        return (class_3262)resources.get();
    }

    private static /* synthetic */ class_3262 lambda$getPackResources$16(Supplier resources, class_9224 str) {
        return (class_3262)resources.get();
    }

    private record ManyCloser(List<? extends AutoCloseable> closeables) implements AutoCloseable
    {
        @Override
        public void close() throws IOException {
            ArrayList<Exception> es = new ArrayList<Exception>();
            for (AutoCloseable autoCloseable : this.closeables) {
                try {
                    autoCloseable.close();
                }
                catch (Exception e) {
                    es.add(e);
                }
            }
            if (!es.isEmpty()) {
                IOException e = new IOException("Error closing resources");
                es.forEach(e::addSuppressed);
                throw e;
            }
        }
    }
}

