/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.defaultresources.impl;

import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_3902;

public final class ParallelExecutor {
    private static final AtomicInteger POOL_THREAD_COUNTER = new AtomicInteger(0);
    private static final ForkJoinPool POOL;

    private ParallelExecutor() {
    }

    public static <T> void execute(Stream<T> stream, Consumer<T> task) {
        POOL.invoke(new RunnableExecuteAction(() -> ((Stream)stream.parallel()).forEach(task)));
    }

    static {
        ClassLoader classLoader = ParallelExecutor.class.getClassLoader();
        POOL = new ForkJoinPool(Math.max(4, Runtime.getRuntime().availableProcessors() - 4), forkJoinPool -> {
            ForkJoinWorkerThread thread = new ForkJoinWorkerThread(forkJoinPool){};
            thread.setContextClassLoader(classLoader);
            thread.setName(String.format("DefaultResources parallel executor: %s", POOL_THREAD_COUNTER.incrementAndGet()));
            return thread;
        }, null, true);
    }

    private static final class RunnableExecuteAction
    extends ForkJoinTask<class_3902> {
        final Runnable runnable;

        private RunnableExecuteAction(Runnable runnable) {
            this.runnable = Objects.requireNonNull(runnable);
        }

        @Override
        public class_3902 getRawResult() {
            return class_3902.field_17274;
        }

        @Override
        public void setRawResult(class_3902 v) {
        }

        @Override
        public boolean exec() {
            this.runnable.run();
            return true;
        }
    }
}

