/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.defaultresources.impl;

import dev.lukebemish.defaultresources.api.GlobalResourceManager;
import dev.lukebemish.defaultresources.impl.mixin.ResourceAccessor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_7367;
import net.minecraft.class_7368;
import net.minecraft.class_9224;
import org.jspecify.annotations.Nullable;

public class WrappingResourceManager
implements GlobalResourceManager {
    private final GlobalResourceManager wrapped;
    private final String prefix;

    private static void checkValidPrefix(String prefix) {
        if (prefix.isEmpty()) {
            throw new IllegalArgumentException("Invalid prefix; prefixes must not be empty.");
        }
        for (char c : prefix.toCharArray()) {
            if (c == '_' || c == '-' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') continue;
            throw new IllegalArgumentException("Invalid prefix: \"" + prefix + "\". Prefixes must contain only lowercase letters, numbers, underscores, and dashes.");
        }
    }

    public WrappingResourceManager(GlobalResourceManager wrapped, String prefix) {
        WrappingResourceManager.checkValidPrefix(prefix);
        this.wrapped = wrapped;
        this.prefix = prefix + "/";
    }

    public Set<String> method_14487() {
        return this.wrapped.method_14487();
    }

    public List<class_3298> method_14489(class_2960 location) {
        ArrayList<class_3298> out = new ArrayList<class_3298>();
        for (class_3298 resource : this.wrapped.method_14489(location.method_45138(this.prefix))) {
            out.add(this.wrapResource(resource));
        }
        return out;
    }

    public Map<class_2960, class_3298> method_14488(String path, Predicate<class_2960> filter) {
        HashMap<class_2960, class_3298> out = new HashMap<class_2960, class_3298>();
        for (Map.Entry entry : this.wrapped.method_14488(this.prefix + path, filter).entrySet()) {
            out.put(this.wrapLocation((class_2960)entry.getKey()), this.wrapResource((class_3298)entry.getValue()));
        }
        return out;
    }

    public Map<class_2960, List<class_3298>> method_41265(String path, Predicate<class_2960> filter) {
        HashMap<class_2960, List<class_3298>> out = new HashMap<class_2960, List<class_3298>>();
        for (Map.Entry entry : this.wrapped.method_41265(this.prefix + path, filter).entrySet()) {
            ArrayList<class_3298> resources = new ArrayList<class_3298>();
            for (class_3298 resource : (List)entry.getValue()) {
                resources.add(this.wrapResource(resource));
            }
            out.put(this.wrapLocation((class_2960)entry.getKey()), resources);
        }
        return out;
    }

    public Stream<class_3262> method_29213() {
        return this.wrapped.method_29213().map(this::wrapResources);
    }

    private class_3298 wrapResource(class_3298 resource) {
        if (((ResourceAccessor)resource).defaultresources_getMetadataSupplier() == class_7368.field_40056) {
            return new class_3298(this.wrapResources(resource.method_45304()), ((ResourceAccessor)resource).defaultresources_getStreamSupplier());
        }
        return new class_3298(this.wrapResources(resource.method_45304()), ((ResourceAccessor)resource).defaultresources_getStreamSupplier(), ((ResourceAccessor)resource).defaultresources_getMetadataSupplier());
    }

    private class_2960 wrapLocation(class_2960 location) {
        return location.method_45134(s -> s.substring(this.prefix.length()));
    }

    private class_3262 wrapResources(final class_3262 pack) {
        return new class_3262(){

            public @Nullable class_7367<InputStream> method_14410(String ... elements) {
                return pack.method_14410(elements);
            }

            public @Nullable class_7367<InputStream> method_14405(class_3264 packType, class_2960 location) {
                return pack.method_14405(packType, location.method_45138(WrappingResourceManager.this.prefix));
            }

            public void method_14408(class_3264 packType, String namespace, String path, class_3262.class_7664 resourceOutput) {
                pack.method_14408(packType, namespace, WrappingResourceManager.this.prefix + path, (rl, ioSupplier) -> resourceOutput.accept((Object)WrappingResourceManager.this.wrapLocation((class_2960)rl), ioSupplier));
            }

            public Set<String> method_14406(class_3264 type) {
                return pack.method_14406(type);
            }

            public <T> @Nullable T method_14407(class_3270<T> deserializer) throws IOException {
                return (T)pack.method_14407(deserializer);
            }

            public class_9224 method_56926() {
                return pack.method_56926();
            }

            public String method_14409() {
                return pack.method_14409();
            }

            public void close() {
                pack.close();
            }
        };
    }

    public Optional<class_3298> method_14486(class_2960 location) {
        return this.wrapped.method_14486(location.method_45138(this.prefix)).map(this::wrapResource);
    }
}

