/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.defaultresources.impl;

import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.FileUtil;
import net.minecraft.SharedConstants;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class AutoMetadataPathPackResources
extends AbstractPackResources {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final String name;
    private final Path path;
    private final PackType packType;

    public AutoMetadataPathPackResources(String s, String prefix, Path path, PackType packType) {
        super(s, false);
        this.name = prefix + packType.getDirectory();
        this.path = path;
        this.packType = packType;
    }

    public @Nullable IoSupplier<InputStream> getRootResource(String ... elements) {
        return null;
    }

    public @Nullable IoSupplier<InputStream> getResource(PackType packType, ResourceLocation location) {
        Path path = this.path.resolve(this.name).resolve(location.getNamespace());
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return null;
        }
        return PathPackResources.getResource((ResourceLocation)location, (Path)path);
    }

    public void listResources(PackType packType, String namespace, String path, PackResources.ResourceOutput resourceOutput) {
        FileUtil.decomposePath((String)path).get().ifLeft(list -> {
            Path namespacePath = this.path.resolve(this.name).resolve(namespace);
            if (!Files.isDirectory(namespacePath, new LinkOption[0])) {
                return;
            }
            PathPackResources.listPath((String)namespace, (Path)namespacePath, (List)list, (PackResources.ResourceOutput)resourceOutput);
        }).ifRight(partialResult -> LOGGER.error("Invalid path {}: {}", (Object)path, (Object)partialResult.message()));
    }

    public @NonNull Set<String> getNamespaces(PackType type) {
        HashSet<String> set = new HashSet<String>();
        Path path = this.path.resolve(this.name);
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return Set.of();
        }
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(path);){
            for (Path namespacePath : paths) {
                String namespace;
                if (!Files.isDirectory(namespacePath, new LinkOption[0]) || !(namespace = namespacePath.getFileName().toString()).equals(namespace.toLowerCase(Locale.ROOT))) continue;
                set.add(namespace);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to list path {}", (Object)path, (Object)e);
        }
        return set;
    }

    public <T> @Nullable T getMetadataSection(MetadataSectionSerializer<T> serializer) {
        if (serializer.getMetadataSectionName().equals("pack")) {
            JsonObject object = new JsonObject();
            object.addProperty("pack_format", (Number)SharedConstants.getCurrentVersion().getPackVersion(this.packType));
            object.addProperty("description", "Global resources");
            return (T)serializer.fromJson(object);
        }
        return null;
    }

    public void close() {
    }
}

