/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.defaultresources.impl;

import com.mojang.datafixers.util.Pair;
import dev.lukebemish.defaultresources.api.GlobalResourceManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceMetadata;
import org.jspecify.annotations.NonNull;

public class CombinedResourceManager
implements GlobalResourceManager {
    private final List<PackResources> resources;
    private final Map<String, List<PackResources>> namespaceMap;
    private final PackType type;

    public CombinedResourceManager(PackType type, List<Pair<String, Pack.ResourcesSupplier>> resources) {
        this.type = type;
        this.resources = resources.stream().sorted(Comparator.comparing(Pair::getFirst)).map(p -> ((Pack.ResourcesSupplier)p.getSecond()).openPrimary((String)p.getFirst())).toList();
        HashMap<String, List> namespaceBuilder = new HashMap<String, List>();
        for (PackResources resource : this.resources) {
            for (String namespace : resource.getNamespaces(type)) {
                namespaceBuilder.computeIfAbsent(namespace, k -> new ArrayList()).add(resource);
            }
        }
        this.namespaceMap = namespaceBuilder.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> List.copyOf((Collection)e.getValue())));
    }

    public @NonNull Set<String> getNamespaces() {
        return this.namespaceMap.keySet();
    }

    public @NonNull List<Resource> getResourceStack(ResourceLocation location) {
        ArrayList builder = new ArrayList();
        this.getResourceStream(location).forEach(builder::add);
        Collections.reverse(builder);
        return Collections.unmodifiableList(builder);
    }

    private @NonNull Stream<Resource> getResourceStream(ResourceLocation location) {
        return this.namespaceMap.getOrDefault(location.getNamespace(), List.of()).stream().map(p -> {
            IoSupplier ioSupplier = p.getResource(this.type, location);
            if (ioSupplier != null) {
                ResourceLocation metadataLocation = CombinedResourceManager.getMetadataLocation(location);
                IoSupplier metadataSupplier = () -> {
                    ResourceMetadata resourceMetadata;
                    block9: {
                        IoSupplier metadataIoSupplier = p.getResource(this.type, metadataLocation);
                        if (metadataIoSupplier == null) {
                            return ResourceMetadata.EMPTY;
                        }
                        InputStream metadata = (InputStream)ioSupplier.get();
                        try {
                            resourceMetadata = ResourceMetadata.fromJsonStream((InputStream)metadata);
                            if (metadata == null) break block9;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (metadata != null) {
                                    try {
                                        metadata.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Throwable t) {
                                throw new IOException(t);
                            }
                        }
                        metadata.close();
                    }
                    return resourceMetadata;
                };
                return new Resource(p, ioSupplier, metadataSupplier);
            }
            return null;
        }).filter(Objects::nonNull);
    }

    private static ResourceLocation getMetadataLocation(ResourceLocation location) {
        return location.withPath(location.getPath() + ".mcmeta");
    }

    public @NonNull Map<ResourceLocation, Resource> listResources(String path, Predicate<ResourceLocation> filter) {
        HashMap builder = new HashMap();
        BiConsumer<ResourceLocation, Resource> consumer = builder::put;
        this.findResources(path, filter, consumer);
        return Collections.unmodifiableMap(builder);
    }

    public @NonNull Map<ResourceLocation, List<Resource>> listResourceStacks(String path, Predicate<ResourceLocation> filter) {
        HashMap builder = new HashMap();
        BiConsumer<ResourceLocation, Resource> consumer = (rl, r) -> builder.computeIfAbsent(rl, k -> new ArrayList()).add(r);
        this.findResources(path, filter, consumer);
        return builder.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            List list = (List)e.getValue();
            Collections.reverse(list);
            return Collections.unmodifiableList(list);
        }));
    }

    private void findResources(String path, Predicate<ResourceLocation> filter, BiConsumer<ResourceLocation, Resource> consumer) {
        for (Map.Entry<String, List<PackResources>> entry : this.namespaceMap.entrySet()) {
            String namespace = entry.getKey();
            for (PackResources packResources : entry.getValue()) {
                packResources.listResources(this.type, namespace, path, (rl, ioSupplier) -> {
                    if (rl.getPath().endsWith(".mcmeta")) {
                        return;
                    }
                    if (filter.test((ResourceLocation)rl)) {
                        ResourceLocation metadataLocation = CombinedResourceManager.getMetadataLocation(rl);
                        IoSupplier metadataSupplier = () -> {
                            ResourceMetadata resourceMetadata;
                            block9: {
                                IoSupplier metadataIoSupplier = packResources.getResource(this.type, metadataLocation);
                                if (metadataIoSupplier == null) {
                                    return ResourceMetadata.EMPTY;
                                }
                                InputStream metadata = (InputStream)ioSupplier.get();
                                try {
                                    resourceMetadata = ResourceMetadata.fromJsonStream((InputStream)metadata);
                                    if (metadata == null) break block9;
                                }
                                catch (Throwable throwable) {
                                    try {
                                        if (metadata != null) {
                                            try {
                                                metadata.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                        }
                                        throw throwable;
                                    }
                                    catch (Throwable t) {
                                        throw new IOException(t);
                                    }
                                }
                                metadata.close();
                            }
                            return resourceMetadata;
                        };
                        consumer.accept((ResourceLocation)rl, new Resource(packResources, ioSupplier, metadataSupplier));
                    }
                });
            }
        }
    }

    public @NonNull Stream<PackResources> listPacks() {
        return this.resources.stream();
    }

    public @NonNull Optional<Resource> getResource(ResourceLocation location) {
        AtomicReference resource = new AtomicReference();
        this.getResourceStream(location).forEach(resource::set);
        return Optional.ofNullable((Resource)resource.get());
    }
}

