/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.defaultresources.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.lukebemish.defaultresources.api.GlobalResourceManager;
import dev.lukebemish.defaultresources.impl.AutoMetadataPathPackResources;
import dev.lukebemish.defaultresources.impl.CombinedResourceManager;
import dev.lukebemish.defaultresources.impl.Config;
import dev.lukebemish.defaultresources.impl.ModMetaFile;
import dev.lukebemish.defaultresources.impl.Services;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.NonNull;

public class DefaultResources {
    public static final String MOD_ID = "defaultresources";
    public static final Logger LOGGER = LogManager.getLogger((String)"defaultresources");
    public static final String META_FILE_PATH = "defaultresources.meta.json";
    public static final Gson GSON = new GsonBuilder().setLenient().setPrettyPrinting().create();
    private static final Map<String, BiFunction<String, PackType, Supplier<PackResources>>> QUEUED_RESOURCES = new HashMap<String, BiFunction<String, PackType, Supplier<PackResources>>>();
    private static final Map<String, BiFunction<String, PackType, Supplier<PackResources>>> QUEUED_STATIC_RESOURCES = new HashMap<String, BiFunction<String, PackType, Supplier<PackResources>>>();
    public static final String GLOBAL_PREFIX = "global";
    public static final GlobalResourceManager STATIC_ASSETS = DefaultResources.createStaticResourceManager(PackType.CLIENT_RESOURCES);
    public static final GlobalResourceManager STATIC_DATA = DefaultResources.createStaticResourceManager(PackType.SERVER_DATA);
    private static volatile boolean GLOBAL_SETUP = false;

    public static void forMod(Function<String, Path> inJarPathGetter, String modId) {
        block18: {
            Path defaultResourcesMeta = inJarPathGetter.apply(META_FILE_PATH);
            if (Files.exists(defaultResourcesMeta, new LinkOption[0])) {
                try (InputStream is = Files.newInputStream(defaultResourcesMeta, new OpenOption[0]);){
                    JsonObject obj = (JsonObject)GSON.fromJson((Reader)new BufferedReader(new InputStreamReader(is)), JsonObject.class);
                    ModMetaFile meta = (ModMetaFile)ModMetaFile.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)obj).getOrThrow(false, e -> {});
                    Path defaultResources = inJarPathGetter.apply(meta.resourcesPath());
                    if (!Files.exists(defaultResources, new LinkOption[0])) break block18;
                    Config.ExtractionState extractionState = Config.INSTANCE.get().extract().getOrDefault(modId, Config.ExtractionState.UNEXTRACTED);
                    if (extractionState == Config.ExtractionState.UNEXTRACTED) {
                        QUEUED_RESOURCES.put("__unextracted_" + modId, (s, type) -> {
                            if (!Files.exists(defaultResources.resolve(type.getDirectory()), new LinkOption[0])) {
                                return null;
                            }
                            return () -> new AutoMetadataPathPackResources((String)s, "", defaultResources, (PackType)type);
                        });
                        QUEUED_STATIC_RESOURCES.put("__unextracted_" + modId, (s, type) -> {
                            if (!Files.exists(defaultResources.resolve(GLOBAL_PREFIX + type.getDirectory()), new LinkOption[0])) {
                                return null;
                            }
                            return () -> new AutoMetadataPathPackResources((String)s, GLOBAL_PREFIX, defaultResources, (PackType)type);
                        });
                        break block18;
                    }
                    if (extractionState != Config.ExtractionState.EXTRACT) break block18;
                    Config.INSTANCE.get().extract().put(modId, Config.ExtractionState.EXTRACTED);
                    if (!meta.zip()) {
                        Path outPath = Services.PLATFORM.getGlobalFolder().resolve(modId);
                        if (!Files.exists(outPath, new LinkOption[0])) {
                            DefaultResources.copyResources(defaultResources, outPath);
                        }
                        break block18;
                    }
                    try (FileSystem zipFs = FileSystems.newFileSystem(URI.create("jar:" + Services.PLATFORM.getGlobalFolder().resolve(modId + ".zip").toAbsolutePath().toUri()), Collections.singletonMap("create", "true"));){
                        Path outPath = zipFs.getPath("/", new String[0]);
                        DefaultResources.copyResources(defaultResources, outPath);
                    }
                }
                catch (IOException | RuntimeException e2) {
                    LOGGER.error("Could not read meta file for mod {}", (Object)modId, (Object)e2);
                }
            }
        }
    }

    private static void copyResources(Path defaultResources, Path outPath) {
        try (Stream<Path> walk = Files.walk(defaultResources, new FileVisitOption[0]);){
            walk.forEach(p -> {
                try {
                    if (!Files.isDirectory(p, new LinkOption[0])) {
                        String rel = defaultResources.relativize((Path)p).toString();
                        Path newPath = outPath.resolve(rel);
                        if (!Files.exists(newPath.getParent(), new LinkOption[0])) {
                            Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                        }
                        Files.copy(p, newPath, new CopyOption[0]);
                    }
                }
                catch (IOException e) {
                    LOGGER.error((Object)e);
                }
            });
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
    }

    public static void cleanupExtraction() {
        Config.INSTANCE.get().save();
    }

    public static Pack.ResourcesSupplier wrap(final Function<String, PackResources> function) {
        return new Pack.ResourcesSupplier(){

            public @NonNull PackResources openPrimary(String string) {
                return (PackResources)function.apply(string);
            }

            public @NonNull PackResources openFull(String string, Pack.Info info) {
                return (PackResources)function.apply(string);
            }
        };
    }

    public static @NonNull List<Pair<String, // Could not load outer class - annotation placement on inner may be incorrect
    Pack.ResourcesSupplier>> getPackResources(PackType type) {
        ArrayList<Pair<String, Pack.ResourcesSupplier>> packs = new ArrayList<Pair<String, Pack.ResourcesSupplier>>();
        try (Stream<Path> files = Files.list(Services.PLATFORM.getGlobalFolder());){
            for (Path file : files.toList()) {
                Pack.ResourcesSupplier packResources;
                if (Files.isDirectory(file, new LinkOption[0])) {
                    packResources = DefaultResources.wrap(s -> new AutoMetadataPathPackResources((String)s, "", file, type));
                    packs.add((Pair<String, Pack.ResourcesSupplier>)new Pair((Object)file.getFileName().toString(), (Object)packResources));
                    continue;
                }
                if (!file.getFileName().toString().endsWith(".zip")) continue;
                packResources = DefaultResources.wrap(s -> new AutoMetadataPathPackResources((String)s, "", file, type));
                packs.add((Pair<String, Pack.ResourcesSupplier>)new Pair((Object)file.getFileName().toString(), (Object)packResources));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        QUEUED_RESOURCES.forEach((s, biFunction) -> {
            Supplier resources = (Supplier)biFunction.apply(s, type);
            if (resources == null) {
                return;
            }
            packs.add(new Pair(s, (Object)DefaultResources.wrap(arg_0 -> DefaultResources.lambda$getPackResources$8((Supplier)resources, arg_0))));
        });
        return packs;
    }

    private static @NonNull List<Pair<String, // Could not load outer class - annotation placement on inner may be incorrect
    Pack.ResourcesSupplier>> getStaticPackResources(PackType type) {
        ArrayList<Pair<String, Pack.ResourcesSupplier>> packs = new ArrayList<Pair<String, Pack.ResourcesSupplier>>();
        try (Stream<Path> files = Files.list(Services.PLATFORM.getGlobalFolder());){
            for (Path file : files.toList()) {
                Pack.ResourcesSupplier packResources;
                if (Files.isDirectory(file, new LinkOption[0])) {
                    packResources = DefaultResources.wrap(s -> new AutoMetadataPathPackResources((String)s, GLOBAL_PREFIX, file, type));
                    packs.add((Pair<String, Pack.ResourcesSupplier>)new Pair((Object)file.getFileName().toString(), (Object)packResources));
                    continue;
                }
                if (!file.getFileName().toString().endsWith(".zip")) continue;
                packResources = DefaultResources.wrap(s -> new AutoMetadataPathPackResources((String)s, GLOBAL_PREFIX, file, type));
                packs.add((Pair<String, Pack.ResourcesSupplier>)new Pair((Object)file.getFileName().toString(), (Object)packResources));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        QUEUED_STATIC_RESOURCES.forEach((s, biFunction) -> {
            Supplier resources = (Supplier)biFunction.apply(s, type);
            if (resources == null) {
                return;
            }
            packs.add(new Pair(s, (Object)DefaultResources.wrap(arg_0 -> DefaultResources.lambda$getStaticPackResources$12((Supplier)resources, arg_0))));
        });
        return packs;
    }

    public static synchronized void initialize() {
        if (!GLOBAL_SETUP) {
            GLOBAL_SETUP = true;
            Services.PLATFORM.extractResources();
            DefaultResources.cleanupExtraction();
        }
    }

    public static synchronized GlobalResourceManager createStaticResourceManager(PackType type) {
        DefaultResources.initialize();
        ArrayList<Pair<String, Pack.ResourcesSupplier>> sources = new ArrayList<Pair<String, Pack.ResourcesSupplier>>(DefaultResources.getStaticPackResources(type));
        sources.addAll(Services.PLATFORM.getJarProviders(type));
        return new CombinedResourceManager(type, sources);
    }

    private static /* synthetic */ PackResources lambda$getStaticPackResources$12(Supplier resources, String str) {
        return (PackResources)resources.get();
    }

    private static /* synthetic */ PackResources lambda$getPackResources$8(Supplier resources, String str) {
        return (PackResources)resources.get();
    }
}

