/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.defaultresources.impl.neoforge;

import com.mojang.datafixers.util.Pair;
import dev.lukebemish.defaultresources.impl.DefaultResources;
import dev.lukebemish.defaultresources.impl.Services;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.flag.FeatureFlagSet;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.javafmlmod.FMLJavaModLoadingContext;
import net.neoforged.neoforge.event.AddPackFindersEvent;

@Mod(value="defaultresources")
public class DefaultResourcesNeoForge {
    public DefaultResourcesNeoForge() {
        DefaultResources.initialize();
        IEventBus modbus = FMLJavaModLoadingContext.get().getModEventBus();
        modbus.register((Object)this);
    }

    @SubscribeEvent
    public void addPacks(AddPackFindersEvent event) {
        event.addRepositorySource(packConsumer -> {
            try {
                if (!Files.exists(Services.PLATFORM.getGlobalFolder(), new LinkOption[0])) {
                    Files.createDirectories(Services.PLATFORM.getGlobalFolder(), new FileAttribute[0]);
                }
                List<Pair<String, Pack.ResourcesSupplier>> packs = DefaultResources.getPackResources(event.getPackType());
                DefaultResourcesNeoForge.createPackStream(event.getPackType(), packs).forEach(packConsumer);
            }
            catch (IOException e) {
                DefaultResources.LOGGER.error("Couldn't inject resources!");
            }
        });
    }

    private static Stream<Pack> createPackStream(PackType packType, List<Pair<String, Pack.ResourcesSupplier>> packs) {
        return packs.stream().map(pair -> {
            Pack.Info info = new Pack.Info((Component)Component.literal((String)("Global Resources - " + (String)pair.getFirst())), SharedConstants.getCurrentVersion().getPackVersion(PackType.SERVER_DATA), SharedConstants.getCurrentVersion().getPackVersion(PackType.CLIENT_RESOURCES), PackCompatibility.COMPATIBLE, FeatureFlagSet.of(), List.of(), true);
            return Pack.create((String)("defaultresources:" + (String)pair.getFirst()), (Component)Component.literal((String)"Global Resources"), (boolean)true, (Pack.ResourcesSupplier)((Pack.ResourcesSupplier)pair.getSecond()), (Pack.Info)info, (Pack.Position)Pack.Position.TOP, (boolean)true, (PackSource)PackSource.DEFAULT);
        });
    }
}

