/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.defaultresources.impl.neoforge;

import com.google.auto.service.AutoService;
import com.mojang.datafixers.util.Pair;
import dev.lukebemish.defaultresources.impl.AutoMetadataPathPackResources;
import dev.lukebemish.defaultresources.impl.DefaultResources;
import dev.lukebemish.defaultresources.impl.Services;
import dev.lukebemish.defaultresources.impl.services.Platform;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.locating.IModFile;
import org.jspecify.annotations.NonNull;

@AutoService(value={Platform.class})
public class PlatformImpl
implements Platform {
    @Override
    public Path getGlobalFolder() {
        return FMLPaths.GAMEDIR.get().resolve("globalresources");
    }

    @Override
    public void extractResources() {
        try {
            if (!Files.exists(Services.PLATFORM.getGlobalFolder(), new LinkOption[0])) {
                Files.createDirectories(Services.PLATFORM.getGlobalFolder(), new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            DefaultResources.LOGGER.error((Object)e);
        }
        FMLLoader.getLoadingModList().getModFiles().stream().flatMap(f -> f.getMods().stream()).filter(PlatformImpl::isExtractable).forEach(mod -> DefaultResources.forMod(arg_0 -> PlatformImpl.lambda$extractResources$1(mod.getOwningFile().getFile(), arg_0), mod.getModId()));
    }

    @Override
    public Collection<Pair<String, Pack.ResourcesSupplier>> getJarProviders(final PackType type) {
        ArrayList<Pair<String, Pack.ResourcesSupplier>> providers = new ArrayList<Pair<String, Pack.ResourcesSupplier>>();
        FMLLoader.getLoadingModList().getModFiles().stream().flatMap(f -> f.getMods().stream()).filter(PlatformImpl::isExtractable).forEach(mod -> {
            final Path packPath = mod.getOwningFile().getFile().getSecureJar().getPath(String.join((CharSequence)"/", new CharSequence[0]), new String[0]);
            providers.add(new Pair((Object)mod.getModId(), (Object)new Pack.ResourcesSupplier(){

                public @NonNull PackResources openPrimary(@NonNull String s) {
                    return new AutoMetadataPathPackResources(s, "global", packPath, type);
                }

                public @NonNull PackResources openFull(@NonNull String s, // Could not load outer class - annotation placement on inner may be incorrect
                 @NonNull Pack.Info info) {
                    return new AutoMetadataPathPackResources(s, "global", packPath, type);
                }
            }));
        });
        return providers;
    }

    @Override
    public Path getConfigDir() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public Map<String, Path> getExistingModdedPaths(String relative) {
        return FMLLoader.getLoadingModList().getModFiles().stream().flatMap(f -> f.getMods().stream()).filter(PlatformImpl::isExtractable).map(mod -> new Pair((Object)mod.getModId(), (Object)mod.getOwningFile().getFile().findResource(new String[]{relative}))).filter(it -> it.getSecond() != null && Files.exists((Path)it.getSecond(), new LinkOption[0])).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond, (a, b) -> a));
    }

    private static boolean isExtractable(IModInfo mod) {
        return !mod.getModId().equals("forge") && !mod.getModId().equals("neoforge") && !mod.getModId().equals("minecraft");
    }

    @Override
    public boolean isClient() {
        return FMLLoader.getDist() == Dist.CLIENT;
    }

    private static /* synthetic */ Path lambda$extractResources$1(IModFile rec$, String xva$0) {
        return rec$.findResource(new String[]{xva$0});
    }
}

