/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.defaultresources.impl;

import com.google.common.collect.Sets;
import dev.lukebemish.defaultresources.impl.AutoMetadataPackResources;
import dev.lukebemish.defaultresources.impl.DefaultResources;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import org.apache.commons.io.IOUtils;
import org.jspecify.annotations.Nullable;

public class AutoMetadataFilePackResources
extends AutoMetadataPackResources {
    private final ZipFileHolder zipFileHolder;
    private final Path path;

    public AutoMetadataFilePackResources(PackLocationInfo info, String prefix, Path path, PackType packType) {
        super(info, packType, prefix);
        this.path = path;
        this.zipFileHolder = new ZipFileHolder();
    }

    private String getPathFromLocation(PackType packType, ResourceLocation location) {
        return String.format(Locale.ROOT, "%s/%s/%s", this.getPackFolderName(), location.getNamespace(), location.getPath());
    }

    public IoSupplier<InputStream> getResource(PackType packType, ResourceLocation location) {
        return this.getResource(this.getPathFromLocation(packType, location));
    }

    private @Nullable IoSupplier<InputStream> getResource(String resourcePath) {
        ZipFile zipFile = this.zipFileHolder.getOrCreateZipFile();
        if (zipFile == null) {
            return null;
        }
        ZipEntry entry = zipFile.getEntry(resourcePath);
        return entry == null ? null : IoSupplier.create((ZipFile)zipFile, (ZipEntry)entry);
    }

    public Set<String> getNamespaces(PackType type) {
        ZipFile zipFile = this.zipFileHolder.getOrCreateZipFile();
        if (zipFile == null) {
            return Set.of();
        }
        HashSet set = Sets.newHashSet();
        String prefix = this.getPackFolderName() + "/";
        for (ZipEntry zipEntry : AutoMetadataFilePackResources.ofEnumeration(zipFile.entries())) {
            String[] parts;
            String entryPath = zipEntry.getName();
            String namespace = "";
            if (entryPath.startsWith(prefix) && (parts = entryPath.substring(prefix.length()).split("/")).length != 0) {
                namespace = parts[0];
            }
            if (namespace.isEmpty()) continue;
            if (ResourceLocation.isValidNamespace((String)namespace)) {
                set.add(namespace);
                continue;
            }
            DefaultResources.LOGGER.warn(AutoMetadataFilePackResources.class.getSimpleName() + ": Non [a-z0-9_.-] character in namespace {} in pack {}, ignoring", (Object)namespace, (Object)this.path);
        }
        return set;
    }

    private static <T> Iterable<T> ofEnumeration(Enumeration<T> enumeration) {
        return enumeration::asIterator;
    }

    public void listResources(PackType packType, String namespace, String path, PackResources.ResourceOutput resourceOutput) {
        ZipFile zipFile = this.zipFileHolder.getOrCreateZipFile();
        if (zipFile != null) {
            String namespacePrefix = this.getPackFolderName() + "/" + namespace + "/";
            String pathPrefix = namespacePrefix + path + "/";
            for (ZipEntry zipEntry : AutoMetadataFilePackResources.ofEnumeration(zipFile.entries())) {
                String entryPath;
                if (zipEntry.isDirectory() || !(entryPath = zipEntry.getName()).startsWith(pathPrefix)) continue;
                ResourceLocation location = ResourceLocation.tryBuild((String)namespace, (String)entryPath.substring(namespacePrefix.length()));
                if (location != null) {
                    resourceOutput.accept((Object)location, (Object)IoSupplier.create((ZipFile)zipFile, (ZipEntry)zipEntry));
                    continue;
                }
                DefaultResources.LOGGER.warn(AutoMetadataFilePackResources.class.getSimpleName() + ": Invalid path in datapack: {}:{}, ignoring", (Object)namespace, (Object)entryPath);
            }
        }
    }

    public void close() {
        this.zipFileHolder.close();
    }

    private class ZipFileHolder
    implements AutoCloseable {
        private @Nullable ZipFile zipFile;
        private boolean loaded;

        private ZipFileHolder() {
        }

        @Nullable ZipFile getOrCreateZipFile() {
            if (this.zipFile == null && this.loaded) {
                return null;
            }
            if (this.zipFile == null) {
                this.loaded = true;
                try {
                    this.zipFile = new ZipFile(AutoMetadataFilePackResources.this.path.toFile());
                }
                catch (IOException var2) {
                    DefaultResources.LOGGER.error(AutoMetadataFilePackResources.class.getSimpleName() + ": Failed to open pack {}", (Object)AutoMetadataFilePackResources.this.path, (Object)var2);
                    return null;
                }
            }
            return this.zipFile;
        }

        @Override
        public void close() {
            if (this.zipFile != null) {
                IOUtils.closeQuietly((Closeable)this.zipFile);
                this.zipFile = null;
            }
        }
    }
}

