/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.defaultresources.impl;

import com.google.common.base.Suppliers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.defaultresources.impl.DefaultResources;
import dev.lukebemish.defaultresources.impl.DefaultResourcesMetadataSection;
import dev.lukebemish.defaultresources.impl.ModMetaFile;
import dev.lukebemish.defaultresources.impl.Services;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import net.minecraft.util.StringRepresentable;

public record Config(ConcurrentHashMap<String, ExtractionState> extract, HashMap<String, Boolean> fromResourcePacks) {
    public static final Codec<Config> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)StringRepresentable.fromEnum(ExtractionState::values)).xmap(ConcurrentHashMap::new, Function.identity()).fieldOf("extract").forGetter(Config::extract), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.BOOL).fieldOf("from_resource_packs").xmap(HashMap::new, Function.identity()).forGetter(Config::fromResourcePacks)).apply((Applicative)i, Config::new));
    public static final Supplier<Config> INSTANCE = Suppliers.memoize(Config::readFromConfig);

    private static Config getDefault() {
        return new Config(new ConcurrentHashMap<String, ExtractionState>(), new HashMap<String, Boolean>());
    }

    private static Config readFromConfig() {
        HashMap<String, Boolean> resourcePacks;
        ConcurrentHashMap<String, ExtractionState> map;
        Config config;
        Path configPath;
        block15: {
            configPath = Services.PLATFORM.getConfigDir().resolve("defaultresources.json");
            config = Config.getDefault();
            if (Files.exists(configPath, new LinkOption[0])) {
                try {
                    JsonElement json = (JsonElement)DefaultResources.GSON.fromJson((Reader)Files.newBufferedReader(configPath), JsonElement.class);
                    config = (Config)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow();
                }
                catch (IOException e) {
                    DefaultResources.LOGGER.error("Could not read {}.json config; using (and replacing) with default.", (Object)"defaultresources", (Object)e);
                }
                catch (JsonSyntaxException e) {
                    DefaultResources.LOGGER.error("Error parsing {}.json config; using (and replacing) with default.", (Object)"defaultresources", (Object)e);
                }
                catch (RuntimeException e) {
                    DefaultResources.LOGGER.error("Error parsing {}.json config; using (and replacing) with default: {}", (Object)"defaultresources", (Object)e);
                }
            }
            map = new ConcurrentHashMap<String, ExtractionState>(config.extract());
            Services.PLATFORM.getExistingModdedPaths("defaultresources.meta.json").forEach((modId, metaPath) -> {
                try (InputStream is = Files.newInputStream(metaPath, new OpenOption[0]);){
                    JsonElement object = (JsonElement)DefaultResources.GSON.fromJson((Reader)new InputStreamReader(is), JsonElement.class);
                    ModMetaFile metaFile = (ModMetaFile)ModMetaFile.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)object).getOrThrow();
                    if (!map.containsKey(modId)) {
                        map.put((String)modId, metaFile.extract() ? ExtractionState.EXTRACT : ExtractionState.UNEXTRACTED);
                    }
                }
                catch (IOException | RuntimeException e) {
                    DefaultResources.LOGGER.warn("We thought there was a readable {} for mod {}, but we got an error when reading it!", (Object)"defaultresources.meta.json", modId, (Object)e);
                }
            });
            resourcePacks = new HashMap<String, Boolean>();
            HashMap<String, Boolean> originalResourcePacks = config.fromResourcePacks();
            Path resourcePacksPath = Services.PLATFORM.getResourcePackDir();
            try (Stream<Path> paths = Files.list(resourcePacksPath);){
                paths.forEach(path -> {
                    boolean detect;
                    String fileName = path.getFileName().toString();
                    if (fileName.endsWith(".zip") || fileName.endsWith(".jar")) {
                        detect = Config.checkZipForMeta(path);
                    } else if (Files.isDirectory(path, new LinkOption[0])) {
                        detect = Config.checkPathForMeta(path);
                    } else {
                        return;
                    }
                    if (detect) {
                        resourcePacks.put(fileName, originalResourcePacks.getOrDefault(fileName, true));
                    }
                });
            }
            catch (IOException e) {
                if (!Files.exists(resourcePacksPath, new LinkOption[0])) break block15;
                DefaultResources.LOGGER.warn("Could not read resource packs from {}!", (Object)resourcePacksPath, (Object)e);
            }
        }
        config = new Config(map, resourcePacks);
        try {
            Config.writeConfig(configPath, config);
        }
        catch (IOException e) {
            DefaultResources.LOGGER.error("Could not write {}.json config. There may be odd behavior. ", (Object)"defaultresources", (Object)e);
        }
        return config;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkZipForMeta(Path path) {
        try (ZipFile zipFile = new ZipFile(path.toFile());
             InputStream reader = zipFile.getInputStream(zipFile.getEntry("pack.mcmeta"));){
            if (reader == null) return false;
            JsonObject object = (JsonObject)DefaultResources.GSON.fromJson((Reader)new InputStreamReader(reader), JsonObject.class);
            JsonElement meta = object.get("defaultresources");
            DataResult result = DefaultResourcesMetadataSection.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)meta);
            if (result.error().isPresent()) {
                DefaultResources.LOGGER.error("Could not read metadata of {} for resource pack detection; ignoring: {}", (Object)path.getFileName(), result.error().get());
            }
            boolean bl = result.result().isPresent() && ((DefaultResourcesMetadataSection)result.result().get()).detect();
            return bl;
        }
        catch (Exception e) {
            DefaultResources.LOGGER.error("Could not read {}, which looks like a zip file, for resource pack detection; ignoring.", (Object)path.getFileName(), (Object)e);
        }
        return false;
    }

    private static boolean checkPathForMeta(Path path) {
        Path metaFile = path.resolve("pack.mcmeta");
        if (Files.exists(metaFile, new LinkOption[0])) {
            boolean bl;
            block10: {
                BufferedReader reader = Files.newBufferedReader(metaFile);
                try {
                    JsonObject object = (JsonObject)DefaultResources.GSON.fromJson((Reader)reader, JsonObject.class);
                    JsonElement meta = object.get("defaultresources");
                    DataResult result = DefaultResourcesMetadataSection.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)meta);
                    if (result.error().isPresent()) {
                        DefaultResources.LOGGER.error("Could not read metadata of {} for resource pack detection; ignoring: {}", (Object)path.getFileName(), result.error().get());
                    }
                    boolean bl2 = bl = result.result().isPresent() && ((DefaultResourcesMetadataSection)result.result().get()).detect();
                    if (reader == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        DefaultResources.LOGGER.error("Could not read {} for resource pack detection; ignoring.", (Object)path.getFileName(), (Object)e);
                    }
                }
                reader.close();
            }
            return bl;
        }
        return false;
    }

    private static void writeConfig(Path path, Config config) throws IOException {
        if (!Files.exists(path.getParent(), new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        Files.deleteIfExists(path);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write("// Set extraction to \"extract\" to extract currently unextracted resources.\n");
            DefaultResources.GSON.toJson((JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)config).getOrThrow(IOException::new), (Appendable)writer);
        }
    }

    public void save() {
        Path configPath = Services.PLATFORM.getConfigDir().resolve("defaultresources.json");
        try {
            Config.writeConfig(configPath, this);
        }
        catch (IOException e) {
            DefaultResources.LOGGER.error("Could not save {} config!", (Object)"defaultresources", (Object)e);
        }
    }

    static enum ExtractionState implements StringRepresentable
    {
        UNEXTRACTED,
        EXTRACT,
        EXTRACTED,
        OUTDATED;


        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

