/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.excavated_variants.client;

import io.github.lukebemish.excavated_variants.ModifiedOreBlock;
import io.github.lukebemish.excavated_variants.client.VariantAssembler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public class BlockstateModelParser {
    public Map<String, List<VariantAssembler>> variants = new HashMap<String, List<VariantAssembler>>();

    public static BlockstateModelParser create(ModifiedOreBlock block, List<ResourceLocation> modelLocs) {
        BlockstateModelParser assembler = new BlockstateModelParser();
        if (block.isFacingType()) {
            for (Direction d : Direction.values()) {
                ArrayList<VariantAssembler> vars = new ArrayList<VariantAssembler>();
                for (ResourceLocation rl : modelLocs) {
                    vars.add(VariantAssembler.fromFacing(rl, d));
                }
                assembler.variants.put("facing=" + d.m_122433_(), vars);
            }
        } else if (block.isAxisType()) {
            for (Direction.Axis a : Direction.Axis.values()) {
                ArrayList<VariantAssembler> vars = new ArrayList<VariantAssembler>();
                for (ResourceLocation rl : modelLocs) {
                    vars.add(VariantAssembler.fromAxis(rl, a));
                }
                assembler.variants.put("axis=" + a.m_122477_(), vars);
            }
        } else {
            ArrayList<VariantAssembler> vars = new ArrayList<VariantAssembler>();
            for (ResourceLocation rl : modelLocs) {
                vars.add(VariantAssembler.fromModel(rl));
            }
            assembler.variants.put("", vars);
        }
        return assembler;
    }
}

