/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.excavatedvariants;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.lukebemish.excavatedvariants.ExcavatedVariants;
import dev.lukebemish.excavatedvariants.data.BaseOre;
import dev.lukebemish.excavatedvariants.data.BaseStone;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.packs.resources.IoSupplier;

public class LangBuilder {
    private static final Codec<Map<String, String>> CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING);
    private final Map<String, Map<String, String>> internal = new HashMap<String, Map<String, String>>();

    public void add(String fullId, BaseStone stone, BaseOre ore) {
        HashSet<String> combinedKeys = new HashSet<String>(stone.lang.keySet());
        combinedKeys.addAll(ore.lang.keySet());
        for (String langName : combinedKeys) {
            String stoneLang = stone.lang.getOrDefault(langName, "excavated_variants.stone." + stone.id);
            String oreLang = ore.lang.getOrDefault(langName, "excavated_variants.ore." + ore.id);
            Object name = oreLang.contains("$") ? oreLang.replaceFirst("\\$", stoneLang) : stoneLang + " " + oreLang;
            this.internal.computeIfAbsent(langName, k -> new HashMap()).put("block.excavated_variants." + fullId, name);
        }
    }

    public void add(String key, String name) {
        this.internal.computeIfAbsent("en_us", k -> new HashMap()).put(key, name);
    }

    public Set<String> languages() {
        return this.internal.keySet();
    }

    public IoSupplier<InputStream> build(String langName) {
        String json = ExcavatedVariants.GSON.toJson((JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, this.internal.getOrDefault(langName, Map.of())).getOrThrow(false, e -> {}));
        return () -> new ByteArrayInputStream(json.getBytes());
    }
}

