/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.excavatedvariants;

import dev.lukebemish.excavatedvariants.ExcavatedVariants;
import dev.lukebemish.excavatedvariants.data.BaseOre;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;

public record S2CConfigAgreementPacket(Set<String> blocks) {
    public static S2CConfigAgreementPacket decoder(FriendlyByteBuf buffer) {
        ArrayList<String> blocks = new ArrayList<String>();
        int i = buffer.readInt();
        for (int j = 0; j < i; ++j) {
            blocks.add(buffer.m_130277_());
        }
        return new S2CConfigAgreementPacket(new HashSet<String>(blocks));
    }

    private static String ellipsis(String str, int length) {
        if (str.length() <= length) {
            return str;
        }
        return str.substring(0, length - 3) + "...";
    }

    public void encoder(FriendlyByteBuf buffer) {
        buffer.writeInt(this.blocks.size());
        this.blocks.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130070_(arg_0));
    }

    public void consumeMessage(Consumer<String> disconnecter) {
        ExcavatedVariants.setupMap();
        Set knownBlocks = ExcavatedVariants.oreStoneList.stream().flatMap(p -> ((HashSet)p.getSecond()).stream().map(stone -> stone.id + "_" + ((BaseOre)p.getFirst()).id)).collect(Collectors.toSet());
        Set serverOnly = this.blocks.stream().filter(b -> !knownBlocks.contains(b)).collect(Collectors.toSet());
        Set clientOnly = knownBlocks.stream().filter(b -> !this.blocks.contains(b)).collect(Collectors.toSet());
        if (clientOnly.size() == 0 && serverOnly.size() == 0) {
            return;
        }
        Object disconnect = "Connection closed - mismatched ore variant list";
        if (clientOnly.size() > 0) {
            String clientOnlyStr = String.join((CharSequence)"\n    ", clientOnly.stream().toList());
            ExcavatedVariants.LOGGER.error("Client contains ore variants not present on server:\n    {}", (Object)clientOnlyStr);
            disconnect = (String)disconnect + "\nMissing on server: " + S2CConfigAgreementPacket.ellipsis(clientOnly.toString(), 50);
        }
        if (serverOnly.size() > 0) {
            String serverOnlyStr = String.join((CharSequence)"\n    ", serverOnly.stream().toList());
            ExcavatedVariants.LOGGER.error("Server contains ore variants not present on client:\n    {}", (Object)serverOnlyStr);
            disconnect = (String)disconnect + "\nMissing on client: " + S2CConfigAgreementPacket.ellipsis(serverOnly.toString(), 50);
        }
        disconnecter.accept((String)disconnect);
    }
}

