/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.excavatedvariants.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import dev.lukebemish.dynamicassetgenerator.api.IInputStreamSource;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.AssetResourceCache;
import dev.lukebemish.dynamicassetgenerator.api.client.ClientPrePackRepository;
import dev.lukebemish.excavatedvariants.ExcavatedVariants;
import dev.lukebemish.excavatedvariants.ModifiedOreBlock;
import dev.lukebemish.excavatedvariants.client.BackupFetcher;
import dev.lukebemish.excavatedvariants.client.BlockModelHolder;
import dev.lukebemish.excavatedvariants.client.BlockModelParser;
import dev.lukebemish.excavatedvariants.client.BlockstateModelParser;
import dev.lukebemish.excavatedvariants.client.TextureRegistrar;
import dev.lukebemish.excavatedvariants.data.BaseOre;
import dev.lukebemish.excavatedvariants.data.BaseStone;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.BlockModelDefinition;
import net.minecraft.client.renderer.block.model.MultiVariant;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.IoSupplier;

public class BlockStateAssembler {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().create();

    public static Map<ResourceLocation, IoSupplier<InputStream>> getMap(TextureRegistrar registrar, Collection<Pair<BaseOre, BaseStone>> originalPairs, List<Pair<BaseOre, BaseStone>> toMake, ResourceGenerationContext context) {
        ResourceLocation stoneRl2;
        ResourceLocation oreRl;
        BaseOre ore;
        BlockModelDefinition.Context ctx = new BlockModelDefinition.Context();
        HashMap<ResourceLocation, IoSupplier<InputStream>> resources = new HashMap<ResourceLocation, IoSupplier<InputStream>>();
        HashMap<String, Pair<BlockModelDefinition, List<Pair<BlockModelHolder, List<List<ResourceLocation>>>>>> oreInfoMap = new HashMap<String, Pair<BlockModelDefinition, List<Pair<BlockModelHolder, List<List<ResourceLocation>>>>>>();
        HashMap<String, Pair<BlockModelDefinition, List<Pair<BlockModelHolder, List<List<ResourceLocation>>>>>> stoneInfoMap = new HashMap<String, Pair<BlockModelDefinition, List<Pair<BlockModelHolder, List<List<ResourceLocation>>>>>>();
        HashMap oreStonePairMap = new HashMap();
        for (Pair<BaseOre, BaseStone> p : toMake) {
            ore = (BaseOre)p.getFirst();
            BaseStone stone = (BaseStone)p.getSecond();
            try {
                if (!oreInfoMap.containsKey(ore.id)) {
                    oreRl = ore.blockId.get(0);
                    oreInfoMap.put(ore.id, BlockStateAssembler.getInfoFromBlockstate(oreRl, ctx));
                }
                if (stoneInfoMap.containsKey(stone.id)) continue;
                stoneRl2 = stone.blockId;
                stoneInfoMap.put(stone.id, BlockStateAssembler.getInfoFromBlockstate(stoneRl2, ctx));
            }
            catch (IOException e) {
                ExcavatedVariants.LOGGER.info((Object)e);
            }
        }
        for (Pair<BaseOre, BaseStone> p : originalPairs) {
            ore = (BaseOre)p.getFirst();
            BaseStone base = (BaseStone)p.getSecond();
            try {
                if (!oreInfoMap.containsKey(ore.id)) {
                    oreRl = ore.blockId.get(0);
                    oreInfoMap.put(ore.id, BlockStateAssembler.getInfoFromBlockstate(oreRl, ctx));
                }
                if (!stoneInfoMap.containsKey(base.id)) {
                    stoneRl2 = base.blockId;
                    stoneInfoMap.put(base.id, BlockStateAssembler.getInfoFromBlockstate(stoneRl2, ctx));
                }
                Pair stoneInfo = (Pair)stoneInfoMap.get(base.id);
                Pair oreInfo = (Pair)oreInfoMap.get(ore.id);
                if (stoneInfo != null && oreInfo != null && ((List)stoneInfo.getSecond()).size() >= 1 && ((List)oreInfo.getSecond()).size() >= 1) {
                    ArrayList<Pair> oreStonePairs = new ArrayList<Pair>();
                    oreStonePairMap.put(ore.id, oreStonePairs);
                    List holders = (List)oreInfo.getSecond();
                    for (Pair holder : holders) {
                        for (Object rls : (List)holder.getSecond()) {
                            oreStonePairs.add(new Pair(rls, (Object)((List)((List)((Pair)((List)stoneInfo.getSecond()).get(0)).getSecond()).get(0))));
                        }
                    }
                    continue;
                }
                ExcavatedVariants.LOGGER.warn("Bad info while extracting from blocks {} and {}:{}", (Object)ore.blockId.get(0).toString(), (Object)base.blockId.toString(), (Object)((stoneInfo == null ? "\nMissing stone block model info" : "") + (oreInfo == null ? "\nMissing ore block model info" : "") + (stoneInfo != null && ((List)stoneInfo.getSecond()).size() < 1 ? "\nNo stone textures found" : "") + (oreInfo != null && ((List)oreInfo.getSecond()).size() < 1 ? "\nNo ore textures found" : "")));
            }
            catch (IOException e) {
                ExcavatedVariants.LOGGER.info((Object)e);
            }
            catch (JsonSyntaxException e) {
                ExcavatedVariants.LOGGER.error((Object)e);
            }
        }
        for (Pair<BaseOre, BaseStone> p : toMake) {
            Pair oreInfo = (Pair)oreInfoMap.get(((BaseOre)p.getFirst()).id);
            Pair stoneInfo = (Pair)stoneInfoMap.get(((BaseStone)p.getSecond()).id);
            List oreStonePair = (List)oreStonePairMap.get(((BaseOre)p.getFirst()).id);
            BaseStone stone = (BaseStone)p.getSecond();
            BaseOre ore2 = (BaseOre)p.getFirst();
            String fullId = stone.id + "_" + ore2.id;
            ModifiedOreBlock outBlock = ExcavatedVariants.getBlocks().get(fullId);
            if (oreInfo != null && stoneInfo != null && oreStonePair != null && outBlock != null) {
                HashMap<Pair<ResourceLocation, ResourceLocation>, ResourceLocation> texMap = new HashMap<Pair<ResourceLocation, ResourceLocation>, ResourceLocation>();
                int index = 0;
                for (List stoneBG : ((List)stoneInfo.getSecond()).stream().flatMap(pair -> ((List)pair.getSecond()).stream()).collect(Collectors.toSet())) {
                    for (Pair exp : oreStonePair) {
                        ResourceLocation outRL = new ResourceLocation("excavated_variants", "textures/block/" + fullId + index + ".png");
                        ResourceLocation outRlInternal = new ResourceLocation("excavated_variants", "block/" + fullId + index);
                        Pair<IInputStreamSource, IInputStreamSource> sources = registrar.setupExtractor((List)exp.getSecond(), (List)exp.getFirst(), (ResourceLocation)stoneBG.get(0), outRlInternal);
                        resources.put(outRL, (IoSupplier<InputStream>)((IInputStreamSource)sources.getFirst()).get(outRL, context));
                        resources.put(new ResourceLocation(outRL.m_135827_(), outRL.m_135815_() + ".mcmeta"), (IoSupplier<InputStream>)((IInputStreamSource)sources.getSecond()).get(new ResourceLocation(outRL.m_135827_(), outRL.m_135815_() + ".mcmeta"), context));
                        ++index;
                        texMap.put(new Pair((Object)((ResourceLocation)stoneBG.get(0)), (Object)((ResourceLocation)((List)exp.getFirst()).get(0))), outRlInternal);
                        stoneBG.stream().skip(1L).forEach(stoneRl -> ((List)exp.getSecond()).stream().skip(1L).forEach(oreRl -> texMap.put(new Pair(stoneRl, oreRl), AssetResourceCache.EMPTY_TEXTURE)));
                    }
                }
                List<ResourceLocation> defaultModels = ((MultiVariant)((BlockModelDefinition)oreInfo.getFirst()).m_173427_().stream().findFirst().get()).m_111848_().stream().map(Variant::m_111883_).toList();
                ResourceLocation stoneModel = ((MultiVariant)((BlockModelDefinition)stoneInfo.getFirst()).m_173427_().stream().findFirst().get()).m_111848_().stream().map(Variant::m_111883_).findFirst().get();
                ArrayList<ResourceLocation> outModelRLs = new ArrayList<ResourceLocation>();
                try {
                    InputStream read;
                    try {
                        read = ClientPrePackRepository.getResource((ResourceLocation)new ResourceLocation(stoneModel.m_135827_(), "models/" + stoneModel.m_135815_() + ".json"));
                    }
                    catch (IOException e) {
                        read = BackupFetcher.provideBlockModelFile(stoneModel);
                    }
                    BlockModelParser parentModel = BlockModelParser.readModel(new BufferedReader(new InputStreamReader(read, StandardCharsets.UTF_8)));
                    ArrayList<ResourceLocation> stoneLocs = new ArrayList<ResourceLocation>(parentModel.textures.values().stream().map(x -> ResourceLocation.m_135822_((String)x, (char)':')).toList());
                    if (parentModel.children != null) {
                        stoneLocs.addAll(parentModel.children.values().stream().flatMap(parser -> parser.textures.values().stream()).map(x -> ResourceLocation.m_135822_((String)x, (char)':')).toList());
                    }
                    int i2 = 0;
                    for (ResourceLocation m : defaultModels) {
                        InputStream oreRead;
                        InputStream stoneRead;
                        try {
                            stoneRead = ClientPrePackRepository.getResource((ResourceLocation)new ResourceLocation(stoneModel.m_135827_(), "models/" + stoneModel.m_135815_() + ".json"));
                        }
                        catch (IOException e) {
                            stoneRead = BackupFetcher.provideBlockModelFile(stoneModel);
                        }
                        BlockModelParser outputModel = BlockModelParser.readModel(new BufferedReader(new InputStreamReader(stoneRead, StandardCharsets.UTF_8)));
                        try {
                            stoneRead = ClientPrePackRepository.getResource((ResourceLocation)new ResourceLocation(stoneModel.m_135827_(), "models/" + stoneModel.m_135815_() + ".json"));
                        }
                        catch (IOException e) {
                            stoneRead = BackupFetcher.provideBlockModelFile(stoneModel);
                        }
                        JsonObject outputMap = (JsonObject)GSON.fromJson((Reader)new BufferedReader(new InputStreamReader(stoneRead, StandardCharsets.UTF_8)), JsonObject.class);
                        try {
                            oreRead = ClientPrePackRepository.getResource((ResourceLocation)new ResourceLocation(m.m_135827_(), "models/" + m.m_135815_() + ".json"));
                        }
                        catch (IOException e) {
                            oreRead = BackupFetcher.provideBlockModelFile(m);
                        }
                        StringBuilder oreTextBuilder = new StringBuilder();
                        BufferedReader oreReader = new BufferedReader(new InputStreamReader(oreRead, StandardCharsets.UTF_8));
                        int oreC = 0;
                        while ((oreC = ((Reader)oreReader).read()) != -1) {
                            oreTextBuilder.append((char)oreC);
                        }
                        BlockModelParser oreModel = BlockModelParser.readModel(oreTextBuilder.toString());
                        BlockModelHolder oreModelHolder = BlockModelHolder.getFromString(oreTextBuilder.toString());
                        Set<ResourceLocation> oreLocs = BlockStateAssembler.extractTextures(oreModelHolder);
                        ResourceLocation mainOreTex = oreLocs.stream().filter(x -> !stoneLocs.contains(x) && texMap.entrySet().stream().anyMatch(y -> ((ResourceLocation)((Pair)y.getKey()).getSecond()).equals(x) && !((ResourceLocation)y.getValue()).equals((Object)AssetResourceCache.EMPTY_TEXTURE))).findFirst().orElse(oreLocs.stream().filter(x -> texMap.entrySet().stream().anyMatch(y -> ((ResourceLocation)((Pair)y.getKey()).getSecond()).equals(x) && !((ResourceLocation)y.getValue()).equals((Object)AssetResourceCache.EMPTY_TEXTURE))).findFirst().orElse(null));
                        BlockStateAssembler.remapTextures(texMap, outputModel, outputMap, mainOreTex);
                        texMap.values().stream().filter(rl -> !AssetResourceCache.EMPTY_TEXTURE.equals(rl)).findFirst().ifPresent(rl -> BlockStateAssembler.setParticleTexture(outputMap, rl));
                        ResourceLocation outModelRL = new ResourceLocation("excavated_variants", "block/" + fullId + i2);
                        outModelRLs.add(outModelRL);
                        String finalJson = GSON.toJson((JsonElement)outputMap);
                        resources.put(new ResourceLocation("excavated_variants", "models/" + outModelRL.m_135815_() + ".json"), (IoSupplier<InputStream>)((IoSupplier)() -> new ByteArrayInputStream(finalJson.getBytes())));
                        ++i2;
                    }
                    BlockstateModelParser assembler = BlockstateModelParser.create(outBlock, outModelRLs);
                    String bs = GSON.toJson((Object)assembler);
                    resources.put(new ResourceLocation("excavated_variants", "blockstates/" + fullId + ".json"), (IoSupplier<InputStream>)((IoSupplier)() -> new ByteArrayInputStream(bs.getBytes())));
                }
                catch (IOException e) {
                    ExcavatedVariants.LOGGER.error((Object)e);
                }
                continue;
            }
            ExcavatedVariants.LOGGER.warn("Missing {}for ore {}", (Object)((oreInfo == null ? "ore model info, " : "") + (stoneInfo == null ? "stone model info, " : "") + (oreStonePair == null ? "texture extractor info, " : "") + (outBlock == null ? "registered block, " : "")), (Object)fullId);
        }
        return resources;
    }

    private static Set<ResourceLocation> extractTextures(BlockModelHolder oreModelHolder) {
        HashSet<ResourceLocation> rls = new HashSet<ResourceLocation>(oreModelHolder.getResolvedTextureMap().values());
        if (oreModelHolder.children().isPresent()) {
            oreModelHolder.children().get().values().forEach(holder -> rls.addAll(BlockStateAssembler.extractTextures(holder)));
        }
        return rls;
    }

    private static void setParticleTexture(JsonObject outputMap, ResourceLocation particle) {
        Object object;
        if (outputMap.has("textures") && (object = outputMap.get("textures")) instanceof JsonObject) {
            JsonObject textures = (JsonObject)object;
            textures.add("particle", (JsonElement)new JsonPrimitive(particle.toString()));
        }
        if (outputMap.has("children") && (object = outputMap.get("children")) instanceof JsonObject) {
            JsonObject children = (JsonObject)object;
            for (String key : children.keySet()) {
                JsonElement jsonElement = children.get(key);
                if (!(jsonElement instanceof JsonObject)) continue;
                JsonObject jsonObject = (JsonObject)jsonElement;
                BlockStateAssembler.setParticleTexture(jsonObject, particle);
            }
        }
    }

    private static void remapTextures(Map<Pair<ResourceLocation, ResourceLocation>, ResourceLocation> texMap, BlockModelParser outputModel, JsonObject outputMap, ResourceLocation mainOreTex) {
        JsonObject jsonObject;
        JsonElement jsonElement;
        if (outputModel.textures != null) {
            for (String string : outputModel.textures.keySet()) {
                String val = outputModel.textures.get(string);
                ResourceLocation old = ResourceLocation.m_135822_((String)val, (char)':');
                ResourceLocation lookup = texMap.get(new Pair((Object)old, (Object)mainOreTex));
                if (lookup == null) continue;
                outputModel.replaceTexture(old, lookup);
            }
            outputMap.add("textures", GSON.toJsonTree(outputModel.textures));
        }
        if (outputModel.children != null && outputMap.has("children") && (jsonElement = outputMap.get("children")) instanceof JsonObject && (jsonObject = (JsonObject)jsonElement).keySet().equals(outputModel.children.keySet())) {
            JsonArray jsonArray = new JsonArray();
            for (String key : jsonObject.keySet()) {
                BlockModelParser modelE = outputModel.children.get(key);
                JsonElement mapE = jsonObject.get(key);
                if (!(mapE instanceof JsonObject)) continue;
                JsonObject modelMapObject = (JsonObject)mapE;
                BlockStateAssembler.remapTextures(texMap, modelE, modelMapObject, mainOreTex);
                jsonArray.add(mapE);
            }
            outputMap.add("children", (JsonElement)jsonArray);
        }
    }

    private static Pair<BlockModelDefinition, List<Pair<BlockModelHolder, List<List<ResourceLocation>>>>> getInfoFromBlockstate(ResourceLocation oreRl, BlockModelDefinition.Context ctx) throws IOException {
        InputStream oreBSIS;
        ResourceLocation oreBS = new ResourceLocation(oreRl.m_135827_(), "blockstates/" + oreRl.m_135815_() + ".json");
        try {
            oreBSIS = ClientPrePackRepository.getResource((ResourceLocation)oreBS);
        }
        catch (IOException e) {
            oreBSIS = BackupFetcher.provideBlockstateFile(oreRl);
        }
        BlockModelDefinition oreBMD = BlockModelDefinition.m_111540_((BlockModelDefinition.Context)ctx, (Reader)new BufferedReader(new InputStreamReader(oreBSIS, StandardCharsets.UTF_8)));
        if (!oreBMD.m_111543_()) {
            HashSet oreModels = new HashSet();
            for (Map.Entry e : oreBMD.m_111539_().entrySet()) {
                oreModels.addAll(((MultiVariant)e.getValue()).m_7970_());
            }
            ArrayList<Pair<BlockModelHolder, List<List<ResourceLocation>>>> modelsList = new ArrayList<Pair<BlockModelHolder, List<List<ResourceLocation>>>>();
            for (ResourceLocation mRl : oreModels) {
                BlockModelHolder holder = BlockModelHolder.getFromLocation(mRl);
                if (holder == null) continue;
                modelsList.add(BlockStateAssembler.createOverlayStack(holder));
            }
            return new Pair((Object)oreBMD, modelsList);
        }
        return null;
    }

    private static Pair<BlockModelHolder, List<List<ResourceLocation>>> createOverlayStack(BlockModelHolder holder) {
        return new Pair((Object)holder, holder.setupOverlays());
    }
}

