/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.excavatedvariants.client;

import com.mojang.datafixers.util.Pair;
import dev.lukebemish.dynamicassetgenerator.api.IInputStreamSource;
import dev.lukebemish.dynamicassetgenerator.api.IPathAwareInputStreamSource;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.ITexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TextureGenerator;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TextureMetaGenerator;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources.AnimationFrameCapture;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources.AnimationSplittingSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources.ForegroundTransfer;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources.Overlay;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources.TextureReader;
import dev.lukebemish.excavatedvariants.client.BlockStateAssembler;
import dev.lukebemish.excavatedvariants.data.BaseOre;
import dev.lukebemish.excavatedvariants.data.BaseStone;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.NotNull;

public class TextureRegistrar
implements Supplier<IPathAwareInputStreamSource> {
    private final Collection<Pair<BaseOre, BaseStone>> originalPairs;
    private final List<Pair<BaseOre, BaseStone>> toMake;
    private final ResourceGenerationContext resourceGenerationContext;

    public TextureRegistrar(Collection<Pair<BaseOre, BaseStone>> originalPairs, List<Pair<BaseOre, BaseStone>> toMake, ResourceGenerationContext context) {
        this.originalPairs = originalPairs;
        this.toMake = toMake;
        this.resourceGenerationContext = context;
    }

    public Pair<IInputStreamSource, IInputStreamSource> setupExtractor(List<ResourceLocation> stoneOrigs, List<ResourceLocation> ores, ResourceLocation stoneNew, ResourceLocation out) {
        HashMap<Object, AnimationSplittingSource.TimeAwareSource> sourceMap = new HashMap<Object, AnimationSplittingSource.TimeAwareSource>();
        int c1 = 0;
        for (ResourceLocation resourceLocation : stoneOrigs) {
            sourceMap.put("stoneOrig" + c1, new AnimationSplittingSource.TimeAwareSource((ITexSource)new TextureReader(resourceLocation), 1));
            ++c1;
        }
        int c3 = 0;
        for (ResourceLocation ore : ores) {
            sourceMap.put("ore" + c3, new AnimationSplittingSource.TimeAwareSource((ITexSource)new TextureReader(ore), 1));
            ++c3;
        }
        sourceMap.put("stoneNew", new AnimationSplittingSource.TimeAwareSource((ITexSource)new TextureReader(stoneNew), 1));
        ArrayList<AnimationFrameCapture> arrayList = new ArrayList<AnimationFrameCapture>();
        for (int c2 = 0; c2 < c1; ++c2) {
            arrayList.add(new AnimationFrameCapture("stoneOrig" + c2));
        }
        ArrayList<AnimationFrameCapture> oreSources = new ArrayList<AnimationFrameCapture>();
        for (int c2 = 0; c2 < c3; ++c2) {
            oreSources.add(new AnimationFrameCapture("ore" + c2));
        }
        TextureGenerator p1 = new TextureGenerator(out, (ITexSource)new AnimationSplittingSource(sourceMap, (ITexSource)new ForegroundTransfer((ITexSource)new Overlay(arrayList), (ITexSource)new Overlay(oreSources), (ITexSource)new AnimationFrameCapture("stoneNew"), 6, true, true, true, 0.2)));
        ArrayList<ResourceLocation> sources = new ArrayList<ResourceLocation>(stoneOrigs);
        sources.addAll(ores);
        sources.add(stoneNew);
        TextureMetaGenerator p2 = new TextureMetaGenerator(sources, Optional.empty(), Optional.empty(), Optional.empty(), out);
        return new Pair((Object)p1, (Object)p2);
    }

    @Override
    public IPathAwareInputStreamSource get() {
        final Map<ResourceLocation, IoSupplier<InputStream>> resources = BlockStateAssembler.getMap(this, this.originalPairs, this.toMake, this.resourceGenerationContext);
        return new IPathAwareInputStreamSource(){

            @NotNull
            public Set<ResourceLocation> getLocations() {
                return resources.keySet();
            }

            public IoSupplier<InputStream> get(ResourceLocation outRl, ResourceGenerationContext context) {
                return resources.getOrDefault(outRl, null);
            }
        };
    }
}

