/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.excavatedvariants.compat.rei;

import com.mojang.datafixers.util.Pair;
import dev.lukebemish.excavatedvariants.ExcavatedVariants;
import dev.lukebemish.excavatedvariants.data.BaseOre;
import dev.lukebemish.excavatedvariants.data.BaseStone;
import dev.lukebemish.excavatedvariants.platform.Services;
import dev.lukebemish.excavatedvariants.recipe.OreConversionRecipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;

public class ExcavatedVariantsClientPlugin
implements REIClientPlugin {
    public void registerDisplays(DisplayRegistry registry) {
        if (ExcavatedVariants.getConfig().addConversionRecipes && ExcavatedVariants.getConfig().jeiReiCompat) {
            ArrayList<ShapelessRecipe> recipes = new ArrayList<ShapelessRecipe>();
            OreConversionRecipe.assembleOrNull();
            for (Pair<BaseOre, HashSet<BaseStone>> p : ExcavatedVariants.oreStoneList) {
                ArrayList<Item> arrayList = new ArrayList<Item>();
                for (BaseStone stone : (HashSet)p.getSecond()) {
                    ResourceLocation rl = new ResourceLocation("excavated_variants", stone.id + "_" + ((BaseOre)p.getFirst()).id);
                    Item item = Services.REGISTRY_UTIL.getItemById(rl);
                    if (item == null) continue;
                    arrayList.add(item);
                }
                Item outItem = Services.REGISTRY_UTIL.getItemById(((BaseOre)p.getFirst()).blockId.get(0));
                if (arrayList.isEmpty() || outItem == null) continue;
                Ingredient input = Ingredient.m_43921_(arrayList.stream().map(ItemStack::new));
                ItemStack output = new ItemStack((ItemLike)outItem);
                NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{input});
                String oreId = ((BaseOre)p.getFirst()).id;
                recipes.add(new ShapelessRecipe(new ResourceLocation("excavated_variants", oreId + "_conversion"), "excavated_variants.ore_conversion", CraftingBookCategory.MISC, output, inputs));
            }
            CategoryIdentifier categoryIdentifier = CategoryIdentifier.of((String)"minecraft", (String)"plugins/crafting");
            for (CraftingRecipe craftingRecipe : recipes) {
                Collection displays = registry.tryFillDisplay((Object)craftingRecipe);
                for (Display display : displays) {
                    if (!Objects.equals(display.getCategoryIdentifier(), categoryIdentifier)) continue;
                    registry.add(display, (Object)craftingRecipe);
                }
            }
        }
    }
}

