/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.excavatedvariants.data;

import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonGrammar;
import blue.endless.jankson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.excavatedvariants.ExcavatedVariants;
import dev.lukebemish.excavatedvariants.codecs.JanksonOps;
import dev.lukebemish.excavatedvariants.data.ModConfig;
import dev.lukebemish.excavatedvariants.platform.Services;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public class MappingsCache {
    public static final Path FULL_PATH = Services.PLATFORM.getModDataFolder().resolve("mappings_cache.json5");
    public static final Codec<MappingsCache> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)ResourceLocation.f_135803_.listOf()).fieldOf("ore_mappings").forGetter(mc -> {
        HashMap out = new HashMap();
        mc.oreMappings.forEach((key, val) -> out.put(key, val.stream().toList()));
        return out;
    }), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)ResourceLocation.f_135803_).fieldOf("stone_mappings").forGetter(mc -> mc.stoneMappings)).apply((Applicative)instance, MappingsCache::new));
    public Map<String, Set<ResourceLocation>> oreMappings = new HashMap<String, Set<ResourceLocation>>();
    public Map<String, ResourceLocation> stoneMappings = new HashMap<String, ResourceLocation>();
    private static final JsonGrammar GRAMMAR = JsonGrammar.builder().withComments(true).printTrailingCommas(true).bareSpecialNumerics(true).printUnquotedKeys(true).build();

    private MappingsCache(Map<String, List<ResourceLocation>> ores, Map<String, ResourceLocation> stones) {
        ores.forEach((p, rls) -> this.oreMappings.put((String)p, Set.copyOf(rls)));
        this.stoneMappings.putAll(stones);
    }

    public static MappingsCache load() {
        try {
            if (!Files.exists(FULL_PATH, new LinkOption[0])) {
                throw new FileNotFoundException();
            }
            JsonObject json = ModConfig.JANKSON.load(Files.newInputStream(FULL_PATH, new OpenOption[0]));
            return (MappingsCache)CODEC.parse((DynamicOps)JanksonOps.INSTANCE, (Object)json).getOrThrow(false, e -> {});
        }
        catch (FileNotFoundException e2) {
            return new MappingsCache(new HashMap<String, List<ResourceLocation>>(), new HashMap<String, ResourceLocation>());
        }
        catch (Exception e3) {
            ExcavatedVariants.LOGGER.error("Issue loading mappings cache. Try deleting mod_data/excavated_variants/mappings_cache.json5. ", (Throwable)e3);
            throw new RuntimeException(e3);
        }
    }

    public void save() {
        try {
            if (!Files.exists(FULL_PATH.getParent(), new LinkOption[0])) {
                Files.createDirectories(FULL_PATH.getParent(), new FileAttribute[0]);
            }
            if (Files.exists(FULL_PATH, new LinkOption[0])) {
                Files.delete(FULL_PATH);
            }
            BufferedWriter writer = Files.newBufferedWriter(FULL_PATH, StandardOpenOption.CREATE_NEW);
            JsonElement json = (JsonElement)CODEC.encodeStart((DynamicOps)JanksonOps.INSTANCE, (Object)this).getOrThrow(false, e -> {});
            json.toJson((Writer)writer, GRAMMAR, 0);
            writer.flush();
            writer.close();
        }
        catch (Exception e2) {
            ExcavatedVariants.LOGGER.error("Issue saving mappings cache. Something has gone very wrong. ", (Throwable)e2);
            throw new RuntimeException(e2);
        }
    }
}

