/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.excavatedvariants.data;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.api.SyntaxError;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.io.IndentStyle;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.electronwill.nightconfig.toml.TomlParser;
import com.electronwill.nightconfig.toml.TomlWriter;
import com.google.common.base.Suppliers;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.defaultresources.api.ResourceProvider;
import dev.lukebemish.excavatedvariants.ExcavatedVariants;
import dev.lukebemish.excavatedvariants.codecs.CommentedCodec;
import dev.lukebemish.excavatedvariants.codecs.JanksonOps;
import dev.lukebemish.excavatedvariants.codecs.TomlConfigOps;
import dev.lukebemish.excavatedvariants.data.BaseOre;
import dev.lukebemish.excavatedvariants.data.BaseStone;
import dev.lukebemish.excavatedvariants.data.ConfigResource;
import dev.lukebemish.excavatedvariants.data.ModData;
import dev.lukebemish.excavatedvariants.data.filter.Filter;
import dev.lukebemish.excavatedvariants.data.modifier.Flag;
import dev.lukebemish.excavatedvariants.data.modifier.VariantModifier;
import dev.lukebemish.excavatedvariants.platform.Services;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;

public class ModConfig {
    public static final TomlParser TOML_PARSER = TomlFormat.instance().createParser();
    public static final TomlWriter TOML_WRITER = TomlFormat.instance().createWriter();
    public static final Jankson JANKSON = Jankson.builder().build();
    public static final Path CONFIG_PATH = Services.PLATFORM.getConfigFolder();
    public static final Path FULL_PATH = CONFIG_PATH.resolve("excavated_variants.toml");
    public static final Codec<ModConfig> CODEC = CommentedCodec.of(RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("attempt_worldgen_replacement").forGetter(c -> c.attemptWorldgenReplacement), (App)Codec.BOOL.fieldOf("add_conversion_recipes").forGetter(c -> c.addConversionRecipes), (App)Codec.BOOL.fieldOf("jei_rei_compat").forGetter(c -> c.jeiReiCompat)).apply((Applicative)instance, ModConfig::new))).comment("Toggles ore-gen changes; without this, ores won't be replaced during world gen.", "attempt_worldgen_replacement").comment("Toggles whether to add recipes to convert variants back to the base ore.", "add_conversion_recipes").comment("Toggles compatibility with JEI and REI for added conversion recipes.", "jei_rei_compat");
    public final boolean attemptWorldgenReplacement;
    public final boolean addConversionRecipes;
    public final boolean jeiReiCompat;
    public final ConfigResource configResource = ConfigResource.empty();
    public final List<ModData> mods = new ArrayList<ModData>();
    public final List<VariantModifier> modifiers = new ArrayList<VariantModifier>();
    public final Flags flags = new Flags();

    private ModConfig(boolean attemptWorldgenReplacement, boolean addConversionRecipes, boolean jeiReiCompat) {
        this.attemptWorldgenReplacement = attemptWorldgenReplacement;
        this.addConversionRecipes = addConversionRecipes;
        this.jeiReiCompat = jeiReiCompat;
    }

    private static ModConfig defaultConfig() {
        return new ModConfig(true, true, true);
    }

    public static ModConfig load() {
        try {
            ModConfig.checkExistenceOrSave();
            CommentedConfig toml = TOML_PARSER.parse((Reader)new FileReader(FULL_PATH.toFile()));
            ModConfig config = (ModConfig)CODEC.parse((DynamicOps)TomlConfigOps.INSTANCE, (Object)toml).getOrThrow(false, e -> {});
            config.loadConfigResources();
            config.loadVariantResources();
            config.loadVariantModifiers();
            return config;
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    private static void checkExistenceOrSave() throws IOException {
        ResourceProvider.forceInitialization();
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            Files.createDirectories(CONFIG_PATH, new FileAttribute[0]);
        }
        if (!Files.exists(FULL_PATH, new LinkOption[0])) {
            Files.createFile(FULL_PATH, new FileAttribute[0]);
            ModConfig config = ModConfig.defaultConfig();
            BufferedWriter writer = Files.newBufferedWriter(FULL_PATH, new OpenOption[0]);
            Config toml = (Config)CODEC.encodeStart((DynamicOps)TomlConfigOps.INSTANCE, (Object)config).getOrThrow(false, e -> {});
            TOML_WRITER.write(toml.unmodifiable(), (Writer)writer);
            writer.flush();
            writer.close();
        }
    }

    private void loadConfigResources() {
        Collection rls = ResourceProvider.instance().getResources("excavated_variants", "configs", rl -> true);
        for (ResourceLocation rl2 : rls) {
            Stream resources = ResourceProvider.instance().getResourceStreams("excavated_variants", rl2);
            try {
                Optional optional = resources.findFirst();
                if (!optional.isPresent()) continue;
                try {
                    ConfigResource resource;
                    if (rl2.m_135815_().endsWith(".json") || rl2.m_135815_().endsWith(".json5")) {
                        JsonObject json = JANKSON.load((InputStream)optional.get());
                        resource = (ConfigResource)ConfigResource.CODEC.parse((DynamicOps)JanksonOps.INSTANCE, (Object)json).getOrThrow(false, e -> {});
                        this.configResource.addFrom(resource);
                        continue;
                    }
                    if (!rl2.m_135815_().endsWith(".toml")) continue;
                    CommentedConfig toml = TOML_PARSER.parse((Reader)new InputStreamReader((InputStream)optional.get()));
                    resource = (ConfigResource)ConfigResource.CODEC.parse((DynamicOps)TomlConfigOps.INSTANCE, (Object)toml).getOrThrow(false, e -> {});
                    this.configResource.addFrom(resource);
                }
                catch (SyntaxError | IOException | RuntimeException e2) {
                    ExcavatedVariants.LOGGER.error("Issues loading resource: {}", (Object)rl2, (Object)e2);
                }
            }
            finally {
                if (resources == null) continue;
                resources.close();
            }
        }
    }

    private void loadVariantModifiers() {
        Collection rls = ResourceProvider.instance().getResources("excavated_variants", "modifiers", rl -> true);
        for (ResourceLocation rl2 : rls) {
            Stream resources = ResourceProvider.instance().getResourceStreams("excavated_variants", rl2);
            try {
                Optional optional = resources.findFirst();
                if (!optional.isPresent()) continue;
                try {
                    VariantModifier resource;
                    if (rl2.m_135815_().endsWith(".json") || rl2.m_135815_().endsWith(".json5")) {
                        JsonObject json = JANKSON.load((InputStream)optional.get());
                        resource = (VariantModifier)VariantModifier.CODEC.parse((DynamicOps)JanksonOps.INSTANCE, (Object)json).getOrThrow(false, e -> {});
                        this.modifiers.add(resource);
                        continue;
                    }
                    if (!rl2.m_135815_().endsWith(".toml")) continue;
                    CommentedConfig toml = TOML_PARSER.parse((Reader)new InputStreamReader((InputStream)optional.get()));
                    resource = (VariantModifier)VariantModifier.CODEC.parse((DynamicOps)TomlConfigOps.INSTANCE, (Object)toml).getOrThrow(false, e -> {});
                    this.modifiers.add(resource);
                }
                catch (SyntaxError | IOException | RuntimeException e2) {
                    ExcavatedVariants.LOGGER.error("Issues loading resource: {}", (Object)rl2, (Object)e2);
                }
            }
            finally {
                if (resources == null) continue;
                resources.close();
            }
        }
    }

    private void loadVariantResources() {
        HashMap<ResourceLocation, ModData> modMap = new HashMap<ResourceLocation, ModData>();
        Collection rls = ResourceProvider.instance().getResources("excavated_variants", "variants", rl -> true);
        for (ResourceLocation rl2 : rls) {
            Stream resources = ResourceProvider.instance().getResourceStreams("excavated_variants", rl2);
            try {
                Optional optional = resources.findFirst();
                if (!optional.isPresent()) continue;
                try {
                    ModData resource;
                    if (rl2.m_135815_().endsWith(".json") || rl2.m_135815_().endsWith(".json5")) {
                        JsonObject json = JANKSON.load((InputStream)optional.get());
                        resource = (ModData)ModData.CODEC.parse((DynamicOps)JanksonOps.INSTANCE, (Object)json).getOrThrow(false, e -> {});
                        modMap.put(rl2, resource);
                        continue;
                    }
                    if (!rl2.m_135815_().endsWith(".toml")) continue;
                    CommentedConfig toml = TOML_PARSER.parse((Reader)new InputStreamReader((InputStream)optional.get()));
                    resource = (ModData)ModData.CODEC.parse((DynamicOps)TomlConfigOps.INSTANCE, (Object)toml).getOrThrow(false, e -> {});
                    modMap.put(rl2, resource);
                }
                catch (SyntaxError | IOException | RuntimeException e2) {
                    ExcavatedVariants.LOGGER.error("Issues loading resource: {}", (Object)rl2, (Object)e2);
                }
            }
            finally {
                if (resources == null) continue;
                resources.close();
            }
        }
        for (ResourceLocation rl2 : this.configResource.priority) {
            ResourceLocation newRl = new ResourceLocation(rl2.m_135827_(), "variants/" + rl2.m_135815_());
            ModData data = (ModData)modMap.get(newRl);
            if (data == null) continue;
            this.mods.add(data);
            modMap.remove(newRl);
        }
        this.mods.addAll(modMap.values());
    }

    static {
        TOML_WRITER.setIndent(IndentStyle.SPACES_2);
    }

    public class Flags {
        final Supplier<List<Pair<Filter, List<Flag>>>> flags = Suppliers.memoize(() -> ModConfig.this.modifiers.stream().filter(m -> m.flags().isPresent()).map(m -> new Pair((Object)m.filter(), m.flags().get())).toList());

        private Flags() {
        }

        public Set<Flag> getFlags(String ore, String stone) {
            return (Set)this.flags.get().stream().filter(p -> ((Filter)p.getFirst()).matches(ore, stone)).flatMap(p -> ((List)p.getSecond()).stream()).collect(Sets.toImmutableEnumSet());
        }

        public Set<Flag> getFlags(BaseOre ore, BaseStone stone) {
            return this.getFlags(ore.id, stone.id);
        }
    }
}

