/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.excavatedvariants.data.filter;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.excavatedvariants.data.BaseOre;
import dev.lukebemish.excavatedvariants.data.BaseStone;
import dev.lukebemish.excavatedvariants.data.filter.Filter;
import java.util.List;
import java.util.function.Function;
import net.minecraft.util.ExtraCodecs;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ObjectFilter
extends Filter {
    public static final BiMap<String, Codec<? extends ObjectFilter>> FILTER_TYPES = new ImmutableBiMap.Builder().put((Object)"and", AndFilter.CODEC).put((Object)"or", OrFilter.CODEC).put((Object)"not", NotFilter.CODEC).put((Object)"empty", EmptyFilter.CODEC).put((Object)"all", AllFilter.CODEC).build();
    public static final Codec<ObjectFilter> CODEC = ExtraCodecs.m_184415_(() -> new Codec<Codec<? extends ObjectFilter>>(){

        public <T> DataResult<Pair<Codec<? extends ObjectFilter>, T>> decode(DynamicOps<T> ops, T input) {
            return Codec.STRING.decode(ops, input).flatMap(keyValuePair -> !FILTER_TYPES.containsKey(keyValuePair.getFirst()) ? DataResult.error((String)("Unknown filter type: " + (String)keyValuePair.getFirst())) : DataResult.success((Object)keyValuePair.mapFirst(arg_0 -> FILTER_TYPES.get(arg_0))));
        }

        public <T> DataResult<T> encode(Codec<? extends ObjectFilter> input, DynamicOps<T> ops, T prefix) {
            String key = (String)FILTER_TYPES.inverse().get(input);
            if (key == null) {
                return DataResult.error((String)("Unregistered filter type: " + input));
            }
            Object toMerge = ops.createString(key);
            return ops.mergeToPrimitive(prefix, toMerge);
        }
    }).dispatch(ObjectFilter::codec, Function.identity());

    public Codec<? extends ObjectFilter> codec();

    public record AndFilter(List<Filter> filters) implements ObjectFilter
    {
        public static final Codec<AndFilter> CODEC = RecordCodecBuilder.create(i -> i.group((App)Filter.CODEC.listOf().fieldOf("filters").forGetter(AndFilter::filters)).apply((Applicative)i, AndFilter::new));

        @Override
        public boolean matches(BaseOre ore, BaseStone stone) {
            return this.filters.stream().allMatch(f -> f.matches(ore, stone));
        }

        @Override
        public boolean matches(String ore, String stone) {
            return this.filters.stream().allMatch(f -> f.matches(ore, stone));
        }

        @Override
        public Codec<? extends ObjectFilter> codec() {
            return CODEC;
        }
    }

    public record OrFilter(List<Filter> filters) implements ObjectFilter
    {
        public static final Codec<OrFilter> CODEC = RecordCodecBuilder.create(i -> i.group((App)Filter.CODEC.listOf().fieldOf("filters").forGetter(OrFilter::filters)).apply((Applicative)i, OrFilter::new));

        @Override
        public boolean matches(BaseOre ore, BaseStone stone) {
            return this.filters.stream().anyMatch(f -> f.matches(ore, stone));
        }

        @Override
        public boolean matches(String ore, String stone) {
            return this.filters.stream().anyMatch(f -> f.matches(ore, stone));
        }

        @Override
        public Codec<? extends ObjectFilter> codec() {
            return CODEC;
        }
    }

    public record NotFilter(Filter filter) implements ObjectFilter
    {
        public static final Codec<NotFilter> CODEC = RecordCodecBuilder.create(i -> i.group((App)Filter.CODEC.fieldOf("filter").forGetter(NotFilter::filter)).apply((Applicative)i, NotFilter::new));

        @Override
        public boolean matches(BaseOre ore, BaseStone stone) {
            return !this.filter().matches(ore, stone);
        }

        @Override
        public boolean matches(String ore, String stone) {
            return !this.filter().matches(ore, stone);
        }

        @Override
        public Codec<? extends ObjectFilter> codec() {
            return CODEC;
        }
    }

    public static final class EmptyFilter
    implements ObjectFilter {
        public static final EmptyFilter INSTANCE = new EmptyFilter();
        public static final Codec<EmptyFilter> CODEC = Codec.unit((Object)INSTANCE);

        private EmptyFilter() {
        }

        @Override
        public boolean matches(String ore, String stone) {
            return false;
        }

        @Override
        public boolean matches(BaseOre ore, BaseStone stone) {
            return false;
        }

        @Override
        public Codec<? extends ObjectFilter> codec() {
            return CODEC;
        }
    }

    public static final class AllFilter
    implements ObjectFilter {
        public static final AllFilter INSTANCE = new AllFilter();
        public static final Codec<AllFilter> CODEC = Codec.unit((Object)INSTANCE);

        private AllFilter() {
        }

        @Override
        public boolean matches(BaseOre ore, BaseStone stone) {
            return true;
        }

        @Override
        public boolean matches(String ore, String stone) {
            return true;
        }

        @Override
        public Codec<? extends ObjectFilter> codec() {
            return CODEC;
        }
    }
}

