/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.excavatedvariants.forge;

import com.google.auto.service.AutoService;
import dev.lukebemish.excavatedvariants.IRegistryUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

@AutoService(value={IRegistryUtil.class})
public class RegistryUtilImpl
implements IRegistryUtil {
    public static Map<ResourceLocation, Block> blockCache = new ConcurrentHashMap<ResourceLocation, Block>();
    public static Map<Block, ResourceLocation> blockRlCache = new ConcurrentHashMap<Block, ResourceLocation>();
    public static Map<ResourceLocation, Item> itemCache = new ConcurrentHashMap<ResourceLocation, Item>();

    @Override
    public void reset() {
        blockCache.clear();
        blockRlCache.clear();
        itemCache.clear();
    }

    @Override
    public Block getBlockById(ResourceLocation rl) {
        if (blockCache.containsKey(rl)) {
            return blockCache.get(rl);
        }
        if (ForgeRegistries.BLOCKS.containsKey(rl)) {
            Block out = (Block)ForgeRegistries.BLOCKS.getValue(rl);
            blockCache.put(rl, out);
            return out;
        }
        return null;
    }

    @Override
    public Item getItemById(ResourceLocation rl) {
        if (itemCache.containsKey(rl)) {
            return itemCache.get(rl);
        }
        if (ForgeRegistries.ITEMS.containsKey(rl)) {
            Item out = (Item)ForgeRegistries.ITEMS.getValue(rl);
            itemCache.put(rl, out);
            return out;
        }
        return null;
    }

    @Override
    public ResourceLocation getRlByBlock(Block block) {
        if (blockRlCache.containsKey(block)) {
            return blockRlCache.get(block);
        }
        ResourceLocation rl = ForgeRegistries.BLOCKS.getKey((Object)block);
        blockRlCache.put(block, rl);
        return rl;
    }

    @Override
    public Iterable<Block> getAllBlocks() {
        return ForgeRegistries.BLOCKS.getValues();
    }
}

