/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.excavatedvariants.platform;

import dev.lukebemish.excavatedvariants.ICompat;
import dev.lukebemish.excavatedvariants.ICreativeTabLoader;
import dev.lukebemish.excavatedvariants.IMainPlatformTarget;
import dev.lukebemish.excavatedvariants.IPlatform;
import dev.lukebemish.excavatedvariants.IRegistryUtil;
import dev.lukebemish.excavatedvariants.util.ThreadsafeLazy;
import java.util.ServiceLoader;

public class Services {
    public static final IRegistryUtil REGISTRY_UTIL = Services.load(IRegistryUtil.class);
    public static final IPlatform PLATFORM = Services.load(IPlatform.class);
    public static final ThreadsafeLazy<ICreativeTabLoader> CREATIVE_TAB_LOADER = Services.loadLazy(ICreativeTabLoader.class);
    public static final ThreadsafeLazy<IMainPlatformTarget> MAIN_PLATFORM_TARGET = Services.loadLazy(IMainPlatformTarget.class);
    public static final ICompat COMPAT = Services.load(ICompat.class);

    public static <T> T load(Class<T> clazz) {
        return ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
    }

    public static <T> ThreadsafeLazy<T> loadLazy(Class<T> clazz) {
        return new ThreadsafeLazy<Object>(() -> Services.load(clazz));
    }
}

