/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.excavatedvariants.worldgen;

import com.mojang.datafixers.util.Pair;
import dev.lukebemish.excavatedvariants.ExcavatedVariants;
import dev.lukebemish.excavatedvariants.ModifiedOreBlock;
import dev.lukebemish.excavatedvariants.data.BaseOre;
import dev.lukebemish.excavatedvariants.data.BaseStone;
import dev.lukebemish.excavatedvariants.platform.Services;
import dev.lukebemish.excavatedvariants.worldgen.IOreFound;
import dev.lukebemish.excavatedvariants.worldgen.OreGenMapSavedData;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.jetbrains.annotations.Nullable;

public class OreReplacer
extends Feature<NoneFeatureConfiguration> {
    private static final int[] xs = new int[]{-1, 0, 1, 1, -1, -1, 0, 1};
    private static final int[] zs = new int[]{-1, -1, -1, 0, 0, 1, 1, 1};
    private static final int[] as = new int[]{1, 0, 0, -1, 0, 0};
    private static final int[] bs = new int[]{0, -1, 1, 0, 0, 0};
    private static final int[] ys = new int[]{0, 0, 0, 0, -1, 1};

    public OreReplacer() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        if (!ExcavatedVariants.getConfig().attemptWorldgenReplacement) {
            return true;
        }
        return this.modifyUnmodifiedNeighboringChunks(ctx.m_159774_(), ctx.m_159777_());
    }

    public boolean modifyUnmodifiedNeighboringChunks(WorldGenLevel level, BlockPos pos) {
        OreGenMapSavedData data = OreGenMapSavedData.getOrCreate((ServerLevelAccessor)level);
        int minY = level.m_141937_();
        int maxY = level.m_151558_();
        if (data.edgeCount.containsKey(new Pair((Object)pos.m_123341_(), (Object)pos.m_123343_())) && data.edgeCount.get(new Pair((Object)pos.m_123341_(), (Object)pos.m_123343_())) == 8) {
            ChunkAccess chunkAccess = level.m_46865_(pos);
            this.modifyChunk(chunkAccess, minY, maxY);
            data.edgeCount.put((Pair<Integer, Integer>)new Pair((Object)pos.m_123341_(), (Object)pos.m_123343_()), 9);
        }
        BlockPos.MutableBlockPos newPos = new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        for (int i = 0; i < xs.length; ++i) {
            newPos.m_142451_(pos.m_123341_() + xs[i] * 16);
            newPos.m_142443_(pos.m_123343_() + zs[i] * 16);
            Pair chunkPos = new Pair((Object)newPos.m_123341_(), (Object)newPos.m_123343_());
            if (!data.edgeCount.containsKey(chunkPos)) {
                data.edgeCount.put((Pair<Integer, Integer>)chunkPos, 0);
            }
            data.edgeCount.put((Pair<Integer, Integer>)chunkPos, data.edgeCount.get(chunkPos) + 1);
            if (data.edgeCount.get(chunkPos) != 8 || !data.ranMap.containsKey(chunkPos) || !data.ranMap.get(chunkPos).booleanValue()) continue;
            ChunkAccess chunkAccess = level.m_46865_((BlockPos)newPos);
            this.modifyChunk(chunkAccess, minY, maxY);
            data.edgeCount.put((Pair<Integer, Integer>)chunkPos, 9);
        }
        data.ranMap.put((Pair<Integer, Integer>)new Pair((Object)pos.m_123341_(), (Object)pos.m_123343_()), true);
        return true;
    }

    public boolean modifyChunk(ChunkAccess chunkAccess, int minY, int maxY) {
        LevelChunkSection chunkSection = chunkAccess.m_183278_(chunkAccess.m_151564_(minY));
        for (int y = minY; y < maxY; ++y) {
            BlockState[][][] cache = new BlockState[16][16][16];
            int sectionIndex = chunkAccess.m_151564_(y);
            if (chunkAccess.m_151564_(chunkSection.m_63017_()) != sectionIndex) {
                chunkSection = chunkAccess.m_183278_(sectionIndex);
            }
            if (chunkSection.m_188008_()) continue;
            for (int i = 0; i < 16; ++i) {
                block2: for (int j = 0; j < 16; ++j) {
                    BlockState newState = cache[i][y & 0xF][j] == null ? chunkSection.m_62982_(i, y & 0xF, j) : cache[i][y & 0xF][j];
                    @Nullable Pair<BaseOre, HashSet<BaseStone>> pair = ((IOreFound)newState.m_60734_()).excavated_variants$getPair();
                    if (cache[i][y & 0xF][j] == null) {
                        cache[i][y & 0xF][j] = newState;
                    }
                    if (pair == null) continue;
                    for (int c = 0; c < as.length; ++c) {
                        BaseStone stone;
                        if (i + as[c] >= 16 || i + as[c] < 0 || j + bs[c] >= 16 || j + bs[c] < 0 || y + ys[c] < chunkSection.m_63017_() || y + ys[c] >= chunkSection.m_63017_() + 16) continue;
                        BlockState thisState = cache[i + as[c]][y + ys[c] & 0xF][j + bs[c]];
                        if (thisState == null) {
                            cache[i + OreReplacer.as[c]][y + OreReplacer.ys[c] & 0xF][j + OreReplacer.bs[c]] = thisState = chunkSection.m_62982_(i + as[c], y + ys[c] & 0xF, j + bs[c]);
                        }
                        if ((stone = ((IOreFound)thisState.m_60734_()).excavated_variants$getStone()) == null) continue;
                        Block oreBlock = Services.REGISTRY_UTIL.getBlockById(new ResourceLocation("excavated_variants", stone.id + "_" + ((BaseOre)pair.getFirst()).id));
                        if (!((HashSet)pair.getSecond()).contains(stone) || !(oreBlock instanceof ModifiedOreBlock)) continue;
                        ModifiedOreBlock modifiedOreBlock = (ModifiedOreBlock)oreBlock;
                        BlockState def = modifiedOreBlock.m_152465_(thisState);
                        chunkSection.m_62991_(i, y & 0xF, j, def, false);
                        continue block2;
                    }
                }
            }
        }
        return true;
    }
}

