/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.excavated_variants;

import io.github.lukebemish.excavated_variants.ExcavatedVariants;
import io.github.lukebemish.excavated_variants.data.BaseOre;
import io.github.lukebemish.excavated_variants.data.BaseStone;
import io.github.lukebemish.excavated_variants.mixin.IBlockPropertiesMixin;
import io.github.lukebemish.excavated_variants.platform.Services;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.OreBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class ModifiedOreBlock
extends OreBlock {
    public final BaseOre ore;
    public final BaseStone stone;
    protected Block target;
    protected Block stoneTarget;
    static Property<?>[] staticProps;
    private boolean isLit = false;
    private boolean isHorizontalFacing = false;
    private boolean isFacing = false;
    private boolean isHopperFacing = false;
    private boolean isAxis = false;
    private boolean isHorizontalAxis = false;
    private Property<?>[] props;

    public ModifiedOreBlock(BaseOre ore, BaseStone stone) {
        super(ModifiedOreBlock.copyProperties(ore, stone));
        this.ore = ore;
        this.stone = stone;
        if (staticProps != null) {
            this.props = (Property[])staticProps.clone();
            staticProps = null;
            this.copyBlockstateDefs();
        }
    }

    private static float avgF(float a, float b) {
        return (a + b) / 2.0f;
    }

    private static MaterialColor avgColor(MaterialColor a, MaterialColor b, float weight) {
        int avgColor = (int)((float)a.m_192921_(MaterialColor.Brightness.HIGH) * weight + (float)b.m_192921_(MaterialColor.Brightness.HIGH) * (1.0f - weight));
        int lowest = 0;
        int lowDiff = 0xFFFFFF;
        for (int i = 0; i < 64; ++i) {
            MaterialColor c = MaterialColor.m_192919_((int)i);
            int diff = Math.abs(c.m_192921_(MaterialColor.Brightness.HIGH) - avgColor);
            if (diff >= lowDiff) continue;
            lowDiff = diff;
            lowest = i;
        }
        return MaterialColor.m_192919_((int)lowest);
    }

    private static BlockBehaviour.Properties copyProperties(BaseOre ore, BaseStone stone) {
        Block target = Services.REGISTRY_UTIL.getBlockById(ore.block_id.get(0));
        Block stoneTarget = Services.REGISTRY_UTIL.getBlockById(stone.block_id);
        if (target != null && stoneTarget != null) {
            BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_60926_((BlockBehaviour)stoneTarget);
            BlockBehaviour.Properties oreProperties = BlockBehaviour.Properties.m_60926_((BlockBehaviour)target);
            properties.m_60999_();
            IBlockPropertiesMixin newProperties = (IBlockPropertiesMixin)properties;
            IBlockPropertiesMixin oreProps = (IBlockPropertiesMixin)oreProperties;
            properties.m_60913_(ModifiedOreBlock.avgF(target.m_155943_(), stoneTarget.m_155943_()), ModifiedOreBlock.avgF(target.m_7325_(), stoneTarget.m_7325_())).m_155949_(ModifiedOreBlock.avgColor(stoneTarget.m_60590_(), target.m_60590_(), 0.8f));
            newProperties.setDynamicShape(false);
            newProperties.setHasCollision(true);
            newProperties.setIsRandomlyTicking(oreProps.getIsRandomlyTicking());
            newProperties.setLightEmission(oreProps.getLightEmission());
            return properties;
        }
        return BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60999_().m_60913_(3.0f, 3.0f);
    }

    public static void setupStaticWrapper(BaseOre ore, BaseStone stone) {
        Block target = Services.REGISTRY_UTIL.getBlockById(ore.block_id.get(0));
        Block stoneTarget = Services.REGISTRY_UTIL.getBlockById(stone.block_id);
        if (target != null && stoneTarget != null) {
            ArrayList<Property> propBuilder = new ArrayList<Property>();
            for (Property p : target.m_49966_().m_61147_()) {
                if (p != BlockStateProperties.f_61443_) continue;
                propBuilder.add(p);
            }
            for (Property p : stoneTarget.m_49966_().m_61147_()) {
                if (p != BlockStateProperties.f_61365_ && p != BlockStateProperties.f_61364_ && p != BlockStateProperties.f_61372_ && p != BlockStateProperties.f_61373_ && p != BlockStateProperties.f_61374_) continue;
                propBuilder.add(p);
            }
            staticProps = propBuilder.toArray(new Property[0]);
        } else {
            ExcavatedVariants.LOGGER.warn("Could not find block properties for: {}, {}", (Object)ore.block_id.get(0), (Object)stone.block_id);
        }
    }

    public void copyBlockstateDefs() {
        if (this.target == null || this.stoneTarget == null) {
            this.target = Services.REGISTRY_UTIL.getBlockById(this.ore.block_id.get(0));
            this.stoneTarget = Services.REGISTRY_UTIL.getBlockById(this.stone.block_id);
        }
        if (this.target != null && this.stoneTarget != null) {
            BlockState bs = this.m_49966_();
            for (Property<?> p : this.props) {
                if (p == BlockStateProperties.f_61443_) {
                    this.isLit = true;
                    bs = (BlockState)bs.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false));
                }
                if (p == BlockStateProperties.f_61372_) {
                    this.isFacing = true;
                    bs = (BlockState)bs.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.NORTH);
                }
                if (p == BlockStateProperties.f_61373_) {
                    this.isHopperFacing = true;
                    bs = (BlockState)bs.m_61124_((Property)BlockStateProperties.f_61373_, (Comparable)Direction.NORTH);
                }
                if (p == BlockStateProperties.f_61374_) {
                    this.isHorizontalFacing = true;
                    bs = (BlockState)bs.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH);
                }
                if (p == BlockStateProperties.f_61365_) {
                    this.isAxis = true;
                    bs = (BlockState)bs.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.Y);
                }
                if (p != BlockStateProperties.f_61364_) continue;
                this.isHorizontalAxis = true;
                bs = (BlockState)bs.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.Y);
            }
            this.m_49959_(bs);
        }
    }

    public boolean isLit() {
        return this.isLit;
    }

    public boolean m_6724_(BlockState state) {
        if (this.isLit) {
            return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_);
        }
        return super.m_6724_(state);
    }

    public void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        this.interact(state, level, pos);
        super.m_6256_(state, level, pos, player);
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        this.interact(state, level, pos);
        super.m_141947_(level, pos, state, entity);
    }

    private void interact(BlockState state, Level level, BlockPos pos) {
        if (this.isLit && !((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_) {
            this.interact(state, level, pos);
        }
        if (this.isLit) {
            ItemStack itemStack = player.m_21120_(hand);
            return itemStack.m_41720_() instanceof BlockItem && new BlockPlaceContext(player, hand, itemStack, hit).m_7059_() ? InteractionResult.PASS : InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        if (this.isLit && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)), 3);
        }
        super.m_7455_(state, level, pos, random);
    }

    public float m_155943_() {
        if (this.target != null) {
            return this.target.m_155943_();
        }
        return super.m_155943_();
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random random) {
        if (this.target != null) {
            this.target.m_7100_(state, level, pos, random);
        }
        if (this.stoneTarget != null) {
            this.stoneTarget.m_7100_(state, level, pos, random);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        if (this.props != null) {
            if (this.props.length != 0) {
                builder.m_61104_(this.props);
            }
        } else if (staticProps != null && staticProps.length != 0) {
            builder.m_61104_(staticProps);
        }
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        if (this.target != null) {
            state = this.target.m_49966_();
            List items = this.target.m_7381_(state, builder);
            return items.stream().map(x -> {
                if (x.m_150930_(this.target.m_5456_()) && this.m_5456_() != Items.f_41852_ && !ExcavatedVariants.getConfig().unobtainable_variants) {
                    int count = x.m_41613_();
                    ItemStack out = new ItemStack((ItemLike)this.m_5456_(), count);
                    return out;
                }
                return x;
            }).toList();
        }
        return new ArrayList<ItemStack>();
    }

    public void m_8101_(BlockState state, ServerLevel level, BlockPos pos, ItemStack stack) {
        Block target = this.target;
        if (target != null) {
            target.m_8101_(state, level, pos, stack);
        } else {
            super.m_8101_(state, level, pos, stack);
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState def = this.m_49966_();
        if (this.isAxis) {
            def = (BlockState)def.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)context.m_43719_().m_122434_());
        } else if (this.isHorizontalAxis) {
            def = (BlockState)def.m_61124_((Property)BlockStateProperties.f_61364_, (Comparable)context.m_8125_().m_122434_());
        } else if (this.isFacing) {
            def = (BlockState)def.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)context.m_43719_().m_122424_());
        } else if (this.isHopperFacing) {
            Direction d = context.m_43719_().m_122424_();
            def = (BlockState)def.m_61124_((Property)BlockStateProperties.f_61373_, (Comparable)(d.m_122434_() == Direction.Axis.Y ? Direction.DOWN : d));
        } else if (this.isHorizontalFacing) {
            def = (BlockState)def.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_());
        }
        return def;
    }

    public boolean isAxisType() {
        return this.isAxis || this.isHorizontalAxis;
    }

    public boolean isFacingType() {
        return this.isFacing || this.isHorizontalFacing || this.isHopperFacing;
    }

    public BlockState getStateForReplacement(BlockState thisState) {
        if (this.isFacing && thisState.m_61138_((Property)BlockStateProperties.f_61372_)) {
            return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)((Direction)thisState.m_61143_((Property)BlockStateProperties.f_61372_)));
        }
        if (this.isHorizontalFacing && thisState.m_61138_((Property)BlockStateProperties.f_61374_)) {
            return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)thisState.m_61143_((Property)BlockStateProperties.f_61374_)));
        }
        if (this.isHopperFacing && thisState.m_61138_((Property)BlockStateProperties.f_61373_)) {
            return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61373_, (Comparable)((Direction)thisState.m_61143_((Property)BlockStateProperties.f_61373_)));
        }
        if (this.isAxis && thisState.m_61138_((Property)BlockStateProperties.f_61365_)) {
            return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)((Direction.Axis)thisState.m_61143_((Property)BlockStateProperties.f_61365_)));
        }
        if (this.isHorizontalAxis && thisState.m_61138_((Property)BlockStateProperties.f_61364_)) {
            return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61364_, (Comparable)((Direction.Axis)thisState.m_61143_((Property)BlockStateProperties.f_61364_)));
        }
        return this.m_49966_();
    }
}

