/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.excavated_variants.client;

import io.github.lukebemish.dynamic_asset_generator.client.api.ClientPrePackRepository;
import io.github.lukebemish.excavated_variants.ExcavatedVariants;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.resources.ResourceLocation;

public class BackupFetcher {
    public static InputStream provideBlockstateFile(ResourceLocation oreRl) {
        InputStream out;
        ExcavatedVariants.LOGGER.info("Attempting to provide backup blockstate for {}", (Object)oreRl);
        try {
            ResourceLocation testBS = new ResourceLocation(oreRl.m_135827_(), "excavated_variants_backups/blockstates" + oreRl.m_135815_() + ".json");
            out = ClientPrePackRepository.getResource((ResourceLocation)testBS);
        }
        catch (IOException e) {
            ExcavatedVariants.LOGGER.info("Could not get backup blockstate for {}; wildly guessing at model location.", (Object)oreRl);
            String blockstate = "{\"variants\":{\"\":{\"model\":\"" + oreRl.m_135827_() + ":block/" + oreRl.m_135815_() + "\"}}}";
            out = new ByteArrayInputStream(blockstate.getBytes());
        }
        return out;
    }

    public static InputStream provideBlockModelFile(ResourceLocation oreRl) {
        InputStream out;
        ExcavatedVariants.LOGGER.info("Attempting to provide backup block model for {}", (Object)oreRl);
        try {
            ResourceLocation testBS = new ResourceLocation(oreRl.m_135827_(), "excavated_variants_backups/models/block" + oreRl.m_135815_() + ".json");
            out = ClientPrePackRepository.getResource((ResourceLocation)testBS);
        }
        catch (IOException e) {
            ExcavatedVariants.LOGGER.info("Could not get backup block model for {}; wildly guessing at texture location.", (Object)oreRl);
            String model = "{\"parent\":\"block/cube_all\",\"textures\":{\"all\":\"" + oreRl.m_135827_() + ":" + oreRl.m_135815_() + "\"}}";
            out = new ByteArrayInputStream(model.getBytes());
        }
        return out;
    }
}

