/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.excavated_variants.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.NativeImage;
import io.github.lukebemish.dynamic_asset_generator.client.api.ClientPrePackRepository;
import io.github.lukebemish.dynamic_asset_generator.client.api.DynAssetGeneratorClientAPI;
import io.github.lukebemish.dynamic_asset_generator.client.api.ForegroundTransferType;
import io.github.lukebemish.dynamic_asset_generator.client.api.PaletteExtractor;
import io.github.lukebemish.excavated_variants.ExcavatedVariants;
import io.github.lukebemish.excavated_variants.ModifiedOreBlock;
import io.github.lukebemish.excavated_variants.client.BackupFetcher;
import io.github.lukebemish.excavated_variants.client.BlockModelParser;
import io.github.lukebemish.excavated_variants.client.BlockstateModelParser;
import io.github.lukebemish.excavated_variants.client.ResettingHolder;
import io.github.lukebemish.excavated_variants.data.BaseOre;
import io.github.lukebemish.excavated_variants.data.BaseStone;
import io.github.lukebemish.excavated_variants.util.Pair;
import io.github.lukebemish.excavated_variants.util.Triple;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.renderer.block.model.BlockModelDefinition;
import net.minecraft.client.renderer.block.model.MultiVariant;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.resources.ResourceLocation;

public class BlockStateAssembler {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().create();
    private static volatile Map<ResourceLocation, Supplier<InputStream>> intMap;
    private static Collection<Pair<BaseOre, BaseStone>> int_original_pairs;
    private static List<Pair<BaseOre, BaseStone>> int_to_make;

    public static void setupClientAssets(Collection<Pair<BaseOre, BaseStone>> original_pairs, List<Pair<BaseOre, BaseStone>> to_make) {
        int_original_pairs = original_pairs;
        int_to_make = to_make;
        for (Pair<BaseOre, BaseStone> p : to_make) {
            String full_id = p.last().id + "_" + p.first().id;
            int max_tex_num = p.first().texture_count * p.last().texture_count;
            ArrayList<ResourceLocation> targets = new ArrayList<ResourceLocation>(List.of(new ResourceLocation("excavated_variants", "blockstates/" + full_id + ".json")));
            for (int i = 0; i < max_tex_num; ++i) {
                targets.add(new ResourceLocation("excavated_variants", "models/block/" + full_id + i + ".json"));
                targets.add(new ResourceLocation("excavated_variants", "textures/block/" + full_id + i + ".png"));
            }
            for (ResourceLocation rl : targets) {
                DynAssetGeneratorClientAPI.planLoadingStream((ResourceLocation)rl, (Supplier)((Object)new ResettingHolder(rl)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<ResourceLocation, Supplier<InputStream>> updateMap() {
        if (intMap != null) return intMap;
        Class<BlockStateAssembler> clazz = BlockStateAssembler.class;
        synchronized (BlockStateAssembler.class) {
            if (intMap != null) return intMap;
            intMap = BlockStateAssembler.getMap(int_original_pairs, int_to_make);
            // ** MonitorExit[var0] (shouldn't be in output)
            return intMap;
        }
    }

    public static void reset() {
        intMap = null;
    }

    private static Map<ResourceLocation, Supplier<InputStream>> getMap(Collection<Pair<BaseOre, BaseStone>> original_pairs, List<Pair<BaseOre, BaseStone>> to_make) {
        ResourceLocation stoneRl;
        ResourceLocation oreRl;
        BaseOre ore;
        BlockModelDefinition.Context ctx = new BlockModelDefinition.Context();
        HashMap<ResourceLocation, Supplier<InputStream>> resources = new HashMap<ResourceLocation, Supplier<InputStream>>();
        HashMap<String, Pair<BlockModelDefinition, List<ResourceLocation>>> oreInfoMap = new HashMap<String, Pair<BlockModelDefinition, List<ResourceLocation>>>();
        HashMap<String, Pair<BlockModelDefinition, List<ResourceLocation>>> stoneInfoMap = new HashMap<String, Pair<BlockModelDefinition, List<ResourceLocation>>>();
        HashMap extractorMap = new HashMap();
        for (Pair<BaseOre, BaseStone> p : to_make) {
            ore = p.first();
            BaseStone stone = p.last();
            try {
                if (!oreInfoMap.containsKey(ore.id)) {
                    oreRl = ore.block_id.get(0);
                    oreInfoMap.put(ore.id, BlockStateAssembler.getInfoFromBlockstate(oreRl, ctx));
                }
                if (stoneInfoMap.containsKey(stone.id)) continue;
                stoneRl = stone.block_id;
                stoneInfoMap.put(stone.id, BlockStateAssembler.getInfoFromBlockstate(stoneRl, ctx));
            }
            catch (IOException e) {
                ExcavatedVariants.LOGGER.info((Object)e);
            }
        }
        for (Pair<BaseOre, BaseStone> p : original_pairs) {
            ore = p.first();
            BaseStone base = p.last();
            try {
                if (!oreInfoMap.containsKey(ore.id)) {
                    oreRl = ore.block_id.get(0);
                    oreInfoMap.put(ore.id, BlockStateAssembler.getInfoFromBlockstate(oreRl, ctx));
                }
                if (!stoneInfoMap.containsKey(base.id)) {
                    stoneRl = base.block_id;
                    stoneInfoMap.put(base.id, BlockStateAssembler.getInfoFromBlockstate(stoneRl, ctx));
                }
                Pair stoneInfo = (Pair)stoneInfoMap.get(base.id);
                Pair oreInfo = (Pair)oreInfoMap.get(ore.id);
                if (stoneInfo != null && oreInfo != null && ((List)stoneInfo.last()).size() >= 1 && ((List)oreInfo.last()).size() >= 1) {
                    ArrayList<Triple<Object, ResourceLocation, Boolean>> extractors = new ArrayList<Triple<Object, ResourceLocation, Boolean>>();
                    extractorMap.put(ore.id, extractors);
                    for (ResourceLocation rl : (List)oreInfo.last()) {
                        InputStream is = ClientPrePackRepository.getResource((ResourceLocation)rl);
                        NativeImage img = NativeImage.m_85058_((InputStream)is);
                        boolean isTransparent = false;
                        block18: for (int x2 = 0; x2 < img.m_84982_(); ++x2) {
                            for (int y = 0; y < img.m_85084_(); ++y) {
                                int c = img.m_84985_(x2, y);
                                float alpha = (float)(c >> 24 & 0xFF) / 255.0f;
                                if (!(alpha < 0.5f)) continue;
                                isTransparent = true;
                                break block18;
                            }
                        }
                        PaletteExtractor extractor = isTransparent ? null : new PaletteExtractor((ResourceLocation)((List)stoneInfo.last()).get(0), rl, 6, true, true, 0.2).fillHoles(true);
                        extractors.add(new Triple<Object, ResourceLocation, Boolean>(extractor, rl, !isTransparent));
                    }
                    continue;
                }
                ExcavatedVariants.LOGGER.warn("Bad info while extracting from blocks {} and {}:{}", (Object)ore.block_id.get(0).toString(), (Object)base.block_id.toString(), (Object)((stoneInfo == null ? "\nMissing stone block model info" : "") + (oreInfo == null ? "\nMissing ore block model info" : "") + (stoneInfo != null && ((List)stoneInfo.last()).size() < 1 ? "\nNo stone textures found" : "") + (oreInfo != null && ((List)oreInfo.last()).size() < 1 ? "\nNo ore textures found" : "")));
            }
            catch (IOException e) {
                ExcavatedVariants.LOGGER.info((Object)e);
            }
            catch (JsonSyntaxException e) {
                ExcavatedVariants.LOGGER.error((Object)e);
            }
        }
        for (Pair<BaseOre, BaseStone> p : to_make) {
            Pair oreInfo = (Pair)oreInfoMap.get(p.first().id);
            Pair stoneInfo = (Pair)stoneInfoMap.get(p.last().id);
            ArrayList extractorPair = (ArrayList)extractorMap.get(p.first().id);
            BaseStone stone = p.last();
            BaseOre ore2 = p.first();
            String full_id = stone.id + "_" + ore2.id;
            ModifiedOreBlock outBlock = ExcavatedVariants.getBlocks().get(full_id);
            if (oreInfo != null && stoneInfo != null && extractorPair != null && outBlock != null) {
                Object stoneBG22;
                HashMap<Pair<Object, ResourceLocation>, ResourceLocation> texMap = new HashMap<Pair<Object, ResourceLocation>, ResourceLocation>();
                int index = 0;
                for (Object stoneBG22 : (List)stoneInfo.last()) {
                    for (Triple exp : extractorPair) {
                        if (((Boolean)exp.last()).booleanValue()) {
                            ForegroundTransferType plan = new ForegroundTransferType((PaletteExtractor)exp.first(), (ResourceLocation)stoneBG22, true, false);
                            ResourceLocation outRL = new ResourceLocation("excavated_variants", "textures/block/" + full_id + index + ".png");
                            ++index;
                            resources.put(outRL, (Supplier<InputStream>)plan.getStream(outRL));
                            texMap.put(new Pair<Object, ResourceLocation>(stoneBG22, (ResourceLocation)exp.second()), outRL);
                            continue;
                        }
                        texMap.put(new Pair<Object, ResourceLocation>(stoneBG22, (ResourceLocation)exp.second()), (ResourceLocation)exp.second());
                    }
                }
                HashMap<Pair<ResourceLocation, ResourceLocation>, ResourceLocation> newTexMap = new HashMap<Pair<ResourceLocation, ResourceLocation>, ResourceLocation>();
                stoneBG22 = texMap.keySet().iterator();
                while (stoneBG22.hasNext()) {
                    Pair pair = (Pair)stoneBG22.next();
                    String p1 = ((ResourceLocation)pair.first()).m_135815_().substring(9);
                    p1 = p1.substring(0, p1.length() - 4);
                    ResourceLocation rl1 = new ResourceLocation(((ResourceLocation)pair.first()).m_135827_(), p1);
                    p1 = ((ResourceLocation)pair.last()).m_135815_().substring(9);
                    p1 = p1.substring(0, p1.length() - 4);
                    ResourceLocation rl2 = new ResourceLocation(((ResourceLocation)pair.last()).m_135827_(), p1);
                    p1 = ((ResourceLocation)texMap.get(pair)).m_135815_().substring(9);
                    p1 = p1.substring(0, p1.length() - 4);
                    ResourceLocation rl3 = new ResourceLocation(((ResourceLocation)texMap.get(pair)).m_135827_(), p1);
                    newTexMap.put(new Pair<ResourceLocation, ResourceLocation>(rl1, rl2), rl3);
                }
                List<ResourceLocation> defaultModels = ((MultiVariant)((BlockModelDefinition)oreInfo.first()).m_173427_().stream().findFirst().get()).m_111848_().stream().map(Variant::m_111883_).toList();
                ResourceLocation stoneModel = ((MultiVariant)((BlockModelDefinition)stoneInfo.first()).m_173427_().stream().findFirst().get()).m_111848_().stream().map(Variant::m_111883_).findFirst().get();
                ArrayList<ResourceLocation> outModelRLs = new ArrayList<ResourceLocation>();
                try {
                    InputStream read;
                    try {
                        read = ClientPrePackRepository.getResource((ResourceLocation)new ResourceLocation(stoneModel.m_135827_(), "models/" + stoneModel.m_135815_() + ".json"));
                    }
                    catch (IOException e) {
                        read = BackupFetcher.provideBlockModelFile(stoneModel);
                    }
                    BlockModelParser parentModel = (BlockModelParser)GSON.fromJson((Reader)new BufferedReader(new InputStreamReader(read, StandardCharsets.UTF_8)), BlockModelParser.class);
                    List<ResourceLocation> stoneLocs = parentModel.textures.values().stream().map(x -> ResourceLocation.m_135822_((String)x, (char)':')).toList();
                    int i2 = 0;
                    for (ResourceLocation m : defaultModels) {
                        InputStream oreRead;
                        InputStream stoneRead;
                        try {
                            stoneRead = ClientPrePackRepository.getResource((ResourceLocation)new ResourceLocation(stoneModel.m_135827_(), "models/" + stoneModel.m_135815_() + ".json"));
                        }
                        catch (IOException e) {
                            stoneRead = BackupFetcher.provideBlockModelFile(stoneModel);
                        }
                        BlockModelParser outputModel = (BlockModelParser)GSON.fromJson((Reader)new BufferedReader(new InputStreamReader(stoneRead, StandardCharsets.UTF_8)), BlockModelParser.class);
                        try {
                            stoneRead = ClientPrePackRepository.getResource((ResourceLocation)new ResourceLocation(stoneModel.m_135827_(), "models/" + stoneModel.m_135815_() + ".json"));
                        }
                        catch (IOException e) {
                            stoneRead = BackupFetcher.provideBlockModelFile(stoneModel);
                        }
                        JsonObject outputMap = (JsonObject)GSON.fromJson((Reader)new BufferedReader(new InputStreamReader(stoneRead, StandardCharsets.UTF_8)), JsonObject.class);
                        try {
                            oreRead = ClientPrePackRepository.getResource((ResourceLocation)new ResourceLocation(m.m_135827_(), "models/" + m.m_135815_() + ".json"));
                        }
                        catch (IOException e) {
                            oreRead = BackupFetcher.provideBlockModelFile(m);
                        }
                        StringBuilder oreTextBuilder = new StringBuilder();
                        BufferedReader oreReader = new BufferedReader(new InputStreamReader(oreRead, Charset.forName(StandardCharsets.UTF_8.name())));
                        int oreC = 0;
                        while ((oreC = ((Reader)oreReader).read()) != -1) {
                            oreTextBuilder.append((char)oreC);
                        }
                        BlockModelParser oreModel = (BlockModelParser)GSON.fromJson(oreTextBuilder.toString(), BlockModelParser.class);
                        String maybeTex = oreModel.textures.values().stream().filter(x -> !stoneLocs.contains(ResourceLocation.m_135822_((String)x, (char)':')) && newTexMap.keySet().stream().anyMatch(y -> {
                            ResourceLocation rl = ResourceLocation.m_135822_((String)x, (char)':');
                            return ((ResourceLocation)y.last()).equals((Object)rl);
                        })).findFirst().orElse(null);
                        ResourceLocation mainOreTex = maybeTex == null ? null : ResourceLocation.m_135822_((String)maybeTex, (char)':');
                        List<String> overlayTextures = oreModel.textures.values().stream().filter(x -> newTexMap.entrySet().stream().anyMatch(e -> {
                            Pair y = (Pair)e.getKey();
                            ResourceLocation rl = ResourceLocation.m_135822_((String)x, (char)':');
                            return ((ResourceLocation)y.last()).equals((Object)rl) && ((ResourceLocation)y.last()).equals(e.getValue());
                        })).toList();
                        for (String string : outputModel.textures.keySet()) {
                            String val = outputModel.textures.get(string);
                            ResourceLocation old = ResourceLocation.m_135822_((String)val, (char)':');
                            ResourceLocation lookup = (ResourceLocation)newTexMap.get(new Pair<ResourceLocation, ResourceLocation>(old, mainOreTex));
                            if (lookup == null) continue;
                            outputModel.replaceTexture(old, lookup);
                        }
                        int i = 0;
                        for (String s3 : overlayTextures) {
                            ResourceLocation rl = ResourceLocation.m_135822_((String)s3, (char)':');
                            outputModel.addOverlay(i, rl);
                            ++i;
                        }
                        outputMap.add("textures", GSON.toJsonTree(outputModel.textures));
                        if (outputModel.elements != null && outputModel.elements.size() != 0) {
                            outputMap.add("elements", (JsonElement)outputModel.elements);
                        }
                        ResourceLocation resourceLocation = new ResourceLocation("excavated_variants", "block/" + full_id + i2);
                        outModelRLs.add(resourceLocation);
                        String finalJson = GSON.toJson((JsonElement)outputMap);
                        resources.put(new ResourceLocation("excavated_variants", "models/" + resourceLocation.m_135815_() + ".json"), () -> new ByteArrayInputStream(finalJson.getBytes()));
                        ++i2;
                    }
                    BlockstateModelParser assembler = BlockstateModelParser.create(outBlock, outModelRLs);
                    String bs = GSON.toJson((Object)assembler);
                    resources.put(new ResourceLocation("excavated_variants", "blockstates/" + full_id + ".json"), () -> new ByteArrayInputStream(bs.getBytes()));
                }
                catch (IOException e) {
                    ExcavatedVariants.LOGGER.error((Object)e);
                }
                continue;
            }
            ExcavatedVariants.LOGGER.warn("Missing {}for ore {}", (Object)((oreInfo == null ? "ore model info, " : "") + (stoneInfo == null ? "stone model info, " : "") + (extractorPair == null ? "texture extractor info, " : "") + (outBlock == null ? "registered block, " : "")), (Object)full_id);
        }
        return resources;
    }

    private static Pair<BlockModelDefinition, List<ResourceLocation>> getInfoFromBlockstate(ResourceLocation oreRl, BlockModelDefinition.Context ctx) throws IOException {
        InputStream oreBSIS;
        ResourceLocation oreBS = new ResourceLocation(oreRl.m_135827_(), "blockstates/" + oreRl.m_135815_() + ".json");
        try {
            oreBSIS = ClientPrePackRepository.getResource((ResourceLocation)oreBS);
        }
        catch (IOException e) {
            oreBSIS = BackupFetcher.provideBlockstateFile(oreRl);
        }
        BlockModelDefinition oreBMD = BlockModelDefinition.m_111540_((BlockModelDefinition.Context)ctx, (Reader)new BufferedReader(new InputStreamReader(oreBSIS, StandardCharsets.UTF_8)));
        if (!oreBMD.m_111543_()) {
            HashSet oreModels = new HashSet();
            for (Map.Entry e : oreBMD.m_111539_().entrySet()) {
                oreModels.addAll(((MultiVariant)e.getValue()).m_7970_());
            }
            ArrayList<ResourceLocation> oreTextures = new ArrayList<ResourceLocation>();
            for (ResourceLocation mRl : oreModels) {
                InputStream is;
                ResourceLocation actual = new ResourceLocation(mRl.m_135827_(), "models/" + mRl.m_135815_() + ".json");
                try {
                    is = ClientPrePackRepository.getResource((ResourceLocation)actual);
                }
                catch (IOException e) {
                    is = BackupFetcher.provideBlockModelFile(mRl);
                }
                BlockModelParser map = (BlockModelParser)GSON.fromJson((Reader)new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)), BlockModelParser.class);
                if (map.textures == null) continue;
                for (String i : map.textures.values()) {
                    ResourceLocation o = ResourceLocation.m_135822_((String)i, (char)':');
                    oreTextures.add(new ResourceLocation(o.m_135827_(), "textures/" + o.m_135815_() + ".png"));
                }
            }
            return new Pair<BlockModelDefinition, List<ResourceLocation>>(oreBMD, oreTextures);
        }
        return null;
    }
}

