/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.excavated_variants.forge;

import com.google.common.base.Suppliers;
import io.github.lukebemish.excavated_variants.ExcavatedVariants;
import io.github.lukebemish.excavated_variants.ExcavatedVariantsClient;
import io.github.lukebemish.excavated_variants.forge.EventHandler;
import io.github.lukebemish.excavated_variants.forge.ExcavatedVariantsForgeClient;
import io.github.lukebemish.excavated_variants.forge.MainPlatformTargetImpl;
import io.github.lukebemish.excavated_variants.forge.compat.HyleCompat;
import io.github.lukebemish.excavated_variants.worldgen.OreReplacer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="excavated_variants")
public class ExcavatedVariantsForge {
    private static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"excavated_variants");
    public static final ArrayList<Supplier<Item>> toRegister = new ArrayList();
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> ORE_REPLACER = FEATURES.register("ore_replacer", OreReplacer::new);
    private static final Supplier<ModContainer> EV_CONTAINER = Suppliers.memoize(() -> (ModContainer)ModList.get().getModContainerById("excavated_variants").orElseThrow());

    public ExcavatedVariantsForge() {
        IEventBus modbus = FMLJavaModLoadingContext.get().getModEventBus();
        ExcavatedVariants.init();
        FEATURES.register(FMLJavaModLoadingContext.get().getModEventBus());
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ExcavatedVariantsClient.init();
            modbus.addListener(ExcavatedVariantsForgeClient::clientSetup);
        });
        modbus.addListener(ExcavatedVariantsForge::commonSetup);
        modbus.addGenericListener(Item.class, ExcavatedVariantsForge::registerItems);
        MinecraftForge.EVENT_BUS.register(EventHandler.class);
        ModList.get().getModContainerById("hyle").ifPresent(container -> MinecraftForge.EVENT_BUS.register((Object)new HyleCompat()));
        MainPlatformTargetImpl.RECIPE_SERIALIZERS.register(modbus);
    }

    public static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ExcavatedVariants.ORE_REPLACER_CONFIGURED = new ConfiguredFeature((Feature)ORE_REPLACER.get(), (FeatureConfiguration)FeatureConfiguration.f_67737_);
            ExcavatedVariants.ORE_REPLACER_PLACED = new PlacedFeature(Holder.m_205709_(ExcavatedVariants.ORE_REPLACER_CONFIGURED), List.of());
            Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)new ResourceLocation("excavated_variants", "ore_replacer"), ExcavatedVariants.ORE_REPLACER_CONFIGURED);
            Registry.m_122965_((Registry)BuiltinRegistries.f_194653_, (ResourceLocation)new ResourceLocation("excavated_variants", "ore_replacer"), (Object)ExcavatedVariants.ORE_REPLACER_PLACED);
        });
    }

    public static void registerItems(RegistryEvent.Register<Item> e) {
        ModContainer activeContainer = ModLoadingContext.get().getActiveContainer();
        ModLoadingContext.get().setActiveContainer(EV_CONTAINER.get());
        for (Supplier<Item> si : toRegister) {
            e.getRegistry().register((IForgeRegistryEntry)si.get());
        }
        ModLoadingContext.get().setActiveContainer(activeContainer);
    }
}

