/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.excavated_variants.worldgen;

import io.github.lukebemish.excavated_variants.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;

public class OreGenMapSavedData
extends SavedData {
    public static final String DATA_KEY = "excavated_variants:ore_replacement";
    public Map<Pair<Integer, Integer>, Integer> edgeCount = Collections.synchronizedMap(new HashMap());
    public Map<Pair<Integer, Integer>, Boolean> ranMap = Collections.synchronizedMap(new HashMap());

    public CompoundTag m_7176_(CompoundTag tag) {
        ArrayList<Integer> edge_1 = new ArrayList<Integer>();
        ArrayList<Integer> edge_2 = new ArrayList<Integer>();
        ArrayList<Integer> edge_3 = new ArrayList<Integer>();
        ArrayList<Integer> ran_1 = new ArrayList<Integer>();
        ArrayList<Integer> ran_2 = new ArrayList<Integer>();
        ArrayList<Integer> ran_3 = new ArrayList<Integer>();
        for (Pair<Integer, Integer> p : this.edgeCount.keySet()) {
            edge_1.add(p.first());
            edge_2.add(p.last());
            edge_3.add(this.edgeCount.get(p));
        }
        for (Pair<Integer, Integer> p : this.ranMap.keySet()) {
            ran_1.add(p.first());
            ran_2.add(p.last());
            ran_3.add(this.ranMap.get(p) != false ? 1 : 0);
        }
        tag.m_128385_("edge_1", edge_1.stream().mapToInt(Integer::intValue).toArray());
        tag.m_128385_("edge_2", edge_2.stream().mapToInt(Integer::intValue).toArray());
        tag.m_128385_("edge_3", edge_3.stream().mapToInt(Integer::intValue).toArray());
        tag.m_128385_("ran_1", ran_1.stream().mapToInt(Integer::intValue).toArray());
        tag.m_128385_("ran_2", ran_2.stream().mapToInt(Integer::intValue).toArray());
        tag.m_128385_("ran_3", ran_3.stream().mapToInt(Integer::intValue).toArray());
        return tag;
    }

    public static OreGenMapSavedData load(CompoundTag tag) {
        OreGenMapSavedData data = new OreGenMapSavedData();
        int[] edge_1 = tag.m_128465_("edge_1");
        int[] edge_2 = tag.m_128465_("edge_2");
        int[] edge_3 = tag.m_128465_("edge_3");
        int[] ran_1 = tag.m_128465_("ran_1");
        int[] ran_2 = tag.m_128465_("ran_2");
        int[] ran_3 = tag.m_128465_("ran_3");
        if (edge_1.length == edge_2.length && edge_1.length == edge_3.length && ran_1.length == ran_2.length && ran_1.length == ran_3.length) {
            int i;
            for (i = 0; i < edge_1.length; ++i) {
                data.edgeCount.put(new Pair<Integer, Integer>(edge_1[i], edge_2[i]), edge_3[i]);
            }
            for (i = 0; i < ran_1.length; ++i) {
                data.ranMap.put(new Pair<Integer, Integer>(ran_1[i], ran_2[i]), ran_3[i] != 0);
            }
        }
        return data;
    }

    public static OreGenMapSavedData create() {
        return new OreGenMapSavedData();
    }

    public static OreGenMapSavedData getOrCreate(ServerLevelAccessor world) {
        return (OreGenMapSavedData)world.m_6018_().m_8895_().m_164861_(OreGenMapSavedData::load, OreGenMapSavedData::create, DATA_KEY);
    }
}

