/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.defaultresources.impl;

import com.mojang.logging.LogUtils;
import dev.lukebemish.defaultresources.impl.AutoMetadataPackResources;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.FileUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class AutoMetadataPathPackResources
extends AutoMetadataPackResources {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected final List<Path> paths;

    public AutoMetadataPathPackResources(PackLocationInfo info, String prefix, List<Path> paths, PackType packType) {
        super(info, packType, prefix);
        this.paths = paths;
    }

    public @Nullable IoSupplier<InputStream> getResource(PackType packType, ResourceLocation location) {
        for (Path root : this.paths) {
            Path path = root.resolve(this.getPackFolderName()).resolve(location.getNamespace());
            if (!Files.isDirectory(path, new LinkOption[0])) continue;
            return PathPackResources.getResource((ResourceLocation)location, (Path)path);
        }
        return null;
    }

    public void listResources(PackType packType, String namespace, String path, PackResources.ResourceOutput resourceOutput) {
        FileUtil.decomposePath((String)path).ifSuccess(list -> {
            for (Path root : this.paths) {
                Path namespacePath = root.resolve(this.getPackFolderName()).resolve(namespace);
                if (!Files.isDirectory(namespacePath, new LinkOption[0])) continue;
                PathPackResources.listPath((String)namespace, (Path)namespacePath, (List)list, (PackResources.ResourceOutput)resourceOutput);
            }
        }).ifError(partialResult -> LOGGER.error("Invalid path {}: {}", (Object)path, (Object)partialResult.message()));
    }

    public Set<String> getNamespaces(PackType type) {
        HashSet<String> set = new HashSet<String>();
        for (Path root : this.paths) {
            Path path = root.resolve(this.getPackFolderName());
            if (!Files.isDirectory(path, new LinkOption[0])) continue;
            try {
                DirectoryStream<Path> paths = Files.newDirectoryStream(path);
                try {
                    for (Path namespacePath : paths) {
                        String namespace;
                        if (!Files.isDirectory(namespacePath, new LinkOption[0]) || !(namespace = namespacePath.getFileName().toString()).equals(namespace.toLowerCase(Locale.ROOT))) continue;
                        set.add(namespace);
                    }
                }
                finally {
                    if (paths == null) continue;
                    paths.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to list path {}", (Object)path, (Object)e);
            }
        }
        return set;
    }

    public void close() {
    }
}

