/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.client.models.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3d;
import java.util.ArrayList;
import mc.craig.software.angels.client.models.entity.HeadPlacement;
import mc.craig.software.angels.client.models.entity.IAngelModel;
import mc.craig.software.angels.client.poses.WeepingAngelPose;
import mc.craig.software.angels.common.blockentities.PlinthBlockEntity;
import mc.craig.software.angels.common.blockentities.StatueBlockEntity;
import mc.craig.software.angels.common.entities.WeepingAngel;
import mc.craig.software.angels.common.variants.AbstractVariant;
import mc.craig.software.angels.common.variants.AngelTypes;
import mc.craig.software.angels.utils.Pair;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class ModelAngelChild
extends ListModel<WeepingAngel>
implements IAngelModel {
    private final ModelPart WeepingCherubFix;
    private final ModelPart LeftLeg;
    private final ModelPart RightLeg;
    private final ModelPart LeftArm;
    private final ModelPart RightArm;
    private final ModelPart Body;
    private final ModelPart Head;
    private final ModelPart LeftWing;
    private final ModelPart RightWing;
    private WeepingAngelPose weepingAngelPose = WeepingAngelPose.ANGRY;
    private boolean showHurt = false;
    private Pair<ModelPart, Vector3d> headData;

    public ModelAngelChild(ModelPart root) {
        this.WeepingCherubFix = root.m_171324_("WeepingCherubFix");
        this.LeftLeg = this.WeepingCherubFix.m_171324_("LeftLeg");
        this.RightLeg = this.WeepingCherubFix.m_171324_("RightLeg");
        this.LeftArm = this.WeepingCherubFix.m_171324_("LeftArm");
        this.RightArm = this.WeepingCherubFix.m_171324_("RightArm");
        this.Body = this.WeepingCherubFix.m_171324_("Body");
        this.Head = this.WeepingCherubFix.m_171324_("Head");
        this.LeftWing = this.WeepingCherubFix.m_171324_("LeftWing");
        this.RightWing = this.WeepingCherubFix.m_171324_("RightWing");
    }

    public static LayerDefinition getModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition WeepingCherubFix = partdefinition.m_171599_("WeepingCherubFix", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)24.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftLeg = WeepingCherubFix.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(19, 50).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)1.9f, (float)-12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition RightLeg = WeepingCherubFix.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(19, 50).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-1.9f, (float)-12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftArm = WeepingCherubFix.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(53, 53).m_171488_(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)5.0f, (float)-21.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition RightArm = WeepingCherubFix.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(50, 17).m_171488_(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-5.0f, (float)-21.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Body = WeepingCherubFix.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(33, 0).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(29, 30).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 15.0f, 4.0f, new CubeDeformation(0.25f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-24.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Head = WeepingCherubFix.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-24.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftWing = WeepingCherubFix.m_171599_("LeftWing", CubeListBuilder.m_171558_().m_171514_(0, 50).m_171488_(0.0f, -7.0f, 0.0f, 9.0f, 15.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-19.0f, (float)2.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition RightWing = WeepingCherubFix.m_171599_("RightWing", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171488_(-9.0f, -7.0f, 0.0f, 9.0f, 15.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-19.0f, (float)2.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)67, (int)69);
    }

    @Override
    public WeepingAngelPose getAngelPose() {
        return this.weepingAngelPose;
    }

    @Override
    public void setAngelPose(WeepingAngelPose angelPose) {
        this.weepingAngelPose = angelPose;
    }

    @Override
    public Pair<ModelPart, Vector3d> getHeadData(HeadPlacement placement) {
        if (placement == HeadPlacement.SANTA) {
            return null;
        }
        if (this.headData == null) {
            this.headData = new Pair<ModelPart, Vector3d>(this.Head, new Vector3d(0.0, 0.0, 0.0));
        }
        return this.headData;
    }

    public void setupAnim(WeepingAngel weepingAngel, float v, float v1, float v2, float v3, float v4) {
        WeepingAngelPose pose = this.weepingAngelPose;
        if (weepingAngel != null) {
            pose = WeepingAngelPose.getPose(weepingAngel.getAngelPose());
        }
        if (pose == WeepingAngelPose.FURIOUS) {
            this.RightArm.f_104203_ = (float)Math.toRadians(-115.0);
            this.RightArm.f_104204_ = (float)Math.toRadians(0.0);
            this.RightArm.f_104205_ = (float)Math.toRadians(0.0);
            this.LeftArm.f_104203_ = (float)Math.toRadians(-55.0);
            this.LeftArm.f_104204_ = (float)Math.toRadians(0.0);
            this.LeftArm.f_104205_ = (float)Math.toRadians(0.0);
            this.Head.f_104203_ = (float)Math.toRadians(17.5);
            this.Head.f_104204_ = (float)Math.toRadians(0.0);
            this.Head.f_104205_ = (float)Math.toRadians(-10.0);
            return;
        }
        if (pose == WeepingAngelPose.APPROACH) {
            this.RightArm.f_104203_ = -1.04533f;
            this.RightArm.f_104204_ = -0.55851f;
            this.RightArm.f_104205_ = 0.0f;
            this.LeftArm.f_104203_ = -1.04533f;
            this.LeftArm.f_104204_ = 0.55851f;
            this.LeftArm.f_104205_ = 0.0f;
            return;
        }
        if (pose == WeepingAngelPose.ANGRY) {
            this.RightArm.f_104203_ = (float)Math.toRadians(-90.0);
            this.RightArm.f_104204_ = (float)Math.toRadians(-20.0);
            this.RightArm.f_104205_ = (float)Math.toRadians(30.0);
            this.LeftArm.f_104203_ = (float)Math.toRadians(-90.0);
            this.LeftArm.f_104204_ = (float)Math.toRadians(25.0);
            this.LeftArm.f_104205_ = (float)Math.toRadians(-17.5);
            this.Head.f_104203_ = (float)Math.toRadians(0.0);
            this.Head.f_104204_ = (float)Math.toRadians(-12.5);
            this.Head.f_104205_ = (float)Math.toRadians(0.0);
            return;
        }
        if (pose == WeepingAngelPose.HIDING) {
            this.Head.f_104203_ = (float)Math.toRadians(20.0);
            this.Head.f_104204_ = (float)Math.toRadians(0.0);
            this.Head.f_104205_ = (float)Math.toRadians(0.0);
            this.RightArm.f_104203_ = (float)Math.toRadians(-105.0);
            this.RightArm.f_104204_ = (float)Math.toRadians(20.0);
            this.RightArm.f_104205_ = (float)Math.toRadians(12.5);
            this.LeftArm.f_104203_ = (float)Math.toRadians(-105.0);
            this.LeftArm.f_104204_ = (float)Math.toRadians(-20.0);
            this.LeftArm.f_104205_ = (float)Math.toRadians(-12.5);
            return;
        }
        if (pose == WeepingAngelPose.IDLE) {
            this.Head.f_104203_ = (float)Math.toRadians(0.0);
            this.Head.f_104204_ = (float)Math.toRadians(0.0);
            this.Head.f_104205_ = (float)Math.toRadians(0.0);
            this.RightArm.f_104203_ = (float)Math.toRadians(0.0);
            this.RightArm.f_104204_ = (float)Math.toRadians(0.0);
            this.RightArm.f_104205_ = (float)Math.toRadians(7.5);
            this.LeftArm.f_104203_ = (float)Math.toRadians(0.0);
            this.LeftArm.f_104204_ = (float)Math.toRadians(0.0);
            this.LeftArm.f_104205_ = (float)Math.toRadians(-7.5);
            return;
        }
        if (pose == WeepingAngelPose.SHY) {
            this.RightArm.f_104203_ = (float)Math.toRadians(-90.0);
            this.RightArm.f_104204_ = (float)Math.toRadians(-1.5);
            this.RightArm.f_104205_ = (float)Math.toRadians(-20.0);
            this.LeftArm.f_104203_ = (float)Math.toRadians(-120.0);
            this.LeftArm.f_104204_ = (float)Math.toRadians(-36.0);
            this.LeftArm.f_104205_ = (float)Math.toRadians(10.0);
            this.Head.f_104203_ = (float)Math.toRadians(20.0);
            this.Head.f_104204_ = (float)Math.toRadians(-40.0);
            this.Head.f_104205_ = (float)Math.toRadians(-20.0);
            return;
        }
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        matrixStack.m_85836_();
        matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        matrixStack.m_85837_(0.0, 1.5, 0.0);
        this.WeepingCherubFix.m_104301_(matrixStack, buffer, packedLight, this.showHurt ? packedOverlay : OverlayTexture.f_118083_);
        matrixStack.m_85849_();
    }

    public Iterable<ModelPart> m_6195_() {
        return ImmutableList.of((Object)this.Body, (Object)this.LeftWing, (Object)this.RightWing, (Object)this.Head, (Object)this.LeftArm, (Object)this.RightArm, (Object)this.LeftLeg, (Object)this.RightLeg, (Object)this.WeepingCherubFix);
    }

    @Override
    public ResourceLocation getTextureForPose(Object angel, WeepingAngelPose pose) {
        if (angel instanceof WeepingAngel) {
            WeepingAngel weepingAngel = (WeepingAngel)((Object)angel);
            return this.generateTex(pose, weepingAngel.getVariant());
        }
        if (angel instanceof StatueBlockEntity) {
            StatueBlockEntity weepingAngelEntity = (StatueBlockEntity)angel;
            return this.generateTex(weepingAngelEntity.getPose(), weepingAngelEntity.getAngelVarients());
        }
        if (angel instanceof PlinthBlockEntity) {
            PlinthBlockEntity weepingAngelEntity = (PlinthBlockEntity)angel;
            return this.generateTex(weepingAngelEntity.getPose(), weepingAngelEntity.getVariant());
        }
        return this.generateTex(WeepingAngelPose.APPROACH, (AbstractVariant)((Object)AngelTypes.NORMAL.get()));
    }

    @Override
    public boolean toggleHurt(boolean hurtShow) {
        return this.showHurt;
    }

    @Override
    public ResourceLocation generateTex(WeepingAngelPose pose, AbstractVariant angelVariants) {
        String location = "textures/entities/cherub/angel_cherub_";
        WeepingAngelPose.Emotion emotion = pose.getEmotion();
        String suffix = emotion.name().toLowerCase();
        return new ResourceLocation("weeping_angels", location + suffix + ".png");
    }

    @Override
    public Iterable<ModelPart> wings(PoseStack pose) {
        return new ArrayList<ModelPart>();
    }
}

