/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.client.models.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3d;
import mc.craig.software.angels.client.models.entity.HeadPlacement;
import mc.craig.software.angels.client.models.entity.IAngelModel;
import mc.craig.software.angels.client.poses.WeepingAngelPose;
import mc.craig.software.angels.common.blockentities.PlinthBlockEntity;
import mc.craig.software.angels.common.blockentities.StatueBlockEntity;
import mc.craig.software.angels.common.entities.WeepingAngel;
import mc.craig.software.angels.common.variants.AbstractVariant;
import mc.craig.software.angels.utils.Pair;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;

public class ModelDisasterAngel
extends ListModel<WeepingAngel>
implements IAngelModel,
HeadedModel,
ArmedModel {
    public static final ResourceLocation ANGRY = new ResourceLocation("weeping_angels", "textures/entities/disaster/normal/normal_angel_angry.png");
    public final ModelPart head;
    public final ModelPart body;
    public final ModelPart leftArm;
    public final ModelPart rightArm;
    public final ModelPart Legs;
    public final ModelPart leftWing;
    public final ModelPart rightWing;
    private WeepingAngelPose weepingAngelPose = WeepingAngelPose.ANGRY;
    private boolean showHurt = false;
    private Pair<ModelPart, Vector3d> headData;

    public ModelDisasterAngel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.Legs = root.m_171324_("legs");
        this.body = root.m_171324_("body");
        this.rightArm = root.m_171324_("right_arm");
        this.leftArm = root.m_171324_("left_arm");
        this.leftWing = root.m_171324_("leftwing");
        this.rightWing = root.m_171324_("rightwing");
    }

    public static LayerDefinition getModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(72, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(56, 17).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(32, 17).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.5f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(24, 59).m_171488_(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-5.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(10, 59).m_171488_(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)5.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Legs = partdefinition.m_171599_("legs", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171488_(-5.0f, -0.25f, -3.0f, 10.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 0).m_171488_(-6.0f, 10.75f, -4.0f, 12.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)9.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftWing = partdefinition.m_171599_("leftwing", CubeListBuilder.m_171558_().m_171514_(0, 101).m_171488_(-1.0f, -4.0f, 0.0f, 2.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(6, 83).m_171488_(-1.0f, -8.9f, 5.0f, 2.0f, 14.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(18, 83).m_171488_(-1.0f, -6.9f, 3.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(8, 33).m_171488_(-1.0f, -10.9f, 6.0f, 2.0f, 21.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 33).m_171488_(-1.0f, -10.0f, 9.0f, 2.0f, 24.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(38, 59).m_171488_(-1.0f, -8.0f, 11.0f, 2.0f, 17.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-1.0f, (float)5.0f, (float)2.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition rightWing = partdefinition.m_171599_("rightwing", CubeListBuilder.m_171558_().m_171514_(10, 101).m_171488_(-1.0f, -4.0f, 0.0f, 2.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(12, 83).m_171488_(-1.0f, -8.9f, 5.0f, 2.0f, 14.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(26, 83).m_171488_(-1.0f, -6.9f, 3.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(18, 33).m_171488_(-1.0f, -10.0f, 9.0f, 2.0f, 24.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 83).m_171488_(-1.0f, -8.0f, 11.0f, 2.0f, 17.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 59).m_171488_(-1.0f, -10.9f, 6.0f, 2.0f, 21.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)1.0f, (float)5.0f, (float)2.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setPose(WeepingAngelPose weepingAngelPose) {
        this.weepingAngelPose = weepingAngelPose;
    }

    public WeepingAngelPose getAngelPoses() {
        return this.weepingAngelPose;
    }

    public void setupAnim(WeepingAngel weepingAngel, float v, float v1, float v2, float v3, float v4) {
        this.leftWing.f_104207_ = false;
        this.rightWing.f_104207_ = false;
        WeepingAngelPose pose = this.weepingAngelPose;
        if (weepingAngel != null) {
            pose = WeepingAngelPose.getPose(weepingAngel.getAngelPose());
        }
        boolean isAngry = pose.getEmotion() == WeepingAngelPose.Emotion.ANGRY || pose.getEmotion() == WeepingAngelPose.Emotion.SCREAM;
        float angleX = isAngry ? 20.0f : 0.0f;
        float angleY = isAngry ? 60.0f : 45.0f;
        float angleZ = 0.0f;
        if (pose.getEmotion() == WeepingAngelPose.Emotion.SCREAM) {
            angleY += 10.0f;
            angleX -= 10.0f;
        }
        this.head.f_104203_ = (float)Math.toRadians(0.0);
        this.head.f_104204_ = (float)Math.toRadians(0.0);
        this.head.f_104205_ = (float)Math.toRadians(0.0);
        this.rightWing.f_104203_ = (float)Math.toRadians(angleX);
        this.rightWing.f_104204_ = (float)Math.toRadians(angleY);
        this.rightWing.f_104205_ = (float)Math.toRadians(angleZ);
        this.leftWing.f_104203_ = (float)Math.toRadians(angleX);
        this.leftWing.f_104204_ = (float)Math.toRadians(-angleY);
        this.leftWing.f_104205_ = (float)Math.toRadians(angleZ);
        if (pose == WeepingAngelPose.FURIOUS) {
            this.rightArm.f_104203_ = (float)Math.toRadians(-115.0);
            this.rightArm.f_104204_ = (float)Math.toRadians(0.0);
            this.rightArm.f_104205_ = (float)Math.toRadians(0.0);
            this.leftArm.f_104203_ = (float)Math.toRadians(-55.0);
            this.leftArm.f_104204_ = (float)Math.toRadians(0.0);
            this.leftArm.f_104205_ = (float)Math.toRadians(0.0);
            this.head.f_104203_ = (float)Math.toRadians(17.5);
            this.head.f_104204_ = (float)Math.toRadians(0.0);
            this.head.f_104205_ = (float)Math.toRadians(-10.0);
            return;
        }
        if (pose == WeepingAngelPose.ANGRY) {
            this.rightArm.f_104203_ = (float)Math.toRadians(-90.0);
            this.rightArm.f_104204_ = (float)Math.toRadians(-20.0);
            this.rightArm.f_104205_ = (float)Math.toRadians(30.0);
            this.leftArm.f_104203_ = (float)Math.toRadians(-90.0);
            this.leftArm.f_104204_ = (float)Math.toRadians(25.0);
            this.leftArm.f_104205_ = (float)Math.toRadians(-17.5);
            this.head.f_104203_ = (float)Math.toRadians(0.0);
            this.head.f_104204_ = (float)Math.toRadians(-12.5);
            this.head.f_104205_ = (float)Math.toRadians(0.0);
            return;
        }
        if (pose == WeepingAngelPose.HIDING) {
            this.head.f_104203_ = (float)Math.toRadians(20.0);
            this.head.f_104204_ = (float)Math.toRadians(0.0);
            this.head.f_104205_ = (float)Math.toRadians(0.0);
            this.rightArm.f_104203_ = (float)Math.toRadians(-105.0);
            this.rightArm.f_104204_ = (float)Math.toRadians(20.0);
            this.rightArm.f_104205_ = (float)Math.toRadians(12.5);
            this.leftArm.f_104203_ = (float)Math.toRadians(-105.0);
            this.leftArm.f_104204_ = (float)Math.toRadians(-20.0);
            this.leftArm.f_104205_ = (float)Math.toRadians(-12.5);
            return;
        }
        if (pose == WeepingAngelPose.APPROACH) {
            this.rightArm.f_104203_ = -1.04533f;
            this.rightArm.f_104204_ = -0.55851f;
            this.rightArm.f_104205_ = 0.0f;
            this.leftArm.f_104203_ = -1.04533f;
            this.leftArm.f_104204_ = 0.55851f;
            this.leftArm.f_104205_ = 0.0f;
            return;
        }
        if (pose == WeepingAngelPose.IDLE) {
            this.head.f_104203_ = (float)Math.toRadians(0.0);
            this.head.f_104204_ = (float)Math.toRadians(0.0);
            this.head.f_104205_ = (float)Math.toRadians(0.0);
            this.rightArm.f_104203_ = (float)Math.toRadians(0.0);
            this.rightArm.f_104204_ = (float)Math.toRadians(0.0);
            this.rightArm.f_104205_ = (float)Math.toRadians(-7.5);
            this.leftArm.f_104203_ = (float)Math.toRadians(0.0);
            this.leftArm.f_104204_ = (float)Math.toRadians(0.0);
            this.leftArm.f_104205_ = (float)Math.toRadians(7.5);
            return;
        }
        if (pose == WeepingAngelPose.SHY) {
            this.rightArm.f_104203_ = (float)Math.toRadians(-90.0);
            this.rightArm.f_104204_ = (float)Math.toRadians(-1.5);
            this.rightArm.f_104205_ = (float)Math.toRadians(-20.0);
            this.leftArm.f_104203_ = (float)Math.toRadians(-120.0);
            this.leftArm.f_104204_ = (float)Math.toRadians(-36.0);
            this.leftArm.f_104205_ = (float)Math.toRadians(10.0);
            this.head.f_104203_ = (float)Math.toRadians(20.0);
            this.head.f_104204_ = (float)Math.toRadians(-40.0);
            this.head.f_104205_ = (float)Math.toRadians(-20.0);
            return;
        }
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.head.m_104301_(matrixStack, buffer, packedLight, this.showHurt ? packedOverlay : OverlayTexture.f_118083_);
        this.body.m_104301_(matrixStack, buffer, packedLight, this.showHurt ? packedOverlay : OverlayTexture.f_118083_);
        this.leftArm.m_104301_(matrixStack, buffer, packedLight, this.showHurt ? packedOverlay : OverlayTexture.f_118083_);
        this.rightArm.m_104301_(matrixStack, buffer, packedLight, this.showHurt ? packedOverlay : OverlayTexture.f_118083_);
        this.Legs.m_104301_(matrixStack, buffer, packedLight, this.showHurt ? packedOverlay : OverlayTexture.f_118083_);
        this.leftWing.m_104301_(matrixStack, buffer, packedLight, this.showHurt ? packedOverlay : OverlayTexture.f_118083_);
        this.rightWing.m_104301_(matrixStack, buffer, packedLight, this.showHurt ? packedOverlay : OverlayTexture.f_118083_);
    }

    public Iterable<ModelPart> m_6195_() {
        return ImmutableList.of((Object)this.body, (Object)this.leftWing, (Object)this.rightWing, (Object)this.head, (Object)this.leftArm, (Object)this.rightArm, (Object)this.Legs);
    }

    @Override
    public ResourceLocation getTextureForPose(Object angel, WeepingAngelPose pose) {
        if (angel instanceof WeepingAngel) {
            WeepingAngel weepingAngel = (WeepingAngel)((Object)angel);
            return this.generateTex(pose, weepingAngel.getVariant());
        }
        if (angel instanceof StatueBlockEntity) {
            StatueBlockEntity statueBlockEntity = (StatueBlockEntity)angel;
            return this.generateTex(statueBlockEntity.getPose(), statueBlockEntity.getAngelVarients());
        }
        if (angel instanceof PlinthBlockEntity) {
            PlinthBlockEntity plinthBlockEntity = (PlinthBlockEntity)angel;
            return this.generateTex(plinthBlockEntity.getPose(), plinthBlockEntity.getVariant());
        }
        return ANGRY;
    }

    @Override
    public WeepingAngelPose getAngelPose() {
        return this.weepingAngelPose;
    }

    @Override
    public void setAngelPose(WeepingAngelPose angelType) {
        this.weepingAngelPose = angelType;
    }

    @Override
    public Pair<ModelPart, Vector3d> getHeadData(HeadPlacement placement) {
        if (this.headData == null) {
            this.headData = new Pair<ModelPart, Vector3d>(this.head, new Vector3d(0.0, 0.0, 0.0));
        }
        return this.headData;
    }

    @Override
    public Iterable<ModelPart> wings(PoseStack pose) {
        return ImmutableList.of((Object)this.leftWing, (Object)this.rightWing);
    }

    @Override
    public boolean toggleHurt(boolean hurtShow) {
        this.showHurt = hurtShow;
        return this.showHurt;
    }

    @Override
    public ResourceLocation generateTex(WeepingAngelPose pose, AbstractVariant abstractVariant) {
        String variant = abstractVariant.getRegistryName().m_135815_() + "_angel_";
        Object coreFolder = "textures/entities/disaster/";
        coreFolder = (String)coreFolder + abstractVariant.getRegistryName().m_135815_() + "/";
        WeepingAngelPose.Emotion emotion = pose.getEmotion();
        String suffix = abstractVariant.isHeadless() ? "headless" : emotion.name().toLowerCase();
        return new ResourceLocation(abstractVariant.getRegistryName().m_135827_(), (String)coreFolder + variant + suffix + ".png");
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    protected ModelPart getArm(HumanoidArm handSide) {
        return handSide == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }

    public void m_6002_(HumanoidArm handSide, PoseStack matrixStack) {
        ModelPart hand = this.getArm(handSide);
        boolean wasVisible = hand.f_104207_;
        hand.f_104207_ = true;
        hand.m_104299_(matrixStack);
        hand.f_104207_ = wasVisible;
    }
}

