/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.client.models.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3d;
import mc.craig.software.angels.client.models.entity.HeadPlacement;
import mc.craig.software.angels.client.models.entity.IAngelModel;
import mc.craig.software.angels.client.poses.WeepingAngelPose;
import mc.craig.software.angels.common.entities.WeepingAngel;
import mc.craig.software.angels.common.variants.AbstractVariant;
import mc.craig.software.angels.utils.Pair;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class ModelWeepingVillager
extends EntityModel<WeepingAngel>
implements IAngelModel {
    private final ResourceLocation TEXTURE = new ResourceLocation("weeping_angels", "textures/entities/weeping_villager.png");
    private final ModelPart body;
    private final ModelPart wing0;
    private final ModelPart wing2;
    private final ModelPart head;
    private final ModelPart nose;
    private final ModelPart arms;
    private final ModelPart leg0;
    private final ModelPart leg1;
    private WeepingAngelPose weepingAngelPose = WeepingAngelPose.ANGRY;
    private boolean showHurt = false;
    private Pair<ModelPart, Vector3d> headData;

    public ModelWeepingVillager(ModelPart root) {
        this.body = root.m_171324_("body");
        this.wing0 = this.body.m_171324_("wing0");
        this.wing2 = this.body.m_171324_("wing2");
        this.head = this.body.m_171324_("head");
        this.nose = this.head.m_171324_("nose");
        this.arms = this.body.m_171324_("arms");
        this.leg0 = root.m_171324_("leg0");
        this.leg1 = root.m_171324_("leg1");
    }

    public static LayerDefinition getModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(27, 14).m_171488_(-4.0f, -18.0f, -3.0f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.5f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)18.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition wing0 = body.m_171599_("wing0", CubeListBuilder.m_171558_().m_171514_(50, 0).m_171488_(-0.5f, -3.0f, 0.75f, 1.0f, 7.0f, 6.0f, new CubeDeformation(0.5f)).m_171555_(false).m_171514_(52, 13).m_171488_(-0.5f, 5.0f, 2.75f, 1.0f, 2.0f, 4.0f, new CubeDeformation(0.5f)).m_171555_(false).m_171514_(47, 0).m_171488_(-0.5f, 8.0f, 3.75f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.5f)).m_171555_(false).m_171514_(59, 2).m_171488_(-0.5f, 11.0f, 5.75f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.5f)).m_171555_(false), PartPose.m_171423_((float)-1.5f, (float)-15.0f, (float)3.25f, (float)0.1745f, (float)-1.0472f, (float)0.0f));
        PartDefinition wing2 = body.m_171599_("wing2", CubeListBuilder.m_171558_().m_171514_(50, 0).m_171488_(-0.5f, -3.0f, 0.75f, 1.0f, 7.0f, 6.0f, new CubeDeformation(0.5f)).m_171555_(false).m_171514_(52, 13).m_171488_(-0.5f, 5.0f, 2.75f, 1.0f, 2.0f, 4.0f, new CubeDeformation(0.5f)).m_171555_(false).m_171514_(47, 0).m_171488_(-0.5f, 8.0f, 3.75f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.5f)).m_171555_(false).m_171514_(59, 2).m_171488_(-0.5f, 11.0f, 5.75f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.5f)).m_171555_(false), PartPose.m_171423_((float)1.5f, (float)-15.0f, (float)3.25f, (float)0.1745f, (float)1.0472f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-18.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(25, 1).m_171488_(-1.0f, 0.0f, -2.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition arms = body.m_171599_("arms", CubeListBuilder.m_171558_().m_171514_(30, 39).m_171488_(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(13, 35).m_171488_(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(13, 35).m_171488_(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-16.0f, (float)0.0f, (float)-1.1781f, (float)0.0f, (float)0.0f));
        PartDefinition leg0 = partdefinition.m_171599_("leg0", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)2.0f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leg1 = partdefinition.m_171599_("leg1", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-2.0f, (float)12.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(WeepingAngel weepingAngel, float v, float v1, float v2, float v3, float v4) {
        WeepingAngelPose pose = this.getAngelPose();
        if (weepingAngel != null) {
            pose = WeepingAngelPose.getPose(weepingAngel.getAngelPose());
        }
        this.body.f_104203_ = (float)Math.toRadians(0.0);
        this.body.f_104204_ = (float)Math.toRadians(0.0);
        this.body.f_104205_ = (float)Math.toRadians(0.0);
        this.wing0.f_104203_ = (float)Math.toRadians(0.0);
        this.wing2.f_104203_ = (float)Math.toRadians(0.0);
        this.head.f_104203_ = (float)Math.toRadians(0.0);
        this.head.f_104204_ = (float)Math.toRadians(0.0);
        this.head.f_104205_ = (float)Math.toRadians(0.0);
        this.nose.f_104203_ = (float)Math.toRadians(0.0);
        this.arms.f_104203_ = (float)Math.toRadians(0.0);
        this.leg1.f_104203_ = (float)Math.toRadians(0.0);
        this.leg0.f_104203_ = (float)Math.toRadians(0.0);
        boolean isAngry = pose.getEmotion() == WeepingAngelPose.Emotion.ANGRY || pose.getEmotion() == WeepingAngelPose.Emotion.SCREAM;
        float angleX = isAngry ? 20.0f : 0.0f;
        float angleY = isAngry ? 60.0f : 45.0f;
        float angleZ = 0.0f;
        if (pose.getEmotion() == WeepingAngelPose.Emotion.SCREAM) {
            angleY += 10.0f;
            angleX -= 10.0f;
        }
        this.wing2.f_104203_ = (float)Math.toRadians(angleX);
        this.wing2.f_104204_ = (float)Math.toRadians(angleY);
        this.wing2.f_104205_ = (float)Math.toRadians(angleZ);
        this.wing0.f_104203_ = (float)Math.toRadians(angleX);
        this.wing0.f_104204_ = (float)Math.toRadians(-angleY);
        this.wing0.f_104205_ = (float)Math.toRadians(angleZ);
        this.nose.f_104203_ = (float)Math.toRadians(0.0);
        this.nose.f_104204_ = (float)Math.toRadians(0.0);
        this.nose.f_104205_ = (float)Math.toRadians(0.0);
        this.body.f_104203_ = (float)Math.toRadians(17.5);
        this.body.f_104204_ = (float)Math.toRadians(0.0);
        this.body.f_104205_ = (float)Math.toRadians(0.0);
        this.arms.f_104203_ = (float)Math.toRadians(-67.5);
        this.arms.f_104204_ = (float)Math.toRadians(0.0);
        this.arms.f_104205_ = (float)Math.toRadians(0.0);
        this.wing0.f_104203_ = 0.1745f;
        this.wing0.f_104204_ = -1.0472f;
        this.wing0.f_104205_ = (float)Math.toRadians(0.0);
        this.wing2.f_104203_ = 0.1745f;
        this.wing2.f_104204_ = 1.0472f;
        this.wing2.f_104205_ = (float)Math.toRadians(0.0);
        if (pose == WeepingAngelPose.HIDING) {
            this.head.f_104203_ = (float)Math.toRadians(30.0);
            this.head.f_104204_ = (float)Math.toRadians(0.0);
            this.head.f_104205_ = (float)Math.toRadians(0.0);
            this.body.f_104203_ = (float)Math.toRadians(0.0);
            this.nose.f_104203_ = (float)Math.toRadians(-17.5);
            this.arms.f_104203_ = (float)Math.toRadians(0.0);
            this.arms.f_104203_ = (float)Math.toRadians(-90.0);
            this.arms.f_104205_ = (float)Math.toRadians(0.0);
            return;
        }
        if (pose == WeepingAngelPose.IDLE || pose == WeepingAngelPose.SHY) {
            this.head.f_104203_ = (float)Math.toRadians(0.0);
            this.head.f_104204_ = (float)Math.toRadians(0.0);
            this.head.f_104205_ = (float)Math.toRadians(0.0);
            this.body.f_104203_ = (float)Math.toRadians(0.0);
            this.body.f_104204_ = (float)Math.toRadians(0.0);
            this.body.f_104205_ = (float)Math.toRadians(0.0);
            this.arms.f_104203_ = (float)Math.toRadians(-67.5);
            this.arms.f_104204_ = (float)Math.toRadians(0.0);
            this.arms.f_104205_ = (float)Math.toRadians(0.0);
            return;
        }
        if (pose.getEmotion() == WeepingAngelPose.Emotion.ANGRY) {
            this.head.f_104203_ = (float)Math.toRadians(-32.5);
            this.body.f_104203_ = (float)Math.toRadians(17.5);
            this.wing2.f_104203_ = 0.349f;
            this.wing0.f_104203_ = 0.349f;
            return;
        }
    }

    @Override
    public WeepingAngelPose getAngelPose() {
        return this.weepingAngelPose;
    }

    @Override
    public void setAngelPose(WeepingAngelPose angelPose) {
        this.weepingAngelPose = angelPose;
    }

    @Override
    public Pair<ModelPart, Vector3d> getHeadData(HeadPlacement placement) {
        if (placement == HeadPlacement.SANTA) {
            return null;
        }
        if (this.headData == null) {
            this.headData = new Pair<ModelPart, Vector3d>(this.head, new Vector3d(0.0, 0.0, 0.0));
        }
        return this.headData;
    }

    @Override
    public Iterable<ModelPart> wings(PoseStack pose) {
        pose.m_85837_(0.0, 1.2, 0.0);
        return ImmutableList.of((Object)this.wing0, (Object)this.wing2);
    }

    @Override
    public boolean toggleHurt(boolean hurtShow) {
        return this.showHurt;
    }

    @Override
    public ResourceLocation generateTex(WeepingAngelPose pose, AbstractVariant angelVariants) {
        return this.getTextureForPose((Object)pose, null);
    }

    @Override
    public ResourceLocation getTextureForPose(Object angel, WeepingAngelPose pose) {
        return this.TEXTURE;
    }

    public void m_7695_(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104301_(matrixStack, buffer, packedLight, this.showHurt ? packedOverlay : OverlayTexture.f_118083_);
        this.leg0.m_104301_(matrixStack, buffer, packedLight, this.showHurt ? packedOverlay : OverlayTexture.f_118083_);
        this.leg1.m_104301_(matrixStack, buffer, packedLight, this.showHurt ? packedOverlay : OverlayTexture.f_118083_);
    }
}

