/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.client.renders;

import com.mojang.blaze3d.vertex.PoseStack;
import mc.craig.software.angels.client.models.entity.IAngelModel;
import mc.craig.software.angels.client.models.entity.WAModels;
import mc.craig.software.angels.client.poses.WeepingAngelPose;
import mc.craig.software.angels.client.renders.Donator;
import mc.craig.software.angels.client.renders.MercyWings;
import mc.craig.software.angels.common.entities.WeepingAngel;
import mc.craig.software.angels.common.variants.AbstractVariant;
import mc.craig.software.angels.common.variants.AngelTypes;
import mc.craig.software.angels.utils.ClientUtil;
import mc.craig.software.angels.utils.DateChecker;
import mc.craig.software.angels.utils.PlayerUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;

public class WingsLayer<T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    protected static Donator[] people = new Donator[0];
    public final MercyWings mercyWings;
    private final ResourceLocation TEXTURE = new ResourceLocation("weeping_angels", "textures/entities/mercy_wings.png");
    private EntityModel<WeepingAngel> model;

    public WingsLayer(RenderLayerParent<T, M> p_117346_) {
        super(p_117346_);
        DateChecker.update(true);
        this.mercyWings = new MercyWings(Minecraft.m_91087_().m_167973_().m_171103_(WAModels.MERCY_WINGS));
    }

    public static Donator shouldDisplay(Player player) {
        for (Donator person : people) {
            if (!player.m_142081_().equals(person.getUuid()) || player.m_36170_(PlayerModelPart.CAPE)) continue;
            return person;
        }
        return null;
    }

    public static void update() {
        people = PlayerUtil.getDonators();
    }

    public void render(PoseStack p_117349_, MultiBufferSource p_117350_, int p_117351_, T p_117352_, float p_117353_, float p_117354_, float p_117355_, float p_117356_, float p_117357_, float p_117358_) {
        Player player;
        if (p_117352_.m_20177_((Player)Minecraft.m_91087_().f_91074_)) {
            return;
        }
        if (p_117352_ instanceof Player && WingsLayer.shouldDisplay(player = (Player)p_117352_) != null) {
            Donator data = WingsLayer.shouldDisplay(player);
            p_117349_.m_85836_();
            if (data.getWings().equalsIgnoreCase("mercy")) {
                ((HumanoidModel)this.m_117386_()).f_102810_.m_104299_(p_117349_);
                this.mercyWings.setupAnim((LivingEntity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                this.mercyWings.RWing.m_104301_(p_117349_, p_117350_.m_6299_(RenderType.m_110473_((ResourceLocation)this.TEXTURE)), p_117351_, OverlayTexture.f_118083_);
                this.mercyWings.Lwing.m_104301_(p_117349_, p_117350_.m_6299_(RenderType.m_110473_((ResourceLocation)this.TEXTURE)), p_117351_, OverlayTexture.f_118083_);
            } else {
                this.model = ClientUtil.getModelForAngel(data.getPureWings());
                EntityModel<WeepingAngel> entityModel = this.model;
                if (entityModel instanceof IAngelModel) {
                    IAngelModel iAngelModel = (IAngelModel)entityModel;
                    ((HumanoidModel)this.m_117386_()).f_102810_.m_104299_(p_117349_);
                    iAngelModel.setAngelPose(data.isPerked() ? WeepingAngelPose.ANGRY : WeepingAngelPose.IDLE);
                    this.model.m_6973_(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                    for (ModelPart wing : iAngelModel.wings(p_117349_)) {
                        if (wing == null) continue;
                        wing.m_104301_(p_117349_, p_117350_.m_6299_(RenderType.m_110473_((ResourceLocation)iAngelModel.generateTex(WeepingAngelPose.HIDING, (AbstractVariant)AngelTypes.VARIANTS_REGISTRY.get().getValue(new ResourceLocation(data.getVariant()))))), p_117351_, OverlayTexture.f_118083_);
                    }
                }
            }
            p_117349_.m_85849_();
        }
    }
}

