/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.common.blocks;

import javax.annotation.Nullable;
import mc.craig.software.angels.common.blockentities.CoffinBlockEntity;
import mc.craig.software.angels.utils.AngelUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SculkSensorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;

public class CoffinBlock
extends BaseEntityBlock {
    public static final BooleanProperty UPRIGHT = BooleanProperty.m_61465_((String)"upright");
    public static final IntegerProperty ROTATION = BlockStateProperties.f_61390_;

    public CoffinBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)SculkSensorBlock.f_154388_, (Comparable)Boolean.valueOf(false)));
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        CoffinBlockEntity coffinBlockEntity;
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof CoffinBlockEntity && (coffinBlockEntity = (CoffinBlockEntity)blockEntity).getCoffin().isPoliceBox()) {
            return 7;
        }
        return super.getLightEmission(state, world, pos);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!worldIn.f_46443_ && handIn == InteractionHand.MAIN_HAND) {
            CoffinBlockEntity coffinBlockEntity = (CoffinBlockEntity)worldIn.m_7702_(pos);
            if (coffinBlockEntity != null) {
                if (!coffinBlockEntity.getCoffin().isPoliceBox()) {
                    coffinBlockEntity.setOpen(!coffinBlockEntity.isOpen());
                    worldIn.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, coffinBlockEntity.isOpen() ? SoundEvents.f_11889_ : SoundEvents.f_11747_, SoundSource.BLOCKS, 0.5f, worldIn.f_46441_.nextFloat() * 0.1f + 0.9f);
                } else if (player.m_21205_().m_41720_() instanceof RecordItem) {
                    coffinBlockEntity.setDoingSomething(true);
                    if (!player.m_7500_()) {
                        player.m_21205_().m_41774_(1);
                    }
                }
            }
            coffinBlockEntity.sendUpdates();
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    public boolean m_49967_() {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{UPRIGHT, ROTATION, SculkSensorBlock.f_154388_});
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        FluidState fluid = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)((BlockState)state.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(Mth.m_14107_((double)((double)(context.m_7074_() * 16.0f / 360.0f) + 0.5)) & 0xF))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluid.m_205070_(FluidTags.f_13131_)))).m_61124_((Property)UPRIGHT, (Comparable)Boolean.valueOf(context.m_43723_().m_6144_()));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76145_() : Fluids.f_76191_.m_76145_();
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(rot.m_55949_(((Integer)state.m_61143_((Property)ROTATION)).intValue(), 16)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return (BlockState)state.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(mirrorIn.m_54843_(((Integer)state.m_61143_((Property)ROTATION)).intValue(), 16)));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new CoffinBlockEntity(p_153215_, p_153216_);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return (level1, blockPos, blockState, t) -> {
            if (t instanceof CoffinBlockEntity) {
                CoffinBlockEntity coffinBlockEntity = (CoffinBlockEntity)t;
                coffinBlockEntity.tick(level, blockPos, blockState, coffinBlockEntity);
            }
        };
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(world, pos, state, placer, stack);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof CoffinBlockEntity) {
            CoffinBlockEntity coffinBlockEntity = (CoffinBlockEntity)blockEntity;
            if (!world.f_46443_) {
                if (stack.m_41737_("BlockEntityTag") != null) {
                    coffinBlockEntity.m_142466_(stack.m_41737_("BlockEntityTag"));
                } else {
                    coffinBlockEntity.setCoffin(AngelUtil.randomCoffin());
                }
            }
        }
    }
}

