/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.common.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import mc.craig.software.angels.common.blockentities.SnowAngelBlockEntity;
import mc.craig.software.angels.common.entities.AngelType;
import mc.craig.software.angels.common.entities.WeepingAngel;
import mc.craig.software.angels.utils.AngelUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.phys.Vec3;

public class SnowAngelBlock
extends SnowLayerBlock
implements EntityBlock {
    public SnowAngelBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60977_().m_60955_());
    }

    public void m_7892_(BlockState blockState, Level world, BlockPos blockPos, Entity entity) {
        SnowAngelBlockEntity snowAngelBlockEntity;
        BlockEntity blockEntity = world.m_7702_(blockPos);
        if (blockEntity instanceof SnowAngelBlockEntity && (snowAngelBlockEntity = (SnowAngelBlockEntity)blockEntity).getSnowAngelStage() == SnowAngelBlockEntity.SnowAngelStages.ARM) {
            entity.m_7601_(blockState, new Vec3(0.15, (double)0.05f, 0.15));
        }
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        BlockEntity tile = worldIn.m_7702_(pos);
        if (tile instanceof SnowAngelBlockEntity) {
            SnowAngelBlockEntity snowAngelBlockEntity = (SnowAngelBlockEntity)tile;
            int rotation = Mth.m_14143_((float)placer.f_20883_);
            if (!snowAngelBlockEntity.isHasSetup()) {
                snowAngelBlockEntity.setSnowAngelStage(AngelUtil.randowSnowStage());
                snowAngelBlockEntity.setRotation(rotation);
                snowAngelBlockEntity.setHasSetup(true);
                snowAngelBlockEntity.setVariant(AngelType.DISASTER_MC.getWeightedHandler().getRandom(null));
                snowAngelBlockEntity.sendUpdates();
            }
        }
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    public void m_7455_(BlockState state, ServerLevel worldIn, BlockPos pos, Random random) {
        if (worldIn.m_45517_(LightLayer.BLOCK, pos) > 11) {
            Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)new ItemStack((ItemLike)Blocks.f_50125_));
            BlockEntity tile = worldIn.m_7702_(pos);
            if (tile instanceof SnowAngelBlockEntity) {
                SnowAngelBlockEntity snowAngelBlockEntity = (SnowAngelBlockEntity)tile;
                WeepingAngel angel = new WeepingAngel((Level)worldIn);
                angel.setType(AngelType.DISASTER_MC);
                angel.setVarient(snowAngelBlockEntity.getVariant());
                angel.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                worldIn.m_7967_((Entity)angel);
                worldIn.m_7471_(pos, false);
            }
        }
    }

    public RenderShape m_7514_(BlockState p_51567_) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SnowAngelBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return (level1, blockPos, blockState, t) -> {
            if (t instanceof SnowAngelBlockEntity) {
                SnowAngelBlockEntity snowAngelBlockEntity = (SnowAngelBlockEntity)t;
                snowAngelBlockEntity.tick(level, blockPos, blockState, snowAngelBlockEntity);
            }
        };
    }

    @Nullable
    public <T extends BlockEntity> GameEventListener m_142226_(Level p_153210_, T p_153211_) {
        return super.m_142226_(p_153210_, p_153211_);
    }
}

