/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.common.entities;

import java.util.ArrayList;
import java.util.List;
import mc.craig.software.angels.common.variants.AbstractVariant;
import mc.craig.software.angels.common.variants.AngelTypes;
import mc.craig.software.angels.common.variants.WeightedHandler;
import net.minecraftforge.registries.RegistryObject;

public enum AngelType {
    DISASTER_MC("Disaster", true, new ArrayList<AbstractVariant>()),
    DOCTOR("Doctor", true, List.of((AbstractVariant)((Object)AngelTypes.NORMAL.get()))),
    ED("Ed"),
    ED_ANGEL_CHILD("Cherub"),
    A_DIZZLE("A_Dizzle"),
    DYING("Dying"),
    SPARE_TIME("SpareTimeVA", true, List.of((AbstractVariant)((Object)AngelTypes.NORMAL.get()), (AbstractVariant)((Object)AngelTypes.RUSTED.get()))),
    VILLAGER("Villager");

    private final String readable;
    private final boolean canHold;
    private final WeightedHandler weightedHandler;

    private AngelType(String readable) {
        this.readable = readable;
        this.canHold = false;
        WeightedHandler weightedHandler = new WeightedHandler();
        weightedHandler.addEntry((AbstractVariant)((Object)AngelTypes.NORMAL.get()));
        this.weightedHandler = weightedHandler;
    }

    private AngelType(String readable, boolean canHold, List<AbstractVariant> w) {
        this.readable = readable;
        this.canHold = canHold;
        WeightedHandler weightedHandler = new WeightedHandler();
        for (AbstractVariant types : w) {
            weightedHandler.addEntry(types);
        }
        if (w.isEmpty()) {
            for (RegistryObject entry : AngelTypes.VARIANTS.getEntries()) {
                weightedHandler.addEntry((AbstractVariant)((Object)entry.get()));
            }
        }
        this.weightedHandler = weightedHandler;
    }

    public static AngelType next(AngelType type) {
        int index = type.ordinal();
        int nextIndex = index + 1;
        AngelType[] angels = AngelType.values();
        return angels[nextIndex %= angels.length];
    }

    public WeightedHandler getWeightedHandler() {
        return this.weightedHandler;
    }

    public String getReadable() {
        return this.readable;
    }

    public boolean canHoldThings() {
        return this.canHold;
    }
}

