/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.common.events;

import mc.craig.software.angels.client.renders.WingsLayer;
import mc.craig.software.angels.client.sounds.DetectorTickableSound;
import mc.craig.software.angels.common.WAObjects;
import mc.craig.software.angels.utils.DateChecker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawSelectionEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientEvents {
    public static boolean isInCatacombs = false;
    private static SoundInstance iSound = null;

    @SubscribeEvent
    public static void onPlayerJoin(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new DetectorTickableSound(player));
        }
    }

    @SubscribeEvent
    public static void onBlockHighlight(DrawSelectionEvent.HighlightBlock event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91077_ != null && minecraft.f_91077_.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockRayTraceResult = (BlockHitResult)minecraft.f_91077_;
            LocalPlayer playerEntity = minecraft.f_91074_;
            ClientLevel world = minecraft.f_91073_;
            boolean canSee = playerEntity.m_21205_().m_41720_() == ((Block)WAObjects.Blocks.STATUE.get()).m_5456_() || playerEntity.m_21206_().m_41720_() == ((Block)WAObjects.Blocks.STATUE.get()).m_5456_();
            event.setCanceled(!canSee && world.m_8055_(blockRayTraceResult.m_82425_()).m_60734_() == WAObjects.Blocks.STATUE.get());
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        SoundManager sound = Minecraft.m_91087_().m_91106_();
        if (isInCatacombs) {
            sound.m_120386_(null, SoundSource.MUSIC);
            if (iSound == null) {
                iSound = SimpleSoundInstance.m_119759_((SoundEvent)((SoundEvent)WAObjects.Sounds.CATACOMB.get()));
            }
            if (!sound.m_120403_(iSound)) {
                sound.m_120367_(iSound);
            }
        } else if (sound.m_120403_(iSound)) {
            sound.m_120399_(iSound);
        }
    }

    @SubscribeEvent
    public static void tickDate(TickEvent.ClientTickEvent event) {
        DateChecker.tick();
    }

    @SubscribeEvent
    public static void onSetupFogDensity(EntityViewRenderEvent.FogDensity event) {
        if (Minecraft.m_91087_().f_91073_ != null && isInCatacombs) {
            event.setCanceled(true);
            event.setDensity(70.0f);
        }
    }

    @SubscribeEvent
    public static void onSetupFogColor(EntityViewRenderEvent.FogColors event) {
        if (Minecraft.m_91087_().f_91073_ != null && isInCatacombs) {
            event.setRed(0.14f);
            event.setGreen(0.15f);
            event.setBlue(0.22f);
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class On {
        @SubscribeEvent
        public static void renderLayers(EntityRenderersEvent.AddLayers addLayers) {
            addLayers.getSkins().forEach(skin -> {
                LivingEntityRenderer renderer = addLayers.getSkin(skin);
                renderer.m_115326_(new WingsLayer(renderer));
            });
        }
    }
}

