/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.common.level;

import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.List;
import mc.craig.software.angels.WeepingAngels;
import mc.craig.software.angels.common.WAObjects;
import mc.craig.software.angels.common.level.structures.CatacombStructure;
import mc.craig.software.angels.common.level.structures.GraveyardStructure;
import mc.craig.software.angels.config.WAConfig;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WAFeatures {
    public static final DeferredRegister<StructureFeature<?>> DEFERRED_REGISTRY_STRUCTURE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"weeping_angels");
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> CATACOMB = DEFERRED_REGISTRY_STRUCTURE.register("catacombs", CatacombStructure::new);
    public static final RegistryObject<StructureFeature<NoneFeatureConfiguration>> GRAVEYARD = DEFERRED_REGISTRY_STRUCTURE.register("graveyard", () -> new GraveyardStructure((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    private static final HashSet<Holder<PlacedFeature>> FEATURES = new HashSet();
    private static final HashSet<Holder<PlacedFeature>> ORES = new HashSet();

    public static void ores() {
        BlockState blockState = ((Block)WAObjects.Blocks.KONTRON_ORE.get()).m_49966_();
        BlockState blockStateDeep = ((Block)WAObjects.Blocks.KONTRON_ORE_DEEPSLATE.get()).m_49966_();
        List<OreConfiguration.TargetBlockState> targetBlockStateList = List.of(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)blockState), OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)blockStateDeep));
        Holder feature = FeatureUtils.m_206488_((String)"ore_kontron", (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(targetBlockStateList, 9));
        Holder placedFeatureUpper = PlacementUtils.m_206509_((String)"kontron_ore_upper", (Holder)feature, WAFeatures.commonOrePlacement(90, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)80), (VerticalAnchor)VerticalAnchor.m_158922_((int)384))));
        Holder placedFeatureMiddle = PlacementUtils.m_206509_((String)"kontron_ore_middle", (Holder)feature, WAFeatures.commonOrePlacement(10, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)-24), (VerticalAnchor)VerticalAnchor.m_158922_((int)56))));
        ORES.add((Holder<PlacedFeature>)placedFeatureUpper);
        ORES.add((Holder<PlacedFeature>)placedFeatureMiddle);
        Holder snowAngelFeature = FeatureUtils.m_206488_((String)"snow_angel", (Feature)Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((Block)WAObjects.Blocks.SNOW_ANGEL.get()).m_49966_()))));
        Holder snowAngelPlaced = PlacementUtils.m_206513_((String)"snow_angel", (Holder)snowAngelFeature, (PlacementModifier[])new PlacementModifier[]{NoiseThresholdCountPlacement.m_191756_((double)-0.8, (int)0, (int)4), RarityFilter.m_191900_((int)300), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        FEATURES.add((Holder<PlacedFeature>)snowAngelPlaced);
    }

    @SubscribeEvent
    public static void gen(BiomeLoadingEvent event) {
        Holder biome;
        BiomeGenerationSettingsBuilder gen = event.getGeneration();
        if (event.getCategory() != Biome.BiomeCategory.NETHER && event.getCategory() != Biome.BiomeCategory.THEEND && ((Boolean)WAConfig.CONFIG.genOres.get()).booleanValue()) {
            for (Holder<PlacedFeature> feature : ORES) {
                gen.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, feature);
            }
        }
        if (((Biome)(biome = Holder.m_205709_((Object)((Biome)ForgeRegistries.BIOMES.getValue(event.getName())))).m_203334_()).m_47530_() == Biome.Precipitation.SNOW) {
            WeepingAngels.LOGGER.info("Added snow angels to " + event.getName());
            for (Holder<PlacedFeature> feature : FEATURES) {
                gen.m_204201_(GenerationStep.Decoration.RAW_GENERATION, feature);
            }
        }
    }

    private static List<PlacementModifier> orePlacement(PlacementModifier p_195347_, PlacementModifier p_195348_) {
        return List.of(p_195347_, InSquarePlacement.m_191715_(), p_195348_, BiomeFilter.m_191561_());
    }

    private static List<PlacementModifier> commonOrePlacement(int p_195344_, PlacementModifier p_195345_) {
        return WAFeatures.orePlacement((PlacementModifier)CountPlacement.m_191628_((int)p_195344_), p_195345_);
    }

    private static List<PlacementModifier> rareOrePlacement(int p_195350_, PlacementModifier p_195351_) {
        return WAFeatures.orePlacement((PlacementModifier)RarityFilter.m_191900_((int)p_195350_), p_195351_);
    }
}

