/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.common.level.structures;

import com.mojang.serialization.Codec;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import mc.craig.software.angels.client.poses.WeepingAngelPose;
import mc.craig.software.angels.common.WAObjects;
import mc.craig.software.angels.common.blockentities.CoffinBlockEntity;
import mc.craig.software.angels.common.blockentities.StatueBlockEntity;
import mc.craig.software.angels.common.entities.AngelType;
import mc.craig.software.angels.common.level.WAPieces;
import mc.craig.software.angels.config.WAConfig;
import mc.craig.software.angels.utils.AngelUtil;
import mc.craig.software.angels.utils.TagUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.datafix.fixes.BlockEntitySignTextStrictJsonFix;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.ArrayUtils;

public class GraveyardStructure
extends StructureFeature<NoneFeatureConfiguration> {
    public GraveyardStructure(Codec<NoneFeatureConfiguration> p_72474_) {
        super(p_72474_, PieceGeneratorSupplier.m_197349_(GraveyardStructure::checkLocation, GraveyardStructure::generatePieces));
    }

    private static boolean checkLocation(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> configurationContext) {
        return configurationContext.m_197380_(Heightmap.Types.WORLD_SURFACE_WG) && (Boolean)WAConfig.CONFIG.genGraveyard.get() != false;
    }

    private static void addPiece(StructureManager structureManager, BlockPos blockPos, Rotation rotation, StructurePiecesBuilder structurePieceAccessor, Random random, NoneFeatureConfiguration noneFeatureConfiguration) {
        ResourceLocation piece = GraveyardPiece.ALL_GRAVES[random.nextInt(GraveyardPiece.ALL_GRAVES.length)];
        structurePieceAccessor.m_142679_((StructurePiece)new GraveyardPiece(0, structureManager, piece, piece.toString(), GraveyardPiece.makeSettings(rotation), blockPos));
    }

    private static void generatePieces(StructurePiecesBuilder structurePiecesBuilder, PieceGenerator.Context<NoneFeatureConfiguration> configurationContext) {
        int height = configurationContext.f_192703_().m_156174_(configurationContext.f_192705_().m_45604_(), configurationContext.f_192705_().m_45605_(), Heightmap.Types.WORLD_SURFACE_WG, configurationContext.f_192707_());
        BlockPos blockpos = new BlockPos(configurationContext.f_192705_().m_45604_(), height, configurationContext.f_192705_().m_45605_());
        Rotation rotation = Rotation.m_55956_((Random)configurationContext.f_192708_());
        GraveyardStructure.addPiece(configurationContext.f_192704_(), blockpos, rotation, structurePiecesBuilder, (Random)configurationContext.f_192708_(), (NoneFeatureConfiguration)configurationContext.f_197328_());
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    public static class GraveyardPiece
    extends TemplateStructurePiece {
        private static final ResourceLocation GRAVEYARD_1 = new ResourceLocation("weeping_angels", "graves/graveyard_1");
        private static final ResourceLocation GRAVEYARD_2 = new ResourceLocation("weeping_angels", "graves/graveyard_2");
        private static final ResourceLocation GRAVEYARD_3 = new ResourceLocation("weeping_angels", "graves/graveyard_3");
        private static final ResourceLocation GRAVEYARD_4 = new ResourceLocation("weeping_angels", "graves/graveyard_4");
        private static final ResourceLocation GRAVEYARD_5 = new ResourceLocation("weeping_angels", "graves/graveyard_5");
        private static final ResourceLocation GRAVEYARD_6 = new ResourceLocation("weeping_angels", "graves/graveyard_6");
        private static final ResourceLocation GRAVEYARD_WALKWAY = new ResourceLocation("weeping_angels", "graves/graveyard_walkway");
        private static final ResourceLocation GRAVEYARD_LARGE_ONE = new ResourceLocation("weeping_angels", "graves/graveyard_lrg_1");
        private static final ResourceLocation GRAVEYARD_LARGE_TWO = new ResourceLocation("weeping_angels", "graves/graveyard_lrg_2");
        private static final ResourceLocation[] ALL_GRAVES = new ResourceLocation[]{GRAVEYARD_1, GRAVEYARD_2, GRAVEYARD_3, GRAVEYARD_4, GRAVEYARD_5, GRAVEYARD_6, GRAVEYARD_WALKWAY, GRAVEYARD_LARGE_ONE, GRAVEYARD_LARGE_TWO};
        private static String[] USERNAMES = new String[0];

        public GraveyardPiece(int p_163661_, StructureManager p_163662_, ResourceLocation p_163663_, String p_163664_, StructurePlaceSettings p_163665_, BlockPos p_163666_) {
            super(WAPieces.GRAVEYARD, p_163661_, p_163662_, p_163663_, p_163664_, p_163665_, p_163666_);
        }

        public GraveyardPiece(CompoundTag p_192678_, StructureManager p_192679_, Function<ResourceLocation, StructurePlaceSettings> p_192680_) {
            super(WAPieces.GRAVEYARD, p_192678_, p_192679_, p_192680_);
        }

        public GraveyardPiece(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag tag) {
            super(WAPieces.GRAVEYARD, tag, structurePieceSerializationContext.f_192764_(), p_162451_ -> GraveyardPiece.makeSettings(Rotation.NONE));
        }

        private static StructurePlaceSettings makeSettings(Rotation rot) {
            return new StructurePlaceSettings().m_74379_(rot).m_74377_(Mirror.NONE).m_74385_(BlockPos.f_121853_).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74046_);
        }

        public static String createRandomDate() {
            long startEpochDay = LocalDate.of(1800, 1, 1).toEpochDay();
            long endEpochDay = LocalDate.now().toEpochDay();
            long randomDay = ThreadLocalRandom.current().nextLong(startEpochDay, endEpochDay);
            LocalDate finalDate = LocalDate.ofEpochDay(randomDay);
            return finalDate.getDayOfMonth() + "." + finalDate.getMonthValue() + "." + finalDate.getYear();
        }

        public static Block getRandomPottedPlant(Random random) {
            ArrayList<Block> plants = new ArrayList<Block>();
            for (Object o : TagUtil.getValues((Registry)Registry.f_122824_, AngelUtil.POTTED_PLANTS)) {
                Holder value = (Holder)o;
                plants.add((Block)value.m_203334_());
            }
            return (Block)plants.get(random.nextInt(plants.size()));
        }

        protected void m_7756_(String function, BlockPos blockPos, ServerLevelAccessor serverLevelAccessor, Random random, BoundingBox p_73687_) {
            CoffinBlockEntity coffinTile;
            if (USERNAMES.length == 0) {
                try {
                    this.loadNames();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (ServerLifecycleHooks.getCurrentServer().m_6982_()) {
                USERNAMES = (String[])ArrayUtils.addAll((Object[])USERNAMES, (Object[])ServerLifecycleHooks.getCurrentServer().m_6846_().m_11291_());
            }
            if ("angel".equals(function)) {
                StatueBlockEntity statueTile = (StatueBlockEntity)serverLevelAccessor.m_7702_(blockPos.m_7495_());
                statueTile.setPose(WeepingAngelPose.HIDING);
                statueTile.setAngelType(AngelType.DISASTER_MC);
                statueTile.setAngelVarients(AngelType.DISASTER_MC.getWeightedHandler().getRandom(null));
                statueTile.m_6596_();
                serverLevelAccessor.m_7471_(blockPos, false);
            }
            if ("coffin".equals(function) && (coffinTile = (CoffinBlockEntity)serverLevelAccessor.m_7702_(blockPos.m_7495_())) != null) {
                coffinTile.setOpen(random.nextBoolean());
                coffinTile.setCoffin(AngelUtil.randomCoffin());
                coffinTile.setHasSkeleton(random.nextBoolean());
                serverLevelAccessor.m_7471_(blockPos, false);
            }
            if ("cobweb".equals(function)) {
                Block block = random.nextBoolean() ? Blocks.f_50033_ : Blocks.f_50016_;
                serverLevelAccessor.m_7731_(blockPos, block.m_49966_(), 2);
            }
            if ("crypt_chest".equals(function) || "chest".equals(function)) {
                RandomizableContainerBlockEntity.m_59620_((BlockGetter)serverLevelAccessor, (Random)random, (BlockPos)blockPos.m_7495_(), (ResourceLocation)WAObjects.CRYPT_LOOT);
                serverLevelAccessor.m_7471_(blockPos, false);
            }
            if ("chest_2down".equals(function)) {
                RandomizableContainerBlockEntity.m_59620_((BlockGetter)serverLevelAccessor, (Random)random, (BlockPos)blockPos.m_6625_(2), (ResourceLocation)WAObjects.CRYPT_LOOT);
                serverLevelAccessor.m_7471_(blockPos.m_6625_(2), false);
                serverLevelAccessor.m_7471_(blockPos, false);
            }
            if ("path".equals(function)) {
                serverLevelAccessor.m_7731_(blockPos, random.nextBoolean() ? Blocks.f_50016_.m_49966_() : GraveyardPiece.getRandomPottedPlant(random).m_49966_(), 2);
                serverLevelAccessor.m_7731_(blockPos.m_7495_(), Blocks.f_50599_.m_49966_(), 2);
            }
            if ("sign".equals(function)) {
                if (serverLevelAccessor.m_8055_(blockPos.m_7495_()).m_60734_() instanceof WallSignBlock) {
                    SignBlockEntity signTileEntity = (SignBlockEntity)serverLevelAccessor.m_7702_(blockPos.m_7495_());
                    if (signTileEntity != null) {
                        signTileEntity.m_59732_(0, (Component)new TranslatableComponent("========"));
                        signTileEntity.m_59732_(1, (Component)new TranslatableComponent(USERNAMES[random.nextInt(USERNAMES.length - 1)]));
                        signTileEntity.m_59732_(2, (Component)new TranslatableComponent("Died: " + GraveyardPiece.createRandomDate()));
                        signTileEntity.m_59732_(3, (Component)new TranslatableComponent("========"));
                        serverLevelAccessor.m_7471_(blockPos, false);
                        serverLevelAccessor.m_7731_(blockPos.m_6625_(2), Blocks.f_50599_.m_49966_(), 2);
                    }
                } else {
                    serverLevelAccessor.m_7471_(blockPos, false);
                }
            }
        }

        private void loadNames() throws IOException {
            String line;
            ResourceLocation resourceLocation = new ResourceLocation("weeping_angels", "names.json");
            InputStream stream = ServerLifecycleHooks.getCurrentServer().getServerResources().f_206584_().m_142591_(resourceLocation).m_6679_();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            reader.close();
            stream.close();
            String[] names = (String[])BlockEntitySignTextStrictJsonFix.f_14861_.fromJson(sb.toString(), String[].class);
            if (names != null) {
                USERNAMES = names;
            }
        }
    }
}

