/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.common.variants;

import java.util.function.Predicate;
import java.util.function.Supplier;
import mc.craig.software.angels.common.entities.WeepingAngel;
import mc.craig.software.angels.common.variants.AbstractVariant;
import mc.craig.software.angels.common.variants.BaseVariant;
import mc.craig.software.angels.common.variants.MiningVariant;
import mc.craig.software.angels.utils.AngelUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

public class AngelTypes {
    public static final DeferredRegister<AbstractVariant> VARIANTS = DeferredRegister.create(AbstractVariant.class, (String)"weeping_angels");
    public static final RegistryObject<AbstractVariant> GOLD = VARIANTS.register("gold", () -> new MiningVariant(() -> new ItemStack((ItemLike)Blocks.f_49995_), 25));
    public static final RegistryObject<AbstractVariant> DIAMOND = VARIANTS.register("diamond", () -> new MiningVariant(() -> new ItemStack((ItemLike)Blocks.f_50089_), 5));
    public static final RegistryObject<AbstractVariant> IRON = VARIANTS.register("iron", () -> new MiningVariant(() -> new ItemStack((ItemLike)Blocks.f_49996_), 50));
    public static final RegistryObject<AbstractVariant> MOSSY = VARIANTS.register("mossy", () -> new BaseVariant(() -> new ItemStack((ItemLike)Blocks.f_50079_), 45));
    public static final RegistryObject<AbstractVariant> NORMAL = VARIANTS.register("normal", () -> new BaseVariant(() -> new ItemStack((ItemLike)Blocks.f_50652_), 45));
    public static Predicate<WeepingAngel> BANNED_FROM_OVERWORLD = weepingAngelEntity -> {
        if (weepingAngelEntity.f_19853_.m_46472_() != Level.f_46429_) {
            weepingAngelEntity.setVarient((AbstractVariant)((Object)((Object)NORMAL.get())));
        }
        return false;
    };
    public static final RegistryObject<AbstractVariant> BASALT = VARIANTS.register("basalt", () -> new MiningVariant(() -> new ItemStack((ItemLike)Blocks.f_50137_), 30, BANNED_FROM_OVERWORLD));
    public static final RegistryObject<AbstractVariant> RUSTED = VARIANTS.register("rusted", () -> new BaseVariant(() -> new ItemStack((ItemLike)Blocks.f_50122_), 45));
    public static final RegistryObject<AbstractVariant> RUSTED_NO_ARM = VARIANTS.register("rusted_no_arm", () -> new BaseVariant(() -> new ItemStack((ItemLike)Blocks.f_50122_), 45));
    public static final RegistryObject<AbstractVariant> RUSTED_NO_WING = VARIANTS.register("rusted_no_wing", () -> new BaseVariant(() -> new ItemStack((ItemLike)Blocks.f_50122_), 45));
    public static final RegistryObject<AbstractVariant> RUSTED_NO_HEAD = VARIANTS.register("rusted_no_head", () -> new BaseVariant(() -> new ItemStack((ItemLike)Blocks.f_50122_), 45).setHeadless(true));
    public static final RegistryObject<AbstractVariant> DIRT = VARIANTS.register("dirt", () -> new BaseVariant(() -> new ItemStack((ItemLike)Blocks.f_50493_), 10));
    public static final RegistryObject<AbstractVariant> EMERALD = VARIANTS.register("emerald", () -> new MiningVariant(() -> new ItemStack((ItemLike)Blocks.f_50264_), 20));
    public static final RegistryObject<AbstractVariant> COPPER = VARIANTS.register("copper", () -> new MiningVariant(() -> new ItemStack((ItemLike)Blocks.f_152505_), 20));
    public static final RegistryObject<AbstractVariant> LAPIS = VARIANTS.register("lapis_lazuli", () -> new MiningVariant(() -> new ItemStack((ItemLike)Blocks.f_50059_), 10));
    public static Predicate<WeepingAngel> FREE_REIGN = weepingAngelEntity -> true;
    public static final RegistryObject<AbstractVariant> QUARTZ = VARIANTS.register("quartz", () -> new MiningVariant(() -> new ItemStack((ItemLike)Blocks.f_50331_), 30, FREE_REIGN));
    public static Predicate<WeepingAngel> BANNED_FROM_NETHER = weepingAngelEntity -> {
        if (weepingAngelEntity.f_19853_.m_46472_() == Level.f_46429_) {
            weepingAngelEntity.setVarient(AngelUtil.RAND.nextBoolean() ? (AbstractVariant)((Object)((Object)BASALT.get())) : (AbstractVariant)((Object)((Object)QUARTZ.get())));
        }
        return false;
    };
    public static Supplier<IForgeRegistry<AbstractVariant>> VARIANTS_REGISTRY = VARIANTS.makeRegistry("angel_types", () -> new RegistryBuilder().setMaxID(0x7FFFFFFE));
}

