/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import mc.craig.software.angels.common.WAObjects;
import net.minecraft.ChatFormatting;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;

public class WALangEnglish
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<String, String> data = new TreeMap<String, String>();

    public void addTranslations() {
        this.add((Block)WAObjects.Blocks.SNOW_ANGEL.get(), "Angel hiding in Snow");
        this.add((Block)WAObjects.Blocks.STATUE.get(), "Statue (Weeping Angel)");
        this.add((Block)WAObjects.Blocks.PLINTH.get(), "Plinth (Weeping Angel)");
        this.add((Block)WAObjects.Blocks.KONTRON_ORE.get(), "Kontron Ore");
        this.add((Block)WAObjects.Blocks.KONTRON_ORE_DEEPSLATE.get(), "Deepslate Kontron Ore");
        this.add((Block)WAObjects.Blocks.COFFIN.get(), "Coffin");
        this.add((Block)WAObjects.Blocks.WALL_ARM.get(), "Arms");
        this.add((Item)WAObjects.Items.ANGEL_SPAWNER.get(), "Weeping Angel (%s)");
        this.add((Item)WAObjects.Items.CHRONODYNE_GENERATOR.get(), "Chronodyne Generator");
        this.add((Item)WAObjects.Items.KONTRON_INGOT.get(), "Kontron Ingot");
        this.add((Item)WAObjects.Items.TIMEY_WIMEY_DETECTOR.get(), "Timey Wimey Detector");
        this.add((Item)WAObjects.Items.CHISEL.get(), "Chisel");
        this.add((Item)WAObjects.Items.SALLY.get(), "Music Disc");
        this.add((Item)WAObjects.Items.TIME_PREVAILS.get(), "Music Disc");
        this.add("item.weeping_angels.music_disc_sally.desc", "Sally Sparrow");
        this.add("item.weeping_angels.music_disc_time_prevails.desc", "Time Prevails");
        this.add((EntityType)WAObjects.EntityEntries.WEEPING_ANGEL.get(), "Weeping Angel");
        this.add((EntityType)WAObjects.EntityEntries.CHRONODYNE_GENERATOR.get(), "Chronodyne Generator");
        this.add((EntityType)WAObjects.EntityEntries.ANOMALY.get(), "Anomaly");
        this.add("tooltip.weeping_angels.chisel", ChatFormatting.BLUE + "Edit Statue/Plinth");
        this.add("tooltip.weeping_angels.chisel_right_click", ChatFormatting.BLUE + "- Right click to change angel pose");
        this.add("tooltip.weeping_angels.chisel_sneak", ChatFormatting.BLUE + "- Sneak + Right click to Change Angel Type");
        this.add("tooltip.weeping_angels.punch_variant", ChatFormatting.BLUE + "- Left click to change variant");
        this.add("source.weeping_angels.backintime", "%s was sent back in time by a Angel!");
        this.add("source.weeping_angels.neck_snap", "%s had their neck snapped by a Angel!");
        this.add("source.weeping_angels.punch_stone", "%s broke their bones by punching stone...");
        this.add("itemGroup.angels", "Weeping Angels");
        this.add("config.weeping_angels.teleportRange", "Teleport range");
        this.add("config.weeping_angels.teleport_entities", "Teleport Entities?");
        this.add("config.weeping_angels.angel_locking", "Angel on Angel, Quantum locking");
        this.add("config.weeping_angels.angeldimteleport", "Angel inter-dimensional teleporting");
        this.add("config.weeping_angels.block_break_range", "Block break Range");
        this.add("config.weeping_angels.chicken_go_boom", "Chicken Explosions?");
        this.add("config.weeping_angels.max_spawn", "Angel - Maximum spawn");
        this.add("config.weeping_angels.spawn_probability", "Spawn Probability");
        this.add("config.weeping_angels.min_spawn", "Angel - Minimum Spawn");
        this.add("config.weeping_angels.angel.block_break", "Block breaking");
        this.add("config.weeping_angels.blowout_torch", "Blow out torch");
        this.add("config.weeping_angels.genCatacombs", "Gen catacombs?");
        this.add("config.weeping_angels.chanceGenCatacombs", "Chance to generate a catacomb");
        this.add("config.weeping_angels.teleport_instant", "Just teleport & No Damage?");
        this.add("config.weeping_angels.spawntype", "Spawn type");
        this.add("config.weeping_angels.angel_speed", "Angel Speed");
        this.add("config.weeping_angels.disallowed_blocks", "A list of blocks angels should NOT break.");
        this.add("config.weeping_angels.disallowed_dimensions", "A list of dimensions angels should NOT go to.");
        this.add("config.weeping_angels.angel_move_sound", "Toggle movement sounds for the angels");
        this.add("config.weeping_angels.angel_seen_sound", "Toggle seen sounds for the angels");
        this.add("config.weeping_angels.teleport_type", "The Teleport type");
        this.add("config.weeping_angels.allowed_spawn_dimensions", "A list of dimensions where angels SHOULD spawn");
        this.add("config.weeping_angels.ql", "Angel on Angel freezing");
        this.add("config.weeping_angels.pickaxe_only", "Pickaxes and generators only?");
        this.add("config.weeping_angels.angel_xp_value", "XP gained from Angels");
        this.add("config.weeping_angels.angel_damage", "Damaged gained from angels");
        this.add("config.weeping_angels.around_player_range", "Angel target range");
        this.add("config.weeping_angels.moveSpeed", "Angel move Speed");
        this.add("config.weeping_angels.transparent_blocks", "Angel Observable Blocks");
        this.add("config.weeping_angels.santa_hat", "Santa Hats?");
        this.add("category.weeping_angels.angels", "Angels");
        this.add("category.weeping_angels.spawn", "Spawn Rates");
        this.add("category.weeping_angels.worldgen", "World Generation");
        this.add("texvar.weeping_angels.yellow_windows", "2005 - Yellow Windows");
        this.add("texvar.weeping_angels.blue_windows", "2005 - Blue Windows");
        this.add("texvar.weeping_angels.battle", "2005 - Battle");
        this.add("texvar.weeping_angels.damaged", "2005 - Damaged");
        this.add("texvar.weeping_angels.yellow_darker", "2005 - Yellow Windows - Darker");
        this.add("exterior.weeping_angels.2005_exterior", "2005 Exterior");
        this.add("exterior.weeping_angels.2005exterior", "2005 Exterior");
        this.add("message.weeping_angels.2005_schematic", "Schematic Obtained! Don't Blink and Run!");
        this.addSound((SoundEvent)WAObjects.Sounds.ANGEL_AMBIENT.get(), "Angel ambiance");
        this.addSound((SoundEvent)WAObjects.Sounds.STONE_SCRAPE.get(), "Stone scrapings");
        this.addSound((SoundEvent)WAObjects.Sounds.ANGEL_DEATH.get(), "Angel crumbles to death");
        this.addSound((SoundEvent)WAObjects.Sounds.ANGEL_MOCKING.get(), "Angel mocks");
        this.addSound((SoundEvent)WAObjects.Sounds.ANGEL_NECK_SNAP.get(), "Players neck snaps");
        this.addSound((SoundEvent)WAObjects.Sounds.ANGEL_SEEN.get(), "Angel seen");
        this.addSound((SoundEvent)WAObjects.Sounds.BLOW.get(), "Angel blows");
        this.addSound((SoundEvent)WAObjects.Sounds.CATACOMB.get(), "Catacomb Ambience");
        this.addSound((SoundEvent)WAObjects.Sounds.CHILD_RUN.get(), "Child running");
        this.addSound((SoundEvent)WAObjects.Sounds.DING.get(), "Ding!");
        this.addSound((SoundEvent)WAObjects.Sounds.DISC_SALLY.get(), "Sally");
        this.addSound((SoundEvent)WAObjects.Sounds.DISC_TIME_PREVAILS.get(), "Time prevails");
        this.addSound((SoundEvent)WAObjects.Sounds.KNOCK.get(), "Knocking");
        this.addSound((SoundEvent)WAObjects.Sounds.LAUGHING_CHILD.get(), "Laughing Child");
        this.addSound((SoundEvent)WAObjects.Sounds.LIGHT_BREAK.get(), "Lighting breaking");
        this.addSound((SoundEvent)WAObjects.Sounds.TELEPORT.get(), "Angel Teleports an Entity");
        this.addSound((SoundEvent)WAObjects.Sounds.TARDIS_TAKEOFF.get(), "Tardis Takeoff");
        this.addSound((SoundEvent)WAObjects.Sounds.PROJECTOR.get(), "Whirr");
    }

    public void m_6865_(HashCache p_123925_) throws IOException {
        this.addTranslations();
    }

    public String m_6055_() {
        return "Crowdin";
    }

    public void addSound(SoundEvent soundEvent, String lang) {
        this.add("sound.weeping_angels." + soundEvent.m_11660_().m_135815_(), lang);
    }

    public void addBlock(Supplier<? extends Block> key, String name) {
        this.add(key.get(), name);
    }

    public void add(Block key, String name) {
        this.add(key.m_7705_(), name);
    }

    public void addItem(Supplier<? extends Item> key, String name) {
        this.add(key.get(), name);
    }

    public void add(Item key, String name) {
        this.add(key.m_5524_(), name);
    }

    public void addItemStack(Supplier<ItemStack> key, String name) {
        this.add(key.get(), name);
    }

    public void add(ItemStack key, String name) {
        this.add(key.m_41778_(), name);
    }

    public void addEnchantment(Supplier<? extends Enchantment> key, String name) {
        this.add(key.get(), name);
    }

    public void add(Enchantment key, String name) {
        this.add(key.m_44704_(), name);
    }

    public void addEffect(Supplier<? extends MobEffect> key, String name) {
        this.add(key.get(), name);
    }

    public void add(MobEffect key, String name) {
        this.add(key.m_19481_(), name);
    }

    public void addEntityType(Supplier<? extends EntityType<?>> key, String name) {
        this.add(key.get(), name);
    }

    public void add(EntityType<?> key, String name) {
        this.add(key.m_20675_(), name);
    }

    public void add(String key, String value) {
        if (this.data.put(key, value) != null) {
            throw new IllegalStateException("Duplicate translation key " + key);
        }
    }
}

