/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Supplier;
import mc.craig.software.angels.common.WAObjects;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class WALootTables
extends LootTableProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public WALootTables(DataGenerator gen) {
        super(gen);
        this.generator = gen;
    }

    public static Path getPath(Path path, ResourceLocation rl) {
        return path.resolve("data/" + rl.m_135827_() + "/loot_tables/blocks/" + rl.m_135815_() + ".json");
    }

    public void m_6865_(HashCache cache) {
        Path path = this.generator.m_123916_();
        for (Block block : ForgeRegistries.BLOCKS.getValues()) {
            if (!block.getRegistryName().m_135827_().equalsIgnoreCase("weeping_angels") || block == WAObjects.Blocks.KONTRON_ORE.get()) continue;
            try {
                this.generateSelfTable(block, cache, path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String m_6055_() {
        return "Loot Tables";
    }

    public void generateSelfTable(Block block, HashCache cache, Path base) throws IOException {
        this.generateTable(cache, WALootTables.getPath(base, block.getRegistryName()), () -> this.createBlockDropSelf(block));
    }

    public void generateTable(HashCache cache, Path path, Supplier<JsonElement> element) throws IOException {
        DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)element.get(), (Path)path);
    }

    public JsonElement createBlockDropGuarantied(Block block, ResourceLocation drop) {
        JsonObject root = new JsonObject();
        root.add("type", (JsonElement)new JsonPrimitive("minecraft:block"));
        JsonArray pool = new JsonArray();
        JsonObject first = new JsonObject();
        first.add("name", (JsonElement)new JsonPrimitive(block.getRegistryName().toString()));
        first.add("rolls", (JsonElement)new JsonPrimitive((Number)1));
        JsonArray entries = new JsonArray();
        JsonObject entry = new JsonObject();
        entry.add("type", (JsonElement)new JsonPrimitive("minecraft:item"));
        entry.add("name", (JsonElement)new JsonPrimitive(drop.toString()));
        entries.add((JsonElement)entry);
        first.add("entries", (JsonElement)entries);
        pool.add((JsonElement)first);
        root.add("pools", (JsonElement)pool);
        return root;
    }

    public JsonElement createBlockDropSelf(Block block) {
        return this.createBlockDropGuarantied(block, block.getRegistryName());
    }
}

