/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.network;

import mc.craig.software.angels.network.messages.MessageCatacomb;
import mc.craig.software.angels.network.messages.MessageSFX;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.server.ServerLifecycleHooks;

public class Network {
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    public static final SimpleChannel INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("weeping_angels", "main_channel")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    public static int MESSAGE_COUNTER = 0;

    public static void init() {
        INSTANCE.messageBuilder(MessageSFX.class, Network.nextId(), NetworkDirection.PLAY_TO_CLIENT).encoder(MessageSFX::encode).decoder(MessageSFX::decode).consumer(MessageSFX.Handler::handle).add();
        INSTANCE.messageBuilder(MessageCatacomb.class, Network.nextId(), NetworkDirection.PLAY_TO_CLIENT).encoder(MessageCatacomb::encode).decoder(MessageCatacomb::decode).consumer(MessageCatacomb.Handler::handle).add();
    }

    private static int nextId() {
        return ++MESSAGE_COUNTER;
    }

    public static void sendToServer(Object msg) {
        INSTANCE.sendToServer(msg);
    }

    public static void sendTo(Object msg, ServerPlayer player) {
        if (!(player instanceof FakePlayer)) {
            INSTANCE.sendTo(msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static void sendPacketToAll(Object packet) {
        for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
            Network.sendTo(packet, player);
        }
    }
}

