/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.utils;

import java.util.Calendar;
import java.util.List;
import java.util.Random;
import mc.craig.software.angels.common.WAObjects;
import mc.craig.software.angels.common.blockentities.CoffinBlockEntity;
import mc.craig.software.angels.common.blockentities.SnowAngelBlockEntity;
import mc.craig.software.angels.common.entities.AngelType;
import mc.craig.software.angels.common.entities.QuantumLockedLifeform;
import mc.craig.software.angels.common.entities.WeepingAngel;
import mc.craig.software.angels.common.level.WAFeatures;
import mc.craig.software.angels.common.variants.AbstractVariant;
import mc.craig.software.angels.utils.PlayerUtil;
import mc.craig.software.angels.utils.TagUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class AngelUtil {
    public static TagKey<Item> THEFT = AngelUtil.makeItem("weeping_angels", "angel_theft");
    public static TagKey<Item> HELD_LIGHT_ITEMS = AngelUtil.makeItem("weeping_angels", "held_light_items");
    public static TagKey<Block> BANNED_BLOCKS = AngelUtil.makeBlock("weeping_angels", "angel_proof");
    public static TagKey<Block> POTTED_PLANTS = AngelUtil.makeBlock("weeping_angels", "grave_plants");
    public static TagKey<Block> ANGEL_IGNORE = AngelUtil.makeBlock("weeping_angels", "angel_ignore");
    public static TagKey<Biome> STRUCTURE_SPAWNS = AngelUtil.makeBiome("weeping_angels", "has_structure/angel_structure_biomes");
    public static TagKey<Biome> ANGEL_SPAWNS = AngelUtil.makeBiome("weeping_angels", "angel_spawns");
    public static TagKey<ConfiguredStructureFeature<?, ?>> TELEPORT_STRUCTURES = AngelUtil.makeStructure("weeping_angels", "teleport_structures");
    public static TagKey<ConfiguredStructureFeature<?, ?>> CATACOMBS = AngelUtil.makeStructure("weeping_angels", "haunted_structures");
    public static Random RAND = new Random();

    public static TagKey<Item> makeItem(String domain, String path) {
        return ItemTags.create((ResourceLocation)new ResourceLocation(domain, path));
    }

    public static TagKey<Block> makeBlock(String domain, String path) {
        return BlockTags.create((ResourceLocation)new ResourceLocation(domain, path));
    }

    public static TagKey<ConfiguredStructureFeature<?, ?>> makeStructure(String domain, String path) {
        return TagKey.m_203882_((ResourceKey)Registry.f_122882_, (ResourceLocation)new ResourceLocation(domain, path));
    }

    public static TagKey<Biome> makeBiome(String domain, String path) {
        return TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation(domain, path));
    }

    public static boolean isDarkForPlayer(QuantumLockedLifeform angel, LivingEntity living) {
        return !living.m_21023_(MobEffects.f_19611_) && angel.f_19853_.m_7146_(angel.m_142538_()) <= 0 && !angel.f_19853_.m_6042_().m_63946_() && !AngelUtil.handLightCheck(living);
    }

    public static void updateBlock(LivingEntity entity, BlockPos pos, BlockState blockState, boolean breakBlock) {
        if (!entity.f_19853_.f_46443_) {
            ServerLevel serverWorld = (ServerLevel)entity.f_19853_;
            serverWorld.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockState), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 0, 0.0, 0.0, 0.0, 0.0);
            serverWorld.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), blockState.m_60734_().m_49962_(blockState).m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f);
            if (breakBlock) {
                Containers.m_18992_((Level)entity.f_19853_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)new ItemStack((ItemLike)entity.f_19853_.m_8055_(pos).m_60734_()));
            }
            entity.f_19853_.m_7731_(pos, blockState, 2);
        }
    }

    public static boolean handLightCheck(LivingEntity player) {
        for (Object o : TagUtil.getValues((Registry)Registry.f_122827_, HELD_LIGHT_ITEMS)) {
            Holder value = (Holder)o;
            if (!PlayerUtil.isInEitherHand(player, (Item)value.m_203334_())) continue;
            return true;
        }
        return false;
    }

    public static boolean isOutsideOfBorder(Level world, BlockPos p) {
        return !world.m_6857_().m_61937_(p);
    }

    public static int secondsToTicks(int seconds) {
        return 20 * seconds;
    }

    public static void extinguishHand(ServerPlayer playerMP, WeepingAngel angel) {
        if (playerMP.m_20280_((Entity)angel) < 1.0) {
            for (InteractionHand enumHand : InteractionHand.values()) {
                ItemStack stack = playerMP.m_21120_(enumHand);
                if (!AngelUtil.lightCheck(stack, angel)) continue;
                stack.m_41774_(1);
                angel.m_5496_((SoundEvent)WAObjects.Sounds.BLOW.get(), 1.0f, 1.0f);
                return;
            }
        }
    }

    public static int getLightValue(Block block) {
        return block.m_49966_().m_60791_();
    }

    private static boolean lightCheck(ItemStack stack, WeepingAngel angel) {
        if (stack.m_204117_(HELD_LIGHT_ITEMS)) {
            angel.m_19983_(stack);
            return true;
        }
        return false;
    }

    public static AngelType randomType() {
        int pick = RAND.nextInt(AngelType.values().length);
        return AngelType.values()[pick];
    }

    public static SnowAngelBlockEntity.SnowAngelStages randowSnowStage() {
        int pick = RAND.nextInt(SnowAngelBlockEntity.SnowAngelStages.values().length);
        return SnowAngelBlockEntity.SnowAngelStages.values()[pick];
    }

    public static CoffinBlockEntity.Coffin randomCoffin() {
        CoffinBlockEntity.Coffin[] coffins = new CoffinBlockEntity.Coffin[]{CoffinBlockEntity.Coffin.NEW, CoffinBlockEntity.Coffin.WEATHERED, CoffinBlockEntity.Coffin.SLIGHTLY_WEATHERED, CoffinBlockEntity.Coffin.HEAVILY_WEATHERED};
        int pick = RAND.nextInt(coffins.length);
        return coffins[pick];
    }

    public static int getFortuneModifier(LivingEntity entityIn) {
        return EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44987_, (LivingEntity)entityIn);
    }

    public static LootItemFunctionType registerFunction(ResourceLocation resourceLocation, Serializer<? extends LootItemFunction> serialiser) {
        return (LootItemFunctionType)Registry.m_122965_((Registry)Registry.f_122876_, (ResourceLocation)resourceLocation, (Object)new LootItemFunctionType(serialiser));
    }

    public static void dropEntityLoot(Entity target, Player attacker) {
        AbstractVariant variant;
        WeepingAngel weepingAngel;
        LivingEntity targeted = (LivingEntity)target;
        ResourceLocation resourcelocation = targeted.m_5743_();
        LootTable loot_table = target.f_19853_.m_142572_().m_129898_().m_79217_(resourcelocation);
        LootContext.Builder lootContextBuilder = AngelUtil.getLootContextBuilder(true, DamageSource.f_19318_, targeted, attacker);
        LootContext ctx = lootContextBuilder.m_78975_(LootContextParamSets.f_81415_);
        List generatedTable = loot_table.m_79129_(ctx);
        if (target instanceof WeepingAngel && (weepingAngel = (WeepingAngel)target).getAngelType() == AngelType.DISASTER_MC && (variant = weepingAngel.getVariant()).shouldDrop(DamageSource.m_19344_((Player)attacker), weepingAngel)) {
            weepingAngel.m_19998_((ItemLike)variant.stackDrop().m_41720_());
        }
        generatedTable.forEach(arg_0 -> ((Entity)target).m_19983_(arg_0));
    }

    public static LootContext.Builder getLootContextBuilder(boolean p_213363_1_, DamageSource damageSourceIn, LivingEntity entity, Player attacker) {
        LootContext.Builder builder = new LootContext.Builder((ServerLevel)entity.f_19853_).m_78977_(entity.f_19853_.f_46441_).m_78972_(LootContextParams.f_81455_, (Object)entity).m_78972_(LootContextParams.f_81460_, (Object)entity.m_20182_()).m_78972_(LootContextParams.f_81457_, (Object)damageSourceIn).m_78984_(LootContextParams.f_81458_, (Object)damageSourceIn.m_7639_()).m_78984_(LootContextParams.f_81459_, (Object)damageSourceIn.m_7640_());
        if (p_213363_1_ && entity.m_21232_() != null) {
            attacker = (Player)entity.m_21232_();
            builder = builder.m_78972_(LootContextParams.f_81456_, (Object)attacker).m_78963_(attacker.m_36336_());
        }
        return builder;
    }

    public static boolean isInCatacomb(LivingEntity playerEntity) {
        ServerLevel serverWorld;
        boolean isCatacomb;
        Level level = playerEntity.f_19853_;
        if (level instanceof ServerLevel && (isCatacomb = (serverWorld = (ServerLevel)level).m_8595_().m_207785_(playerEntity.m_142538_(), AngelUtil.getConfigured(serverWorld, WAFeatures.CATACOMB.getId())).m_73603_())) {
            BoundingBox box = serverWorld.m_8595_().m_207785_(playerEntity.m_142538_(), AngelUtil.getConfigured(serverWorld, WAFeatures.CATACOMB.getId())).m_73601_();
            return AngelUtil.intersects(playerEntity.m_142469_(), new Vec3((double)box.m_162395_(), (double)box.m_162396_(), (double)box.m_162398_()), new Vec3((double)box.m_162399_(), (double)box.m_162400_(), (double)box.m_162401_()));
        }
        return false;
    }

    public static boolean intersects(AABB bb, Vec3 min, Vec3 max) {
        return bb.m_82314_(Math.min(min.f_82479_, max.f_82479_), Math.min(min.f_82480_, max.f_82480_), Math.min(min.f_82481_, max.f_82481_), Math.max(min.f_82479_, max.f_82479_), Math.max(min.f_82480_, max.f_82480_), Math.max(min.f_82481_, max.f_82481_));
    }

    public static boolean isHalloween() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == 9;
    }

    public static ConfiguredStructureFeature<?, ?> getConfigured(ServerLevel level, ResourceLocation resourceLocation) {
        Registry registry = level.m_5962_().m_175515_(Registry.f_122882_);
        return (ConfiguredStructureFeature)registry.m_7745_(resourceLocation);
    }

    public static enum EnumTeleportType {
        RANDOM_PLACE,
        DONT,
        STRUCTURE;

    }
}

