/*
 * Decompiled with CFR 0.152.
 */
package mc.craig.software.angels.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import javax.net.ssl.HttpsURLConnection;
import mc.craig.software.angels.client.renders.Donator;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PlayerUtil {
    public static boolean isInHand(InteractionHand hand, LivingEntity holder, Item item) {
        ItemStack heldItem = holder.m_21120_(hand);
        return heldItem.m_41720_() == item;
    }

    public static boolean isInMainHand(LivingEntity holder, Item item) {
        return PlayerUtil.isInHand(InteractionHand.MAIN_HAND, holder, item);
    }

    public static boolean isInOffHand(LivingEntity holder, Item item) {
        return PlayerUtil.isInHand(InteractionHand.OFF_HAND, holder, item);
    }

    public static boolean isInEitherHand(LivingEntity holder, Item item) {
        return PlayerUtil.isInMainHand(holder, item) || PlayerUtil.isInOffHand(holder, item);
    }

    public static boolean isInOneHand(LivingEntity holder, Item item) {
        boolean mainHand = PlayerUtil.isInMainHand(holder, item) && !PlayerUtil.isInOffHand(holder, item);
        boolean offHand = PlayerUtil.isInOffHand(holder, item) && !PlayerUtil.isInMainHand(holder, item);
        return mainHand || offHand;
    }

    public static void sendMessageToPlayer(Player player, TranslatableComponent textComponent, boolean isHotBar) {
        if (player.f_19853_.f_46443_) {
            return;
        }
        player.m_5661_((Component)textComponent, isHotBar);
    }

    public static Donator[] getDonators() {
        ArrayList<Donator> donators = new ArrayList<Donator>();
        JsonObject result = null;
        try {
            result = PlayerUtil.getResponse(new URL("https://mc-api.craig.software/vips"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (result != null && result.has("data")) {
            JsonArray data = result.getAsJsonArray("data");
            for (int i = 0; i < data.size(); ++i) {
                JsonObject donatorData = data.get(i).getAsJsonObject();
                String mcName = donatorData.get("mc_name").getAsString();
                String uuid = donatorData.get("uuid").getAsString();
                String vipType = donatorData.get("vip_type").getAsString();
                JsonObject wings = donatorData.getAsJsonObject("wings");
                boolean wingsPerked = wings.get("perked").getAsBoolean();
                String wingsVariant = wings.get("variant").getAsString();
                String wingsModel = wings.get("model").getAsString();
                Donator donator = new Donator(mcName, uuid, vipType, wingsPerked, wingsVariant, wingsModel);
                donators.add(donator);
            }
        }
        return donators.toArray(new Donator[0]);
    }

    public static JsonObject getResponse(URL url) throws IOException {
        HttpsURLConnection uc = (HttpsURLConnection)url.openConnection();
        uc.connect();
        uc = (HttpsURLConnection)url.openConnection();
        uc.addRequestProperty("User-Agent", "User-Agent");
        InputStream inputStream = uc.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        return GsonHelper.m_13859_((Reader)br);
    }
}

