/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigapiport.fabric.impl.client;

import fuzs.forgeconfigapiport.fabric.impl.client.commands.FabricConfigCommand;
import fuzs.forgeconfigapiport.fabric.impl.network.ConfigSync;
import fuzs.forgeconfigapiport.fabric.impl.network.payload.ConfigFilePayload;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;

public class ForgeConfigAPIPortFabricClient
implements ClientModInitializer {
    public void onInitializeClient() {
        ForgeConfigAPIPortFabricClient.registerMessages();
        ForgeConfigAPIPortFabricClient.registerEventHandlers();
    }

    private static void registerMessages() {
        ClientConfigurationNetworking.registerGlobalReceiver(ConfigFilePayload.TYPE, (payload, context) -> ConfigSync.receiveSyncedConfig(payload.contents(), payload.fileName()));
        ClientConfigurationConnectionEvents.COMPLETE.register((handler, client) -> ConfigSync.handleClientLoginSuccess());
    }

    private static void registerEventHandlers() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> FabricConfigCommand.register(dispatcher, FabricClientCommandSource::sendFeedback));
    }
}

