/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigapiport.impl.integration.configured;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.collect.ImmutableList;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.ValueEntry;
import fuzs.forgeconfigapiport.impl.integration.configured.ForgeEnumValue;
import fuzs.forgeconfigapiport.impl.integration.configured.ForgeListValue;
import fuzs.forgeconfigapiport.impl.integration.configured.ForgeValue;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraftforge.common.ForgeConfigSpec;

public class ForgeFolderEntry
implements IConfigEntry {
    protected final List<String> path;
    protected final UnmodifiableConfig config;
    protected final ForgeConfigSpec spec;
    protected List<IConfigEntry> entries;

    public ForgeFolderEntry(UnmodifiableConfig config, ForgeConfigSpec spec) {
        this(new ArrayList<String>(), config, spec);
    }

    public ForgeFolderEntry(List<String> path, UnmodifiableConfig config, ForgeConfigSpec spec) {
        this.path = path;
        this.config = config;
        this.spec = spec;
    }

    public List<IConfigEntry> getChildren() {
        if (this.entries == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            this.config.valueMap().forEach((s, o) -> {
                if (o instanceof UnmodifiableConfig) {
                    ArrayList<String> path = new ArrayList<String>(this.path);
                    path.add((String)s);
                    builder.add((Object)new ForgeFolderEntry(path, (UnmodifiableConfig)o, this.spec));
                } else if (o instanceof ForgeConfigSpec.ConfigValue) {
                    ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)o;
                    if (configValue.get() instanceof List) {
                        builder.add((Object)new ValueEntry((IConfigValue)new ForgeListValue(configValue, (ForgeConfigSpec.ValueSpec)this.spec.getRaw(configValue.getPath()))));
                    } else if (configValue.get() instanceof Enum) {
                        builder.add((Object)new ValueEntry(new ForgeEnumValue((ForgeConfigSpec.EnumValue)configValue, (ForgeConfigSpec.ValueSpec)this.spec.getRaw(configValue.getPath()))));
                    } else {
                        builder.add((Object)new ValueEntry(new ForgeValue(configValue, (ForgeConfigSpec.ValueSpec)this.spec.getRaw(configValue.getPath()))));
                    }
                }
            });
            this.entries = builder.build();
        }
        return this.entries;
    }

    public boolean isRoot() {
        return this.path.isEmpty();
    }

    public boolean isLeaf() {
        return false;
    }

    public IConfigValue<?> getValue() {
        return null;
    }

    public String getEntryName() {
        return ForgeValue.lastValue(this.path, "Root");
    }

    @Nullable
    public class_2561 getTooltip() {
        String tooltipKey;
        String translationKey = this.getTranslationKey();
        if (translationKey != null && class_1074.method_4663((String)(tooltipKey = translationKey + ".tooltip"))) {
            return class_2561.method_43471((String)tooltipKey);
        }
        String comment = this.spec.getLevelComment(this.path);
        if (comment != null) {
            return class_2561.method_43470((String)comment);
        }
        return null;
    }

    @Nullable
    public String getTranslationKey() {
        return this.spec.getLevelTranslationKey(this.path);
    }
}

